/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javadoc.search;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Comparator;

final class DocIndexItem {
    public static final Comparator<DocIndexItem> REFERENCE_COMPARATOR = new ReferenceComparator();
    public static final Comparator<DocIndexItem> TYPE_COMPARATOR = new TypeComparator();
    public static final Comparator<DocIndexItem> ALPHA_COMPARATOR = new AlphaComparator();
    private String text = null;
    private URL contextURL = null;
    private String spec = null;
    private String remark = null;
    private String pckg = null;
    private String declaringClass = null;
    private int iconIndex = 0;

    public DocIndexItem(String string, String string2, URL uRL, String string3) {
        this.text = string;
        this.remark = string2;
        this.contextURL = uRL;
        this.spec = string3;
        if (string3 != null) {
            int n = string3.startsWith("../") ? 3 : 0;
            int n2 = string3.lastIndexOf(47);
            n2 = n2 < 0 ? string3.length() : n2 + 1;
            this.pckg = string3.substring(n, n2);
            this.pckg = this.pckg.replace('/', '.');
        }
    }

    public URL getURL() throws MalformedURLException {
        return this.contextURL != null ? new URL(this.contextURL, this.spec) : null;
    }

    public String toString() {
        if (this.remark != null) {
            return this.text + this.remark;
        }
        return this.text;
    }

    public int getIconIndex() {
        return this.iconIndex;
    }

    public void setIconIndex(int n) {
        this.iconIndex = n;
    }

    public String getRemark() {
        return this.remark;
    }

    public void setRemark(String string) {
        this.remark = string;
    }

    public String getPackage() {
        return this.pckg == null ? "" : this.pckg;
    }

    public void setPackage(String string) {
        this.pckg = string;
    }

    public String getDeclaringClass() {
        return this.declaringClass;
    }

    public void setDeclaringClass(String string) {
        this.declaringClass = string;
    }

    public String getField() {
        return this.text != null ? this.text : "";
    }

    public void setField(String string) {
        this.text = string;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class AlphaComparator
    implements Comparator<DocIndexItem> {
        AlphaComparator() {
        }

        @Override
        public int compare(DocIndexItem docIndexItem, DocIndexItem docIndexItem2) {
            return docIndexItem.toString().compareTo(docIndexItem2.toString());
        }

        @Override
        public boolean equals(Object object) {
            return object instanceof AlphaComparator;
        }

        public int hashCode() {
            return 33;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class TypeComparator
    implements Comparator<DocIndexItem> {
        TypeComparator() {
        }

        @Override
        public int compare(DocIndexItem docIndexItem, DocIndexItem docIndexItem2) {
            return docIndexItem.getIconIndex() - docIndexItem2.getIconIndex();
        }

        @Override
        public boolean equals(Object object) {
            return object instanceof TypeComparator;
        }

        public int hashCode() {
            return -34;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class ReferenceComparator
    implements Comparator<DocIndexItem> {
        ReferenceComparator() {
        }

        @Override
        public int compare(DocIndexItem docIndexItem, DocIndexItem docIndexItem2) {
            int n = docIndexItem.getPackage().compareTo(docIndexItem2.getPackage());
            return n != 0 ? n : ALPHA_COMPARATOR.compare(docIndexItem, docIndexItem2);
        }

        @Override
        public boolean equals(Object object) {
            return object instanceof ReferenceComparator;
        }

        public int hashCode() {
            return 353;
        }
    }
}

