/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.api.remote;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.netbeans.modules.cnd.api.remote.CommandProvider;
import org.netbeans.modules.cnd.api.remote.HostInfoProvider;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.util.CommonTasksSupport;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;

public class RemoteFile
extends File {
    private final ExecutionEnvironment execEnv;

    public ExecutionEnvironment getExecutionEnvironment() {
        return this.execEnv;
    }

    public static File create(ExecutionEnvironment executionEnvironment, String string) {
        if (executionEnvironment.isLocal()) {
            return new File(string);
        }
        return new RemoteFile(executionEnvironment, string);
    }

    public static Reader createReader(File file) throws FileNotFoundException {
        if (file instanceof RemoteFile) {
            RemoteFile remoteFile = (RemoteFile)file;
            CommandProvider commandProvider = (CommandProvider)Lookup.getDefault().lookup(CommandProvider.class);
            if (remoteFile.exists() && commandProvider.run(remoteFile.getExecutionEnvironment(), "cat " + remoteFile.getPath(), null) == 0) {
                return new StringReader(commandProvider.getOutput());
            }
            throw new FileNotFoundException(remoteFile.getPath() + " wasn't found on " + remoteFile.getExecutionEnvironment());
        }
        return new FileReader(file);
    }

    private RemoteFile(ExecutionEnvironment executionEnvironment, String string) {
        super(string);
        assert (executionEnvironment.isRemote());
        this.execEnv = executionEnvironment;
    }

    public boolean exists() {
        return HostInfoProvider.fileExists(this.execEnv, this.getPath());
    }

    public boolean delete() {
        Future future = CommonTasksSupport.rmDir((ExecutionEnvironment)this.execEnv, (String)this.getPath(), (boolean)true, null);
        try {
            int n = (Integer)future.get();
            return n == 0;
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (ExecutionException executionException) {
            return false;
        }
    }

    public File[] listFiles() {
        String string;
        CommandProvider commandProvider = (CommandProvider)Lookup.getDefault().lookup(CommandProvider.class);
        if (commandProvider.run(this.execEnv, "ls -A1 \"" + this.getPath() + "\"", null) == 0 && (string = commandProvider.getOutput()) != null) {
            BufferedReader bufferedReader = new BufferedReader(new StringReader(string));
            ArrayList<RemoteFile> arrayList = new ArrayList<RemoteFile>();
            try {
                String string2;
                while ((string2 = bufferedReader.readLine()) != null) {
                    arrayList.add(new RemoteFile(this.execEnv, this.getPath() + "/" + string2));
                }
                bufferedReader.close();
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
                return null;
            }
            return arrayList.toArray(new File[arrayList.size()]);
        }
        return null;
    }

    public boolean isDirectory() {
        CommandProvider commandProvider = (CommandProvider)Lookup.getDefault().lookup(CommandProvider.class);
        return commandProvider.run(this.execEnv, "test -d \"" + this.getPath() + "\"", null) == 0;
    }

    public boolean isFile() {
        CommandProvider commandProvider = (CommandProvider)Lookup.getDefault().lookup(CommandProvider.class);
        return commandProvider.run(this.execEnv, "test -f \"" + this.getPath() + "\"", null) == 0;
    }

    public boolean canRead() {
        CommandProvider commandProvider = (CommandProvider)Lookup.getDefault().lookup(CommandProvider.class);
        return commandProvider.run(this.execEnv, "test -r \"" + this.getPath() + "\"", null) == 0;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        RemoteFile remoteFile = (RemoteFile)object;
        return !(this.execEnv == null ? remoteFile.execEnv != null : !this.execEnv.equals(remoteFile.execEnv));
    }

    public int hashCode() {
        return super.hashCode() + this.execEnv.hashCode() + 7;
    }
}

