/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.extras.api.support;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.dlight.api.datafilter.DataFilter;
import org.netbeans.modules.dlight.api.datafilter.DataFilterListener;
import org.netbeans.modules.dlight.api.datafilter.DataFilterManager;
import org.netbeans.modules.dlight.api.datafilter.support.TimeIntervalDataFilter;
import org.netbeans.modules.dlight.api.datafilter.support.TimeIntervalDataFilterFactory;
import org.netbeans.modules.dlight.extras.api.AxisMark;
import org.netbeans.modules.dlight.extras.api.AxisMarksProvider;
import org.netbeans.modules.dlight.extras.api.ViewportModel;
import org.netbeans.modules.dlight.extras.api.ViewportModelState;
import org.netbeans.modules.dlight.extras.api.support.TimeMarksProvider;
import org.netbeans.modules.dlight.extras.api.support.dragging.AbstractDraggable;
import org.netbeans.modules.dlight.extras.api.support.dragging.Draggable;
import org.netbeans.modules.dlight.extras.api.support.dragging.DraggingSupport;
import org.netbeans.modules.dlight.util.DLightMath;
import org.netbeans.modules.dlight.util.Range;
import org.netbeans.modules.dlight.util.UIThread;
import org.netbeans.modules.dlight.util.ui.DLightUIPrefs;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ViewportBar
extends JComponent
implements ChangeListener,
DataFilterListener {
    private static final long NANOS_PER_SECOND = 1000000000L;
    private static final Image VIEWPORT_HANDLE = ImageUtilities.loadImage((String)"org/netbeans/modules/dlight/extras/resources/viewport_handle.png");
    private static final Color VIEWPORT_HANDLE_COLOR = new Color(114, 138, 132);
    private static final int VIEWPORT_HANDLE_WIDTH = VIEWPORT_HANDLE.getWidth(null);
    private static final int VIEWPORT_HANDLE_HEIGHT = VIEWPORT_HANDLE.getHeight(null);
    private static final Image FILTER_HANDLE = ImageUtilities.loadImage((String)"org/netbeans/modules/dlight/extras/resources/filter_handle.png");
    private static final Color FILTER_HANDLE_COLOR = new Color(231, 111, 0);
    private static final int FILTER_HANDLE_WIDTH = FILTER_HANDLE.getWidth(null);
    private static final int FILTER_HANDLE_HEIGHT = FILTER_HANDLE.getHeight(null);
    private static final Color GRADIENT_DARK_COLOR = new Color(180, 180, 180);
    private final ViewportModel viewportModel;
    private final DataFilterManager filterManager;
    private final Draggable viewportStartMark;
    private final Draggable viewportEndMark;
    private final Draggable selectionStartMark;
    private final Draggable selectionEndMark;
    private final AxisMarksProvider timeMarksProvider;
    private final int leftMargin;
    private final int rightMargin;

    public ViewportBar(final ViewportModel viewportModel, DataFilterManager dataFilterManager, final int n, final int n2) {
        Dimension dimension = new Dimension(200, 30);
        this.setMaximumSize(new Dimension(Integer.MAX_VALUE, 30));
        this.setMinimumSize(dimension);
        this.setPreferredSize(dimension);
        this.setOpaque(true);
        this.leftMargin = n;
        this.rightMargin = n2;
        this.viewportModel = viewportModel;
        this.viewportStartMark = new AbstractDraggable(this){

            public int getPosition() {
                ViewportModelState viewportModelState = ViewportBar.this.getViewportModelState();
                return (int)DLightMath.map((long)((Long)viewportModelState.getViewport().getStart()), (long)((Long)viewportModelState.getLimits().getStart()), (long)((Long)viewportModelState.getLimits().getEnd()), (long)n, (long)(ViewportBar.this.getWidth() - n2));
            }

            protected void setPosition(int n3, boolean bl) {
                ViewportModelState viewportModelState = ViewportBar.this.getViewportModelState();
                Range<Long> range = viewportModelState.getViewport();
                Long l = DLightMath.map((long)n3, (long)n, (long)(ViewportBar.this.getWidth() - n2), (long)((Long)viewportModelState.getLimits().getStart()), (long)((Long)viewportModelState.getLimits().getEnd()));
                if (range != null && l >= (Long)range.getEnd()) {
                    return;
                }
                viewportModel.setViewport((Range<Long>)new Range((Number)l, null));
            }

            public Cursor getCursor() {
                return Cursor.getPredefinedCursor(10);
            }

            public String getTooltip() {
                return ViewportBar.getMessage("viewport.start.tooltip");
            }

            public void paint(Graphics graphics) {
                int n3 = this.getPosition();
                graphics.setColor(VIEWPORT_HANDLE_COLOR);
                graphics.drawLine(n3, 0, n3, ViewportBar.this.getHeight());
                graphics.drawImage(VIEWPORT_HANDLE, n3 - VIEWPORT_HANDLE_WIDTH / 2, 0, null);
            }

            protected Shape getShape() {
                return new Rectangle(this.getPosition() - VIEWPORT_HANDLE_WIDTH / 2, 0, VIEWPORT_HANDLE_WIDTH, VIEWPORT_HANDLE_HEIGHT);
            }
        };
        this.viewportEndMark = new AbstractDraggable(this){

            public int getPosition() {
                ViewportModelState viewportModelState = ViewportBar.this.getViewportModelState();
                return (int)DLightMath.map((long)((Long)viewportModelState.getViewport().getEnd()), (long)((Long)viewportModelState.getLimits().getStart()), (long)((Long)viewportModelState.getLimits().getEnd()), (long)n, (long)(ViewportBar.this.getWidth() - n2));
            }

            protected void setPosition(int n3, boolean bl) {
                ViewportModelState viewportModelState = ViewportBar.this.getViewportModelState();
                Range<Long> range = viewportModelState.getViewport();
                Long l = DLightMath.map((long)n3, (long)n, (long)(ViewportBar.this.getWidth() - n2), (long)((Long)viewportModelState.getLimits().getStart()), (long)((Long)viewportModelState.getLimits().getEnd()));
                if (range != null && (Long)range.getStart() >= l) {
                    return;
                }
                viewportModel.setViewport((Range<Long>)new Range(null, (Number)l));
            }

            public Cursor getCursor() {
                return Cursor.getPredefinedCursor(11);
            }

            public String getTooltip() {
                return ViewportBar.getMessage("viewport.end.tooltip");
            }

            public void paint(Graphics graphics) {
                int n3 = this.getPosition();
                graphics.setColor(VIEWPORT_HANDLE_COLOR);
                graphics.drawLine(n3, 0, n3, ViewportBar.this.getHeight());
                graphics.drawImage(VIEWPORT_HANDLE, n3 - VIEWPORT_HANDLE_WIDTH / 2, 0, null);
            }

            protected Shape getShape() {
                return new Rectangle(this.getPosition() - VIEWPORT_HANDLE_WIDTH / 2, 0, VIEWPORT_HANDLE_WIDTH, VIEWPORT_HANDLE_HEIGHT);
            }
        };
        this.viewportStartMark.setRightBound(this.viewportEndMark);
        this.viewportEndMark.setLeftBound(this.viewportStartMark);
        viewportModel.addChangeListener(this);
        this.filterManager = dataFilterManager;
        this.selectionStartMark = new AbstractDraggable(this){

            public int getPosition() {
                ViewportModelState viewportModelState = ViewportBar.this.getViewportModelState();
                Range<Long> range = ViewportBar.this.getTimeSelection();
                if (range == null) {
                    range = viewportModelState.getLimits();
                }
                return (int)DLightMath.map((long)((Long)range.getStart()), (long)((Long)viewportModelState.getLimits().getStart()), (long)((Long)viewportModelState.getLimits().getEnd()), (long)n, (long)(ViewportBar.this.getWidth() - n2));
            }

            protected void setPosition(int n3, boolean bl) {
                ViewportModelState viewportModelState = ViewportBar.this.getViewportModelState();
                Range range = ViewportBar.this.getTimeSelection();
                Long l = DLightMath.prevMultipleOf((long)1000000000L, (long)DLightMath.map((long)n3, (long)n, (long)(ViewportBar.this.getWidth() - n2), (long)((Long)viewportModelState.getLimits().getStart()), (long)((Long)viewportModelState.getLimits().getEnd())));
                l = Math.max(0L, l);
                if (range == null || l < (Long)range.getEnd()) {
                    Long l2 = range == null ? Long.MAX_VALUE : (Long)range.getEnd();
                    ViewportBar.this.setTimeSelection((Range<Long>)new Range((Number)l, (Number)l2), bl);
                }
            }

            public Cursor getCursor() {
                return Cursor.getPredefinedCursor(10);
            }

            public String getTooltip() {
                return ViewportBar.getMessage("filter.start.tooltip");
            }

            public void paint(Graphics graphics) {
                int n3 = this.getPosition();
                graphics.drawImage(FILTER_HANDLE, n3 - FILTER_HANDLE_WIDTH / 2, ViewportBar.this.getHeight() - FILTER_HANDLE_HEIGHT, null);
            }

            protected Shape getShape() {
                int n3 = this.getPosition();
                return new Rectangle(n3 - FILTER_HANDLE_WIDTH / 2, ViewportBar.this.getHeight() - FILTER_HANDLE_HEIGHT, FILTER_HANDLE_WIDTH, FILTER_HANDLE_HEIGHT);
            }
        };
        this.selectionEndMark = new AbstractDraggable(this){

            public int getPosition() {
                ViewportModelState viewportModelState = ViewportBar.this.getViewportModelState();
                Range<Long> range = ViewportBar.this.getTimeSelection();
                if (range == null) {
                    range = viewportModelState.getLimits();
                }
                return (int)DLightMath.map((long)((Long)range.getEnd()), (long)((Long)viewportModelState.getLimits().getStart()), (long)((Long)viewportModelState.getLimits().getEnd()), (long)n, (long)(ViewportBar.this.getWidth() - n2));
            }

            protected void setPosition(int n3, boolean bl) {
                ViewportModelState viewportModelState = ViewportBar.this.getViewportModelState();
                Range range = ViewportBar.this.getTimeSelection();
                Long l = n3 >= ViewportBar.this.getWidth() - n2 ? Long.valueOf(Long.MAX_VALUE) : Long.valueOf(DLightMath.nextMultipleOf((long)1000000000L, (long)DLightMath.map((long)n3, (long)n, (long)(ViewportBar.this.getWidth() - n2), (long)((Long)viewportModelState.getLimits().getStart()), (long)((Long)viewportModelState.getLimits().getEnd()))));
                if (range == null || (Long)range.getStart() < l) {
                    Long l2 = range == null ? Long.MIN_VALUE : (Long)range.getStart();
                    ViewportBar.this.setTimeSelection((Range<Long>)new Range((Number)l2, (Number)l), bl);
                }
            }

            public Cursor getCursor() {
                return Cursor.getPredefinedCursor(11);
            }

            public String getTooltip() {
                return ViewportBar.getMessage("filter.end.tooltip");
            }

            public void paint(Graphics graphics) {
                int n3 = this.getPosition();
                graphics.drawImage(FILTER_HANDLE, n3 - FILTER_HANDLE_WIDTH / 2, ViewportBar.this.getHeight() - FILTER_HANDLE_HEIGHT, null);
            }

            protected Shape getShape() {
                int n3 = this.getPosition();
                return new Rectangle(n3 - FILTER_HANDLE_WIDTH / 2, ViewportBar.this.getHeight() - FILTER_HANDLE_HEIGHT, FILTER_HANDLE_WIDTH, FILTER_HANDLE_HEIGHT);
            }
        };
        this.selectionStartMark.setRightBound(this.selectionEndMark);
        this.selectionEndMark.setLeftBound(this.selectionStartMark);
        if (this.filterManager != null) {
            this.filterManager.addDataFilterListener((DataFilterListener)this);
        }
        this.timeMarksProvider = TimeMarksProvider.newInstance();
        new DraggingSupport(this, Arrays.asList(this.viewportStartMark, this.viewportEndMark, this.selectionStartMark, this.selectionEndMark));
    }

    private ViewportModelState getViewportModelState() {
        return new ViewportModelStateWrapper(this.viewportModel.getState());
    }

    private Range<Long> getTimeSelection() {
        Collection collection;
        Collection collection2 = collection = this.filterManager == null ? null : this.filterManager.getDataFilter(TimeIntervalDataFilter.class);
        if (collection != null && !collection.isEmpty()) {
            return ((TimeIntervalDataFilter)collection.iterator().next()).getInterval();
        }
        return null;
    }

    private void setTimeSelection(Range<Long> range, boolean bl) {
        if (this.filterManager != null) {
            this.filterManager.addDataFilter((DataFilter)TimeIntervalDataFilterFactory.create(range), bl);
        }
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        int n = this.getWidth();
        int n2 = this.getHeight();
        graphics.setColor(this.getBackground());
        graphics.fillRect(0, 0, n, n2);
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        GradientPaint gradientPaint = new GradientPaint(0.0f, 0.0f, GRADIENT_DARK_COLOR, 0.0f, n2, this.getBackground());
        Paint paint = graphics2D.getPaint();
        graphics2D.setPaint(gradientPaint);
        graphics2D.fillRect(this.leftMargin, 0, n - this.leftMargin - this.rightMargin, n2);
        graphics2D.setPaint(paint);
        graphics2D.setColor(VIEWPORT_HANDLE_COLOR);
        graphics2D.drawLine(this.leftMargin, 0, this.leftMargin, n2);
        graphics2D.drawLine(n - this.rightMargin, 0, n - this.rightMargin, n2);
        int n3 = this.viewportStartMark.getPosition();
        int n4 = this.viewportEndMark.getPosition();
        graphics.setColor(this.getBackground());
        graphics.fillRect(n3, 0, n4 - n3, n2);
        graphics.setColor(DLightUIPrefs.getColor((String)"indicator.border.color"));
        graphics.fillRect(0, 0, n3, 2);
        graphics.fillRect(n4, 0, n - n4, 2);
        graphics.setFont(DLightUIPrefs.getFont((String)"indicator.x_axis.font"));
        graphics.setColor(DLightUIPrefs.getColor((String)"indicator.x_axis.font_color"));
        FontMetrics fontMetrics = graphics.getFontMetrics();
        Range<Long> range = this.getViewportModelState().getLimits();
        List<AxisMark> list = this.timeMarksProvider.getAxisMarks((Long)range.getStart(), (Long)range.getEnd(), this.getWidth() - this.leftMargin - this.rightMargin, fontMetrics);
        for (AxisMark axisMark : list) {
            graphics.drawLine(this.leftMargin + axisMark.getPosition(), 0, this.leftMargin + axisMark.getPosition(), 5);
            if (axisMark.getText() == null) continue;
            int n5 = fontMetrics.stringWidth(axisMark.getText());
            graphics.drawString(axisMark.getText(), this.leftMargin + axisMark.getPosition() - n5 / 2, 3 * fontMetrics.getAscent() / 2);
        }
        this.viewportStartMark.paint(graphics);
        this.viewportEndMark.paint(graphics);
        int n6 = this.selectionStartMark.getPosition();
        int n7 = this.selectionEndMark.getPosition();
        graphics.setColor(FILTER_HANDLE_COLOR);
        graphics.fillRect(n6, this.getHeight() - 5, n7 - n6, 5);
        this.selectionStartMark.paint(graphics);
        this.selectionEndMark.paint(graphics);
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        this.repaint();
    }

    public void dataFiltersChanged(List<DataFilter> list, boolean bl) {
        UIThread.invoke((Runnable)new Runnable(){

            public void run() {
                ViewportBar.this.repaint();
            }
        });
    }

    private static String getMessage(String string) {
        return NbBundle.getMessage(ViewportBar.class, (String)string);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ViewportModelStateWrapper
    implements ViewportModelState {
        private final Range<Long> limits;
        private final Range<Long> viewport;

        public ViewportModelStateWrapper(ViewportModelState viewportModelState) {
            this.viewport = viewportModelState.getViewport();
            this.limits = viewportModelState.getLimits().extend(this.viewport);
        }

        @Override
        public Range<Long> getLimits() {
            return this.limits;
        }

        @Override
        public Range<Long> getViewport() {
            return this.viewport;
        }
    }
}

