/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.extras.api.support;

import java.awt.FontMetrics;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.netbeans.modules.dlight.extras.api.AxisMark;
import org.netbeans.modules.dlight.extras.api.support.AbstractCachingAxisMarksProvider;
import org.netbeans.modules.dlight.util.DLightMath;
import org.netbeans.modules.dlight.util.TimeFormatter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TimeMarksProvider
extends AbstractCachingAxisMarksProvider {
    private static final long[] INTERVALS = new long[]{100000000L, 500000000L, 1000000000L, 5000000000L, 10000000000L, 30000000000L, 60000000000L, 300000000000L, 600000000000L};
    private static final String LABEL_TEXT = "99:99";
    private static final TimeFormatter TIME_FORMATTER = new TimeFormatter();

    public static TimeMarksProvider newInstance() {
        return new TimeMarksProvider();
    }

    private TimeMarksProvider() {
    }

    @Override
    protected List<AxisMark> getAxisMarksImpl(long l, long l2, int n, FontMetrics fontMetrics) {
        if (l == l2 || n < 10) {
            return Collections.emptyList();
        }
        long l3 = this.getTickInterval(l2 - l, n);
        long l4 = this.getLabelInterval(l2 - l, n, fontMetrics);
        ArrayList<AxisMark> arrayList = new ArrayList<AxisMark>();
        long l5 = l;
        while (l5 <= l2) {
            if (l5 % l3 == 0L) {
                String string = null;
                if (l5 % l4 == 0L) {
                    string = TIME_FORMATTER.format(l5);
                }
                arrayList.add(new AxisMark((int)DLightMath.map((long)l5, (long)l, (long)l2, (long)0L, (long)n), string));
            }
            l5 = DLightMath.nextMultipleOf((long)l3, (long)l5);
        }
        return arrayList;
    }

    private long getTickInterval(long l, int n) {
        float f = (float)n / (float)l;
        for (int i = 0; i < INTERVALS.length; ++i) {
            if (!(10.0f <= (float)INTERVALS[i] * f)) continue;
            return INTERVALS[i];
        }
        return INTERVALS[INTERVALS.length - 1];
    }

    private long getLabelInterval(long l, int n, FontMetrics fontMetrics) {
        float f = (float)n / (float)l;
        for (int i = 0; i < INTERVALS.length; ++i) {
            if (!((float)(4 * fontMetrics.stringWidth(LABEL_TEXT) / 3) <= (float)INTERVALS[i] * f)) continue;
            return INTERVALS[i];
        }
        return INTERVALS[INTERVALS.length - 1];
    }
}

