/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.jaxws.nodes;

import java.awt.Image;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.netbeans.api.project.Project;
import org.netbeans.modules.maven.jaxws.nodes.JaxWsClientRootChildren;
import org.netbeans.modules.websvc.project.api.WebServiceData;
import org.netbeans.spi.project.ui.PrivilegedTemplates;
import org.netbeans.spi.project.ui.support.CommonProjectActions;
import org.openide.actions.FindAction;
import org.openide.actions.PasteAction;
import org.openide.actions.PropertiesAction;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.Lookups;

public class JaxWsClientRootNode
extends AbstractNode {
    private Project project;
    private static final String SERVICES_BADGE = "org/netbeans/modules/maven/jaxws/resources/webservicegroup.png";
    private Icon folderIconCache;
    private Icon openedFolderIconCache;
    private Image cachedServicesBadge;

    public JaxWsClientRootNode(Project project, WebServiceData webServiceData) {
        super((Children)new JaxWsClientRootChildren(webServiceData), Lookups.fixed((Object[])new Object[]{project, new WsPrivilegedTemplates()}));
        this.setDisplayName(NbBundle.getBundle(JaxWsClientRootNode.class).getString("LBL_ServiceReferences"));
    }

    public Image getIcon(int n) {
        return this.computeIcon(false);
    }

    public Image getOpenedIcon(int n) {
        return this.computeIcon(true);
    }

    private Image getServicesImage() {
        if (this.cachedServicesBadge == null) {
            this.cachedServicesBadge = ImageUtilities.loadImage((String)SERVICES_BADGE);
        }
        return this.cachedServicesBadge;
    }

    private Icon getFolderIcon(boolean bl) {
        if (this.openedFolderIconCache == null) {
            Node node = DataFolder.findFolder((FileObject)FileUtil.getConfigRoot()).getNodeDelegate();
            this.openedFolderIconCache = new ImageIcon(node.getOpenedIcon(1));
            this.folderIconCache = new ImageIcon(node.getIcon(1));
        }
        if (bl) {
            return this.openedFolderIconCache;
        }
        return this.folderIconCache;
    }

    private Image computeIcon(boolean bl) {
        Icon icon = this.getFolderIcon(bl);
        Image image = ((ImageIcon)icon).getImage();
        image = ImageUtilities.mergeImages((Image)image, (Image)this.getServicesImage(), (int)7, (int)7);
        return image;
    }

    public Action[] getActions(boolean bl) {
        return new Action[]{CommonProjectActions.newFileAction(), null, SystemAction.get(FindAction.class), null, SystemAction.get(PasteAction.class), null, SystemAction.get(PropertiesAction.class)};
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    private static class WsPrivilegedTemplates
    implements PrivilegedTemplates {
        private WsPrivilegedTemplates() {
        }

        public String[] getPrivilegedTemplates() {
            return new String[]{"Templates/WebServices/WebServiceClient", "Templates/WebServices/MessageHandler.java", "Templates/WebServices/LogicalHandler.java"};
        }
    }
}

