/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.jaxws;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.maven.api.ModelUtils;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.jaxws.WSStackUtils;
import org.netbeans.modules.maven.jaxws.WsimportPomInfo;
import org.netbeans.modules.maven.model.ModelOperation;
import org.netbeans.modules.maven.model.Utilities;
import org.netbeans.modules.maven.model.pom.Build;
import org.netbeans.modules.maven.model.pom.Configuration;
import org.netbeans.modules.maven.model.pom.Dependency;
import org.netbeans.modules.maven.model.pom.POMExtensibilityElement;
import org.netbeans.modules.maven.model.pom.POMModel;
import org.netbeans.modules.maven.model.pom.POMQName;
import org.netbeans.modules.maven.model.pom.Repository;
import org.netbeans.modules.maven.model.pom.Resource;
import org.netbeans.modules.websvc.wsstack.api.WSStack;
import org.netbeans.modules.websvc.wsstack.jaxws.JaxWs;
import org.openide.filesystems.FileObject;
import org.openide.util.RequestProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MavenModelUtils {
    private static final String WSIPMORT_GENERATE_PREFIX = "wsimport-generate-";
    private static final String STALE_FILE_DIRECTORY = "${project.build.directory}/jaxws/stale/";
    private static final String STALE_FILE_EXTENSION = ".stale";
    private static final String JAXWS_GROUP_ID = "org.codehaus.mojo";
    private static final String JAXWS_ARTIFACT_ID = "jaxws-maven-plugin";
    private static final String JAXWS_PLUGIN_KEY = "org.codehaus.mojo:jaxws-maven-plugin";
    private static final String JAXWS_CATALOG = "jax-ws-catalog.xml";

    public static org.netbeans.modules.maven.model.pom.Plugin addJaxWSPlugin(POMModel pOMModel) {
        return MavenModelUtils.addJaxWSPlugin(pOMModel, null);
    }

    public static org.netbeans.modules.maven.model.pom.Plugin addJaxWSPlugin(POMModel pOMModel, String string) {
        org.netbeans.modules.maven.model.pom.Plugin plugin;
        assert (pOMModel.isIntransaction()) : "need to call model modifications under transaction.";
        Build build = pOMModel.getProject().getBuild();
        if (build == null) {
            build = pOMModel.getFactory().createBuild();
            pOMModel.getProject().setBuild(build);
        }
        if ((plugin = build.findPluginById(JAXWS_GROUP_ID, JAXWS_ARTIFACT_ID)) != null) {
            return plugin;
        }
        plugin = pOMModel.getFactory().createPlugin();
        plugin.setGroupId(JAXWS_GROUP_ID);
        plugin.setArtifactId(JAXWS_ARTIFACT_ID);
        plugin.setVersion("1.10");
        build.addPlugin(plugin);
        Configuration configuration = plugin.getConfiguration();
        if (configuration == null) {
            configuration = pOMModel.getFactory().createConfiguration();
            plugin.setConfiguration(configuration);
        }
        configuration.setSimpleParameter("sourceDestDir", "${project.build.directory}/generated-sources/jaxws-wsimport");
        configuration.setSimpleParameter("xnocompile", "true");
        configuration.setSimpleParameter("verbose", "true");
        configuration.setSimpleParameter("extension", "true");
        configuration.setSimpleParameter("catalog", "${basedir}/src/jax-ws-catalog.xml");
        if (string != null) {
            configuration.setSimpleParameter("target", string);
        }
        Dependency dependency = pOMModel.getFactory().createDependency();
        dependency.setGroupId("javax.xml");
        dependency.setArtifactId("webservices-api");
        dependency.setVersion("1.4");
        plugin.addDependency(dependency);
        return plugin;
    }

    public static org.netbeans.modules.maven.model.pom.Plugin addWarPlugin(POMModel pOMModel) {
        Configuration configuration;
        org.netbeans.modules.maven.model.pom.Plugin plugin;
        assert (pOMModel.isIntransaction()) : "need to call model modifications under transaction.";
        Build build = pOMModel.getProject().getBuild();
        if (build == null) {
            build = pOMModel.getFactory().createBuild();
            pOMModel.getProject().setBuild(build);
        }
        if ((plugin = build.findPluginById("org.apache.maven.plugins", "maven-war-plugin")) == null) {
            plugin = pOMModel.getFactory().createPlugin();
            plugin.setGroupId("org.apache.maven.plugins");
            plugin.setArtifactId("maven-war-plugin");
            plugin.setVersion("2.0.2");
            build.addPlugin(plugin);
        }
        if ((configuration = plugin.getConfiguration()) == null) {
            configuration = pOMModel.getFactory().createConfiguration();
            plugin.setConfiguration(configuration);
        }
        List list = configuration.getConfigurationElements();
        POMExtensibilityElement pOMExtensibilityElement = MavenModelUtils.findChild(configuration.getConfigurationElements(), "webResources");
        if (pOMExtensibilityElement == null) {
            pOMExtensibilityElement = pOMModel.getFactory().createPOMExtensibilityElement(POMQName.createQName((String)"webResources", (boolean)pOMModel.getPOMQNames().isNSAware()));
            configuration.addExtensibilityElement(pOMExtensibilityElement);
        }
        if (!MavenModelUtils.hasResource(pOMExtensibilityElement, JAXWS_CATALOG)) {
            POMExtensibilityElement pOMExtensibilityElement2 = pOMModel.getFactory().createPOMExtensibilityElement(POMQName.createQName((String)"resource", (boolean)pOMModel.getPOMQNames().isNSAware()));
            pOMExtensibilityElement.addExtensibilityElement(pOMExtensibilityElement2);
            POMExtensibilityElement pOMExtensibilityElement3 = pOMModel.getFactory().createPOMExtensibilityElement(POMQName.createQName((String)"directory", (boolean)pOMModel.getPOMQNames().isNSAware()));
            pOMExtensibilityElement3.setElementText("src");
            pOMExtensibilityElement2.addExtensibilityElement(pOMExtensibilityElement3);
            POMExtensibilityElement pOMExtensibilityElement4 = pOMModel.getFactory().createPOMExtensibilityElement(POMQName.createQName((String)"targetPath", (boolean)pOMModel.getPOMQNames().isNSAware()));
            pOMExtensibilityElement4.setElementText("WEB-INF");
            pOMExtensibilityElement2.addExtensibilityElement(pOMExtensibilityElement4);
            POMExtensibilityElement pOMExtensibilityElement5 = pOMModel.getFactory().createPOMExtensibilityElement(POMQName.createQName((String)"includes", (boolean)pOMModel.getPOMQNames().isNSAware()));
            pOMExtensibilityElement2.addExtensibilityElement(pOMExtensibilityElement5);
            POMExtensibilityElement pOMExtensibilityElement6 = pOMModel.getFactory().createPOMExtensibilityElement(POMQName.createQName((String)"include", (boolean)pOMModel.getPOMQNames().isNSAware()));
            pOMExtensibilityElement6.setElementText(JAXWS_CATALOG);
            pOMExtensibilityElement5.addExtensibilityElement(pOMExtensibilityElement6);
            pOMExtensibilityElement6 = pOMModel.getFactory().createPOMExtensibilityElement(POMQName.createQName((String)"include", (boolean)pOMModel.getPOMQNames().isNSAware()));
            pOMExtensibilityElement6.setElementText("wsdl/**");
            pOMExtensibilityElement5.addExtensibilityElement(pOMExtensibilityElement6);
        }
        return plugin;
    }

    public static void addWsdlResources(POMModel pOMModel) {
        assert (pOMModel.isIntransaction());
        Build build = pOMModel.getProject().getBuild();
        if (build == null) {
            return;
        }
        boolean bl = false;
        List list = build.getResources();
        if (list != null) {
            for (Resource resource : list) {
                if (!"META-INF".equals(resource.getTargetPath()) || !"src".equals(resource.getDirectory()) && !"${basedir}/src".equals(resource.getDirectory())) continue;
                bl = true;
            }
        }
        if (!bl) {
            Resource resource = pOMModel.getFactory().createResource();
            resource.setTargetPath("META-INF");
            resource.setDirectory("src");
            resource.addInclude(JAXWS_CATALOG);
            resource.addInclude("wsdl/**");
            build.addResource(resource);
        }
    }

    private static POMExtensibilityElement findChild(List<POMExtensibilityElement> list, String string) {
        for (POMExtensibilityElement pOMExtensibilityElement : list) {
            if (!string.equals(pOMExtensibilityElement.getQName().getLocalPart())) continue;
            return pOMExtensibilityElement;
        }
        return null;
    }

    private static POMExtensibilityElement findElementForValue(List<POMExtensibilityElement> list, String string) {
        for (POMExtensibilityElement pOMExtensibilityElement : list) {
            if (!string.equals(pOMExtensibilityElement.getElementText())) continue;
            return pOMExtensibilityElement;
        }
        return null;
    }

    public static void addWsimportExecution(org.netbeans.modules.maven.model.pom.Plugin plugin, String string, String string2) {
        POMModel pOMModel = plugin.getModel();
        assert (pOMModel.isIntransaction());
        org.netbeans.modules.maven.model.pom.PluginExecution pluginExecution = pOMModel.getFactory().createExecution();
        String string3 = MavenModelUtils.getUniqueId(plugin, string);
        pluginExecution.setId(WSIPMORT_GENERATE_PREFIX + string3);
        pluginExecution.setPhase("generate-sources");
        pluginExecution.addGoal("wsimport");
        plugin.addExecution(pluginExecution);
        Configuration configuration = pOMModel.getFactory().createConfiguration();
        pluginExecution.setConfiguration(configuration);
        QName qName = POMQName.createQName((String)"wsdlFiles", (boolean)pOMModel.getPOMQNames().isNSAware());
        POMExtensibilityElement pOMExtensibilityElement = pOMModel.getFactory().createPOMExtensibilityElement(qName);
        configuration.addExtensibilityElement(pOMExtensibilityElement);
        qName = POMQName.createQName((String)"wsdlFile", (boolean)pOMModel.getPOMQNames().isNSAware());
        POMExtensibilityElement pOMExtensibilityElement2 = pOMModel.getFactory().createPOMExtensibilityElement(qName);
        pOMExtensibilityElement2.setElementText(string2);
        pOMExtensibilityElement.addExtensibilityElement(pOMExtensibilityElement2);
        qName = POMQName.createQName((String)"staleFile", (boolean)pOMModel.getPOMQNames().isNSAware());
        POMExtensibilityElement pOMExtensibilityElement3 = pOMModel.getFactory().createPOMExtensibilityElement(qName);
        pOMExtensibilityElement3.setElementText(STALE_FILE_DIRECTORY + string3 + STALE_FILE_EXTENSION);
        configuration.addExtensibilityElement(pOMExtensibilityElement3);
    }

    public static void addBindingFile(POMModel pOMModel, String string, String string2) {
        assert (pOMModel.isIntransaction());
        Build build = pOMModel.getProject().getBuild();
        if (build == null) {
            return;
        }
        org.netbeans.modules.maven.model.pom.Plugin plugin = build.findPluginById(JAXWS_GROUP_ID, JAXWS_ARTIFACT_ID);
        if (plugin != null) {
            List list = plugin.getExecutions();
            String string3 = WSIPMORT_GENERATE_PREFIX + string;
            for (org.netbeans.modules.maven.model.pom.PluginExecution pluginExecution : list) {
                POMExtensibilityElement pOMExtensibilityElement;
                POMExtensibilityElement pOMExtensibilityElement2;
                if (!string3.equals(pluginExecution.getId())) continue;
                Configuration configuration = pluginExecution.getConfiguration();
                if (configuration == null) break;
                QName qName = POMQName.createQName((String)"bindingDirectory", (boolean)pOMModel.getPOMQNames().isNSAware());
                if (configuration.getChildElementText(qName) == null) {
                    pOMExtensibilityElement2 = pOMModel.getFactory().createPOMExtensibilityElement(qName);
                    pOMExtensibilityElement2.setElementText("${basedir}/src/jaxws-bindings");
                    configuration.addExtensibilityElement(pOMExtensibilityElement2);
                }
                if ((pOMExtensibilityElement2 = MavenModelUtils.findChild(configuration.getConfigurationElements(), "bindingFiles")) == null) {
                    qName = POMQName.createQName((String)"bindingFiles", (boolean)pOMModel.getPOMQNames().isNSAware());
                    pOMExtensibilityElement2 = pOMModel.getFactory().createPOMExtensibilityElement(qName);
                    configuration.addExtensibilityElement(pOMExtensibilityElement2);
                }
                if ((pOMExtensibilityElement = MavenModelUtils.findElementForValue(pOMExtensibilityElement2.getExtensibilityElements(), string2)) != null) break;
                qName = POMQName.createQName((String)"bindingFile", (boolean)pOMModel.getPOMQNames().isNSAware());
                pOMExtensibilityElement = pOMModel.getFactory().createPOMExtensibilityElement(qName);
                pOMExtensibilityElement.setElementText(string2);
                pOMExtensibilityElement2.addExtensibilityElement(pOMExtensibilityElement);
                break;
            }
        }
    }

    public static void removeWsimportExecution(POMModel pOMModel, String string) {
        assert (pOMModel.isIntransaction());
        Build build = pOMModel.getProject().getBuild();
        if (build == null) {
            return;
        }
        org.netbeans.modules.maven.model.pom.Plugin plugin = build.findPluginById(JAXWS_GROUP_ID, JAXWS_ARTIFACT_ID);
        if (plugin != null) {
            List list = plugin.getExecutions();
            for (org.netbeans.modules.maven.model.pom.PluginExecution pluginExecution : list) {
                String string2 = WSIPMORT_GENERATE_PREFIX + string;
                if (!string2.equals(pluginExecution.getId())) continue;
                plugin.removeExecution(pluginExecution);
                break;
            }
        }
    }

    public static void renameWsdlFile(POMModel pOMModel, String string, String string2, String string3, String string4) {
        assert (pOMModel.isIntransaction());
        Build build = pOMModel.getProject().getBuild();
        if (build == null) {
            return;
        }
        org.netbeans.modules.maven.model.pom.Plugin plugin = build.findPluginById(JAXWS_GROUP_ID, JAXWS_ARTIFACT_ID);
        if (plugin != null) {
            List list = plugin.getExecutions();
            String string5 = WSIPMORT_GENERATE_PREFIX + string;
            for (org.netbeans.modules.maven.model.pom.PluginExecution pluginExecution : list) {
                List list2;
                Configuration configuration = pluginExecution.getConfiguration();
                if (configuration == null || !string5.equals(pluginExecution.getId())) continue;
                POMExtensibilityElement pOMExtensibilityElement = MavenModelUtils.findChild(configuration.getConfigurationElements(), "wsdlFiles");
                if (pOMExtensibilityElement != null) {
                    list2 = pOMExtensibilityElement.getExtensibilityElements();
                    for (POMExtensibilityElement pOMExtensibilityElement2 : list2) {
                        if (!"wsdlFile".equals(pOMExtensibilityElement2.getQName().getLocalPart()) || !string3.equals(pOMExtensibilityElement2.getElementText())) continue;
                        pOMExtensibilityElement2.setElementText(string4);
                        break;
                    }
                }
                if ((list2 = MavenModelUtils.findChild(configuration.getConfigurationElements(), "staleFile")) != null) {
                    list2.setElementText(STALE_FILE_DIRECTORY + string2 + STALE_FILE_EXTENSION);
                }
                pluginExecution.setId(WSIPMORT_GENERATE_PREFIX + string2);
                break;
            }
        }
    }

    public static boolean addJaxws21Library(final Project project) {
        if (!MavenModelUtils.isJaxWs21Library(project)) {
            final boolean[] blArray = new boolean[1];
            ModelOperation<POMModel> modelOperation = new ModelOperation<POMModel>(){

                public void performOperation(POMModel pOMModel) {
                    try {
                        MavenModelUtils.addJaxws21Library(project, pOMModel);
                        blArray[0] = true;
                    }
                    catch (Exception exception) {
                        Logger.getLogger(MavenModelUtils.class.getName()).log(Level.INFO, "Cannot add Metro libbrary to pom file", exception);
                        blArray[0] = false;
                    }
                }
            };
            FileObject fileObject = project.getProjectDirectory().getFileObject("pom.xml");
            Utilities.performPOMModelOperations((FileObject)fileObject, Collections.singletonList(modelOperation));
            if (blArray[0]) {
                MavenModelUtils.addJavadoc(project);
            }
            return blArray[0];
        }
        return false;
    }

    public static void addJaxws21Library(Project project, POMModel pOMModel) {
        Repository repository;
        NbMavenProject nbMavenProject;
        Dependency dependency = ModelUtils.checkModelDependency((POMModel)pOMModel, (String)"com.sun.xml.ws", (String)"webservices-rt", (boolean)true);
        if (dependency != null) {
            dependency.setVersion("1.4");
            dependency.setScope(Artifact.SCOPE_PROVIDED);
        }
        if ((nbMavenProject = (NbMavenProject)project.getLookup().lookup(NbMavenProject.class)) != null && (repository = ModelUtils.addModelRepository((MavenProject)nbMavenProject.getMavenProject(), (POMModel)pOMModel, (String)"http://download.java.net/maven/2")) != null) {
            repository.setId("metro");
            repository.setLayout("default");
            repository.setName("Repository for library[metro]");
        }
    }

    public static boolean isJaxWs21Library(Project project) {
        ClassPath classPath;
        FileObject fileObject;
        SourceGroup[] sourceGroupArray = ProjectUtils.getSources((Project)project).getSourceGroups("java");
        return sourceGroupArray.length <= 0 || (fileObject = (classPath = ClassPath.getClassPath((FileObject)sourceGroupArray[0].getRootFolder(), (String)"classpath/compile")).findResource("javax/xml/ws/WebServiceFeature.class")) != null;
    }

    public static void addJavadoc(final Project project) {
        RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                NbMavenProject nbMavenProject = (NbMavenProject)project.getLookup().lookup(NbMavenProject.class);
                if (nbMavenProject != null) {
                    nbMavenProject.downloadDependencyAndJavadocSource();
                }
            }
        });
    }

    static List<WsimportPomInfo> getWsdlFiles(Project project) {
        MavenProject mavenProject = ((NbMavenProject)project.getLookup().lookup(NbMavenProject.class)).getMavenProject();
        assert (mavenProject != null);
        List list = mavenProject.getBuildPlugins();
        ArrayList<WsimportPomInfo> arrayList = new ArrayList<WsimportPomInfo>();
        for (Plugin plugin : list) {
            if (!JAXWS_PLUGIN_KEY.equalsIgnoreCase(plugin.getKey())) continue;
            List list2 = plugin.getExecutions();
            for (PluginExecution pluginExecution : list2) {
                String string;
                Xpp3Dom xpp3Dom;
                Xpp3Dom xpp3Dom2;
                Xpp3Dom xpp3Dom3 = (Xpp3Dom)pluginExecution.getConfiguration();
                if (xpp3Dom3 == null || (xpp3Dom2 = xpp3Dom3.getChild("wsdlFiles")) == null || (xpp3Dom = xpp3Dom2.getChild("wsdlFile")) == null) continue;
                WsimportPomInfo wsimportPomInfo = new WsimportPomInfo(xpp3Dom.getValue());
                Xpp3Dom xpp3Dom4 = xpp3Dom3.getChild("bindingFiles");
                if (xpp3Dom4 != null && (string = MavenModelUtils.findHandler(xpp3Dom4)) != null) {
                    wsimportPomInfo.setHandlerFile(string);
                }
                if ((string = pluginExecution.getId()) != null) {
                    if (string.startsWith(WSIPMORT_GENERATE_PREFIX)) {
                        wsimportPomInfo.setId(string.substring(WSIPMORT_GENERATE_PREFIX.length()));
                    } else {
                        wsimportPomInfo.setId(string);
                    }
                }
                arrayList.add(wsimportPomInfo);
            }
        }
        return arrayList;
    }

    private static String findHandler(Xpp3Dom xpp3Dom) {
        for (Xpp3Dom xpp3Dom2 : xpp3Dom.getChildren("bindingFile")) {
            String string = xpp3Dom2.getValue();
            if (string == null || !string.endsWith("_handler.xml")) continue;
            return string;
        }
        return null;
    }

    private static void updateLibraryScope(POMModel pOMModel, String string) {
        assert (pOMModel.isIntransaction()) : "need to call model modifications under transaction.";
        Dependency dependency = pOMModel.getProject().findDependencyById("com.sun.xml.ws", "webservices-rt", null);
        if (dependency != null) {
            dependency.setScope(string);
        }
    }

    static void reactOnServerChanges(Project project) {
        Object object;
        NbMavenProject nbMavenProject = (NbMavenProject)project.getLookup().lookup(NbMavenProject.class);
        List list = nbMavenProject.getMavenProject().getDependencies();
        String string = null;
        boolean bl = false;
        for (WSStack<JaxWs> wSStack : list) {
            if (!"com.sun.xml.ws".equals(wSStack.getGroupId()) || !"webservices-rt".equals(wSStack.getArtifactId())) continue;
            object = wSStack.getScope();
            string = object == null ? "compile" : object;
            bl = true;
            break;
        }
        Object object2 = null;
        if (bl) {
            WSStack<JaxWs> wSStack;
            wSStack = new WSStackUtils(project).getWsStack(JaxWs.class);
            if (wSStack != null) {
                if (wSStack.isFeatureSupported((WSStack.Feature)JaxWs.Feature.WSIT)) {
                    if ("compile".equals(string)) {
                        object2 = "provided";
                    }
                } else if ("provided".equals(string)) {
                    object2 = "compile";
                }
            } else if ("compile".equals(string)) {
                object2 = "provided";
            }
            if (object2 != null) {
                object = object2;
                ModelOperation<POMModel> modelOperation = new ModelOperation<POMModel>((String)object){
                    final /* synthetic */ String val$targetScope;
                    {
                        this.val$targetScope = string;
                    }

                    public void performOperation(POMModel pOMModel) {
                        MavenModelUtils.updateLibraryScope(pOMModel, this.val$targetScope);
                    }
                };
                Utilities.performPOMModelOperations((FileObject)project.getProjectDirectory().getFileObject("pom.xml"), Collections.singletonList(modelOperation));
            }
        }
    }

    private static boolean hasResource(POMExtensibilityElement pOMExtensibilityElement, String string) {
        List list = pOMExtensibilityElement.getChildren(POMExtensibilityElement.class);
        for (POMExtensibilityElement pOMExtensibilityElement2 : list) {
            POMExtensibilityElement pOMExtensibilityElement3 = MavenModelUtils.findChild(pOMExtensibilityElement2.getExtensibilityElements(), "includes");
            if (pOMExtensibilityElement3 == null) continue;
            List list2 = pOMExtensibilityElement3.getChildren(POMExtensibilityElement.class);
            for (POMExtensibilityElement pOMExtensibilityElement4 : list2) {
                if (!string.equals(pOMExtensibilityElement4.getElementText())) continue;
                return true;
            }
        }
        return false;
    }

    public static String getUniqueId(org.netbeans.modules.maven.model.pom.Plugin plugin, String string) {
        String string2 = string;
        List list = plugin.getExecutions();
        if (list != null) {
            HashSet<String> hashSet = new HashSet<String>();
            for (org.netbeans.modules.maven.model.pom.PluginExecution pluginExecution : list) {
                String string3 = pluginExecution.getId();
                if (string3 == null) continue;
                if (string3.startsWith(WSIPMORT_GENERATE_PREFIX)) {
                    hashSet.add(string3.substring(WSIPMORT_GENERATE_PREFIX.length()));
                    continue;
                }
                hashSet.add(string3);
            }
            int n = 1;
            while (hashSet.contains(string2)) {
                string2 = string + "_" + String.valueOf(n++);
            }
        }
        return string2;
    }
}

