/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.navigation.switchfiles;

import java.awt.event.ActionEvent;
import java.io.File;
import java.util.Collection;
import javax.swing.text.JTextComponent;
import org.netbeans.api.editor.EditorRegistry;
import org.netbeans.editor.BaseAction;
import org.netbeans.editor.JumpList;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmInclude;
import org.netbeans.modules.cnd.api.model.xref.CsmIncludeHierarchyResolver;
import org.netbeans.modules.cnd.api.utils.IpeUtils;
import org.netbeans.modules.cnd.modelutil.CsmUtilities;
import org.netbeans.modules.cnd.utils.MIMEExtensions;
import org.netbeans.modules.cnd.utils.MIMENames;
import org.openide.awt.StatusDisplayer;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.windows.TopComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CppSwitchAction
extends BaseAction {
    private static final String actionName = "cpp-switch-header-source";
    private static final String ICON = "org/netbeans/modules/cnd/navigation/resources/header_source_icon.png";
    private static CppSwitchAction instance;

    public static synchronized CppSwitchAction getInstance() {
        if (instance == null) {
            instance = new CppSwitchAction();
        }
        return instance;
    }

    public CppSwitchAction() {
        super(actionName);
        this.putValue("noIconInMenu", Boolean.TRUE);
        this.putValue("IconResource", ICON);
        this.putValue("ShortDescription", this.getDefaultShortDescription());
    }

    public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
        Object object;
        Node[] nodeArray = TopComponent.getRegistry().getActivatedNodes();
        FileObject fileObject = CppSwitchAction.findToggleFile(nodeArray);
        boolean bl = false;
        if (fileObject != null) {
            CppSwitchAction.doToggle(fileObject);
            bl = true;
        } else {
            DataObject dataObject;
            object = CppSwitchAction.getTarget(nodeArray);
            if (object != null && (dataObject = CsmUtilities.getDataObject((CsmFile)object)) != null) {
                CppSwitchAction.doToggle(dataObject);
                bl = true;
            }
        }
        if (!bl) {
            switch (CppSwitchAction.getTargetNodeKind(TopComponent.getRegistry().getActivatedNodes())) {
                case HEADER: {
                    object = CppSwitchAction.getMessage("cpp-switch-source-not-found");
                    break;
                }
                case SOURCE: {
                    object = CppSwitchAction.getMessage("cpp-switch-header-not-found");
                    break;
                }
                default: {
                    object = CppSwitchAction.getMessage("cpp-switch-file-not-found");
                }
            }
            StatusDisplayer.getDefault().setStatusText((String)object);
        }
    }

    public String getPopupMenuText(JTextComponent jTextComponent) {
        String string = "goto-cpp-switch-file";
        switch (CppSwitchAction.getTargetNodeKind(TopComponent.getRegistry().getActivatedNodes())) {
            case HEADER: {
                string = "goto-cpp-header-file";
                break;
            }
            case SOURCE: {
                string = "goto-cpp-source-file";
            }
        }
        return CppSwitchAction.getMessage(string);
    }

    protected Object getDefaultShortDescription() {
        return CppSwitchAction.getMessage(actionName);
    }

    private static NodeKind getTargetNodeKind(Node[] nodeArray) {
        if (nodeArray != null && nodeArray.length == 1) {
            String string;
            DataObject dataObject = (DataObject)nodeArray[0].getLookup().lookup(DataObject.class);
            FileObject fileObject = dataObject == null ? null : dataObject.getPrimaryFile();
            String string2 = string = fileObject == null ? "" : fileObject.getMIMEType();
            if ("text/x-h".equals(string)) {
                return NodeKind.SOURCE;
            }
            if (MIMENames.isCppOrC((String)string)) {
                return NodeKind.HEADER;
            }
        }
        return NodeKind.UNKNOWN;
    }

    private static CsmFile getTarget(Node[] nodeArray) {
        CsmFile csmFile = CsmUtilities.getCsmFile((Node)nodeArray[0], (boolean)false);
        CsmFile csmFile2 = null;
        if (csmFile != null) {
            if (csmFile.isHeaderFile()) {
                csmFile2 = CppSwitchAction.findSource(csmFile);
            } else if (csmFile.isSourceFile()) {
                csmFile2 = CppSwitchAction.findHeader(csmFile);
            }
        }
        return csmFile2;
    }

    static CsmFile findHeader(CsmFile csmFile) {
        CsmInclude csmInclude2;
        String string = CppSwitchAction.getName(((Object)csmFile.getAbsolutePath()).toString());
        for (CsmInclude csmInclude2 : csmFile.getIncludes()) {
            if (csmInclude2.getIncludeFile() == null || !IpeUtils.areFilenamesEqual((String)string, (String)CppSwitchAction.getName(((Object)csmInclude2.getIncludeFile().getAbsolutePath()).toString()))) continue;
            return csmInclude2.getIncludeFile();
        }
        String string2 = CppSwitchAction.trimExtension(((Object)csmFile.getAbsolutePath()).toString());
        csmInclude2 = null;
        for (CsmFile csmFile2 : csmFile.getProject().getHeaderFiles()) {
            if (!IpeUtils.areFilenamesEqual((String)CppSwitchAction.getName(((Object)csmFile2.getAbsolutePath()).toString()), (String)string)) continue;
            if (IpeUtils.areFilenamesEqual((String)string2, (String)CppSwitchAction.trimExtension(((Object)csmFile2.getAbsolutePath()).toString()))) {
                return csmFile2;
            }
            if (csmInclude2 != null) continue;
            csmInclude2 = csmFile2;
        }
        return csmInclude2;
    }

    static CsmFile findSource(CsmFile csmFile) {
        String string = CppSwitchAction.getName(((Object)csmFile.getAbsolutePath()).toString());
        Collection collection = CsmIncludeHierarchyResolver.getDefault().getFiles(csmFile);
        for (CsmFile csmFile2 : collection) {
            if (!IpeUtils.areFilenamesEqual((String)CppSwitchAction.getName(((Object)csmFile2.getAbsolutePath()).toString()), (String)string)) continue;
            return csmFile2;
        }
        for (CsmFile csmFile2 : csmFile.getProject().getSourceFiles()) {
            if (!IpeUtils.areFilenamesEqual((String)CppSwitchAction.getName(((Object)csmFile2.getAbsolutePath()).toString()), (String)string)) continue;
            return csmFile2;
        }
        return null;
    }

    private static void doToggle(DataObject dataObject) {
        final OpenCookie openCookie = (OpenCookie)dataObject.getCookie(OpenCookie.class);
        if (openCookie != null) {
            JTextComponent jTextComponent = EditorRegistry.lastFocusedComponent();
            JumpList.checkAddEntry((JTextComponent)jTextComponent);
            RequestProcessor.getDefault().post(new Runnable(){

                public void run() {
                    openCookie.open();
                }
            }, 0, 10);
        }
    }

    private static void doToggle(FileObject fileObject) {
        assert (fileObject != null);
        try {
            DataObject dataObject = DataObject.find((FileObject)fileObject);
            if (dataObject != null) {
                CppSwitchAction.doToggle(dataObject);
            }
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            // empty catch block
        }
    }

    private static FileObject findToggleFile(Node[] nodeArray) {
        FileObject fileObject = null;
        DataObject dataObject = (DataObject)nodeArray[0].getLookup().lookup(DataObject.class);
        FileObject fileObject2 = dataObject.getPrimaryFile();
        if (fileObject2 != null) {
            String string = FileUtil.getMIMEType((FileObject)fileObject2, (String[])new String[]{"text/x-h", "text/x-c++", "text/x-c"});
            if (MIMENames.isCppOrC((String)string)) {
                fileObject = CppSwitchAction.findBrother(dataObject, MIMEExtensions.get((String)"text/x-h").getValues());
            } else if ("text/x-h".equals(string) && (fileObject = CppSwitchAction.findBrother(dataObject, MIMEExtensions.get((String)"text/x-c++").getValues())) == null) {
                fileObject = CppSwitchAction.findBrother(dataObject, MIMEExtensions.get((String)"text/x-c").getValues());
            }
        }
        return fileObject;
    }

    private static FileObject findBrother(DataObject dataObject, Collection<String> collection) {
        assert (dataObject != null);
        assert (dataObject.getPrimaryFile() != null);
        if (!collection.isEmpty()) {
            FileObject fileObject = dataObject.getPrimaryFile();
            FileObject[] fileObjectArray = fileObject.getParent().getChildren();
            for (String string : collection) {
                String string2 = fileObject.getName() + '.' + string;
                for (int i = 0; i < fileObjectArray.length; ++i) {
                    FileObject fileObject2 = fileObjectArray[i];
                    if (!IpeUtils.areFilenamesEqual((String)fileObject2.getNameExt(), (String)string2)) continue;
                    return fileObject2;
                }
            }
        }
        return null;
    }

    private static String getName(String string) {
        int n = string.lastIndexOf(File.separatorChar);
        String string2 = string.substring(n == -1 ? 0 : n + 1);
        int n2 = string2.lastIndexOf(46);
        return string2.substring(0, n2 == -1 ? string2.length() : n2);
    }

    private static String trimExtension(String string) {
        int n = string.lastIndexOf(46);
        return n == -1 ? string : string.substring(0, n);
    }

    private static String getMessage(String string) {
        return NbBundle.getMessage(CppSwitchAction.class, (String)string);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum NodeKind {
        HEADER,
        SOURCE,
        UNKNOWN;

    }
}

