/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.ui.history;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.subversion.RepositoryFile;
import org.netbeans.modules.subversion.client.SvnClientExceptionHandler;
import org.netbeans.modules.subversion.ui.browser.Browser;
import org.netbeans.modules.subversion.ui.history.SearchExecutor;
import org.netbeans.modules.subversion.util.SvnUtils;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;

class SearchCriteriaPanel
extends JPanel {
    private final File[] roots;
    private final SVNUrl url;
    private JTextField tfCommitMessage;
    private JTextField tfUsername;
    final JTextField tfFrom = new JTextField();
    final JTextField tfTo = new JTextField();

    public SearchCriteriaPanel(File[] fileArray) {
        this.roots = fileArray;
        this.url = null;
        this.initComponents();
    }

    public SearchCriteriaPanel(SVNUrl sVNUrl) {
        this.url = sVNUrl;
        this.roots = null;
        this.initComponents();
    }

    public SVNRevision getFrom() {
        String string = this.tfFrom.getText().trim();
        if (string.length() == 0) {
            return new SVNRevision.Number(1L);
        }
        return this.toRevision(string);
    }

    public SVNRevision getTo() {
        String string = this.tfTo.getText().trim();
        if (string.length() == 0) {
            return SVNRevision.HEAD;
        }
        return this.toRevision(string);
    }

    private Date parseDate(String string) {
        if (string == null) {
            return null;
        }
        for (int i = 0; i < SearchExecutor.dateFormats.length; ++i) {
            DateFormat dateFormat = SearchExecutor.dateFormats[i];
            try {
                return dateFormat.parse(string);
            }
            catch (ParseException parseException) {
                continue;
            }
        }
        return null;
    }

    private SVNRevision toRevision(String string) {
        Date date = this.parseDate(string);
        if (date != null) {
            return new SVNRevision.DateSpec(date);
        }
        if ("BASE".equals(string)) {
            return SVNRevision.BASE;
        }
        if ("HEAD".equals(string)) {
            return SVNRevision.HEAD;
        }
        try {
            return new SVNRevision.Number(Long.parseLong(string));
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    public String getCommitMessage() {
        String string = this.tfCommitMessage.getText().trim();
        return string.length() > 0 ? string : null;
    }

    public String getUsername() {
        String string = this.tfUsername.getText().trim();
        return string.length() > 0 ? string : null;
    }

    public void setFrom(String string) {
        if (string == null) {
            string = "";
        }
        this.tfFrom.setText(string);
    }

    public void setTo(String string) {
        if (string == null) {
            string = "";
        }
        this.tfTo.setText(string);
    }

    public void setCommitMessage(String string) {
        if (string == null) {
            string = "";
        }
        this.tfCommitMessage.setText(string);
    }

    public void setUsername(String string) {
        if (string == null) {
            string = "";
        }
        this.tfUsername.setText(string);
    }

    public void addNotify() {
        super.addNotify();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                SearchCriteriaPanel.this.tfCommitMessage.requestFocusInWindow();
            }
        });
    }

    private void initComponents() {
        JLabel jLabel = new JLabel();
        this.tfCommitMessage = new JTextField();
        JLabel jLabel2 = new JLabel();
        this.tfUsername = new JTextField();
        JLabel jLabel3 = new JLabel();
        JLabel jLabel4 = new JLabel();
        JLabel jLabel5 = new JLabel();
        JLabel jLabel6 = new JLabel();
        JButton jButton = new JButton();
        JButton jButton2 = new JButton();
        jLabel.setLabelFor(this.tfCommitMessage);
        jLabel2.setLabelFor(this.tfUsername);
        jLabel3.setLabelFor(this.tfFrom);
        jLabel4.setLabelFor(this.tfTo);
        this.tfCommitMessage.setColumns(20);
        this.tfUsername.setColumns(20);
        this.tfFrom.setColumns(20);
        this.tfTo.setColumns(20);
        ResourceBundle resourceBundle = ResourceBundle.getBundle("org/netbeans/modules/subversion/ui/history/Bundle");
        Mnemonics.setLocalizedText((JLabel)jLabel, (String)resourceBundle.getString("CTL_UseCommitMessage"));
        jLabel.setToolTipText(resourceBundle.getString("TT_CommitMessage"));
        Mnemonics.setLocalizedText((JLabel)jLabel2, (String)resourceBundle.getString("CTL_UseUsername"));
        jLabel2.setToolTipText(resourceBundle.getString("TT_Username"));
        Mnemonics.setLocalizedText((JLabel)jLabel3, (String)resourceBundle.getString("CTL_UseFrom"));
        jLabel3.setToolTipText(resourceBundle.getString("TT_From"));
        Mnemonics.setLocalizedText((JLabel)jLabel4, (String)resourceBundle.getString("CTL_UseTo"));
        jLabel4.setToolTipText(resourceBundle.getString("TT_To"));
        Mnemonics.setLocalizedText((JLabel)jLabel5, (String)resourceBundle.getString("CTL_FromToHint"));
        Mnemonics.setLocalizedText((JLabel)jLabel6, (String)resourceBundle.getString("CTL_FromToHint"));
        Mnemonics.setLocalizedText((AbstractButton)jButton, (String)resourceBundle.getString("CTL_BrowseFrom"));
        jButton.setToolTipText(resourceBundle.getString("TT_BrowseFrom"));
        Mnemonics.setLocalizedText((AbstractButton)jButton2, (String)resourceBundle.getString("CTL_BrowseTo"));
        jButton2.setToolTipText(resourceBundle.getString("TT_BrowseTo"));
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createSequentialGroup().add(12).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)jLabel).add((Component)jLabel2).add((Component)jLabel3).add((Component)jLabel4)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.tfCommitMessage).add((Component)this.tfUsername).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.tfFrom).addPreferredGap(0).add((Component)jLabel5)).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.tfTo).addPreferredGap(0).add((Component)jLabel6))).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)jButton).add((Component)jButton2)).add(11));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createSequentialGroup().add(8).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)jLabel).add((Component)this.tfCommitMessage)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)jLabel2).add((Component)this.tfUsername)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)jLabel3).add((Component)this.tfFrom).add((Component)jLabel5).add((Component)jButton)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)jLabel4).add((Component)this.tfTo).add((Component)jLabel6).add((Component)jButton2)));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SearchCriteriaPanel.this.onFromBrowse(actionEvent);
            }
        });
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SearchCriteriaPanel.this.onToBrowse(actionEvent);
            }
        });
    }

    private void onToBrowse(ActionEvent actionEvent) {
        this.onBrowse(this.tfTo);
    }

    private void onFromBrowse(ActionEvent actionEvent) {
        this.onBrowse(this.tfFrom);
    }

    private void onBrowse(final JTextField jTextField) {
        SVNUrl sVNUrl;
        try {
            sVNUrl = this.url != null ? this.url : SvnUtils.getRepositoryRootUrl(this.roots[0]);
        }
        catch (SVNClientException sVNClientException) {
            SvnClientExceptionHandler.notifyException((Exception)((Object)sVNClientException), true, true);
            return;
        }
        String string = jTextField == this.tfFrom ? NbBundle.getMessage(SearchCriteriaPanel.class, (String)"CTL_BrowseTag_StartTag") : NbBundle.getMessage(SearchCriteriaPanel.class, (String)"CTL_BrowseTag_EndTag");
        RepositoryFile repositoryFile = new RepositoryFile(sVNUrl, SVNRevision.HEAD);
        int n = this.roots[0].isFile() ? 11 : 1;
        Browser browser = new Browser(string, n, repositoryFile, null, null, "org.netbeans.modules.subversion.ui.browser.searchhistory");
        final RepositoryFile[] repositoryFileArray = browser.getRepositoryFiles();
        if (repositoryFileArray == null || repositoryFileArray.length == 0) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                jTextField.setText(repositoryFileArray[0].getRevision().toString());
            }
        });
    }
}

