/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.ui.browser;

import java.awt.event.ActionEvent;
import java.beans.PropertyVetoException;
import java.util.logging.Level;
import javax.swing.AbstractAction;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.ui.browser.Browser;
import org.netbeans.modules.subversion.ui.browser.RepositoryPathNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class SelectPathAction
extends AbstractAction {
    private final SVNUrl selectionUrl;
    private Node[] selectionNodes;
    private final Browser browser;
    private static final Node[] EMPTY_NODES = new Node[0];

    public SelectPathAction(Browser browser, SVNUrl sVNUrl) {
        this.browser = browser;
        this.selectionUrl = sVNUrl;
        this.putValue("Name", NbBundle.getMessage(RepositoryPathNode.class, (String)"CTL_Action_SelectPath"));
        this.setEnabled(true);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Node[] nodeArray = this.getSelectionNodes();
        if (nodeArray == null || nodeArray == EMPTY_NODES) {
            return;
        }
        try {
            this.browser.getExplorerManager().setSelectedNodes(nodeArray);
        }
        catch (PropertyVetoException propertyVetoException) {
            Subversion.LOG.log(Level.INFO, null, propertyVetoException);
        }
    }

    private Node[] getSelectionNodes() {
        if (this.selectionNodes == null) {
            Children children;
            String[] stringArray = this.selectionUrl.getPathSegments();
            RepositoryPathNode repositoryPathNode = (RepositoryPathNode)this.browser.getExplorerManager().getRootContext();
            for (int i = 0; i < stringArray.length && (repositoryPathNode = (children = repositoryPathNode.getChildren()).findChild(stringArray[i])) != null; ++i) {
            }
            this.selectionNodes = repositoryPathNode == null ? EMPTY_NODES : new Node[]{repositoryPathNode};
        }
        return this.selectionNodes;
    }
}

