/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.mysql.impl;

import java.util.ArrayList;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.db.explorer.ConnectionListener;
import org.netbeans.api.db.explorer.ConnectionManager;
import org.netbeans.api.db.explorer.DatabaseException;
import org.netbeans.api.db.explorer.node.NodeProvider;
import org.netbeans.api.db.explorer.node.NodeProviderFactory;
import org.netbeans.modules.db.mysql.DatabaseServer;
import org.netbeans.modules.db.mysql.DatabaseServerManager;
import org.netbeans.modules.db.mysql.impl.DbExplorerConnectionListener;
import org.netbeans.modules.db.mysql.impl.Installation;
import org.netbeans.modules.db.mysql.impl.InstallationManager;
import org.netbeans.modules.db.mysql.impl.MySQLOptions;
import org.netbeans.modules.db.mysql.nodes.ServerNode;
import org.netbeans.modules.db.mysql.util.DatabaseUtils;
import org.netbeans.modules.db.mysql.util.Utils;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;

public final class ServerNodeProvider
extends NodeProvider {
    private static final Logger LOGGER = Logger.getLogger(ServerNodeProvider.class.getName());
    private static ServerNodeProvider DEFAULT = null;
    private static final MySQLOptions options = MySQLOptions.getDefault();
    private final CopyOnWriteArrayList<ChangeListener> listeners = new CopyOnWriteArrayList();

    public static NodeProviderFactory getFactory() {
        return FactoryHolder.FACTORY;
    }

    public static ServerNodeProvider getDefault() {
        return DEFAULT;
    }

    private ServerNodeProvider(Lookup lookup) {
        super(lookup);
    }

    protected void initialize() {
        if (!options.isProviderRegistered() && !options.isProviderRemoved()) {
            this.findAndRegisterMySQL();
        }
        if (!options.isProviderRegistered()) {
            DatabaseServerManager.getDatabaseServer().disconnect();
        }
        this.update();
    }

    private void update() {
        ArrayList<ServerNode> arrayList = new ArrayList<ServerNode>();
        if (this.isRegistered()) {
            ServerNode serverNode = ServerNode.create(DatabaseServerManager.getDatabaseServer());
            arrayList.add(serverNode);
        }
        this.setNodes(arrayList);
    }

    private void findAndRegisterMySQL() {
        if (DatabaseUtils.getJDBCDriver() == null) {
            return;
        }
        if (options.isProviderRegistered() || options.isProviderRemoved()) {
            return;
        }
        this.registerConnectionListener();
        this.findAndRegisterInstallation();
    }

    private void registerConnectionListener() {
        ConnectionManager.getDefault().addConnectionListener((ConnectionListener)new DbExplorerConnectionListener());
    }

    private void findAndRegisterInstallation() {
        Installation installation = InstallationManager.detectInstallation();
        if (installation == null) {
            return;
        }
        String[] stringArray = installation.getAdminCommand();
        if (Utils.isValidExecutable(stringArray[0], true) || Utils.isValidURL(stringArray[0], true)) {
            options.setAdminPath(stringArray[0]);
            options.setAdminArgs(stringArray[1]);
        }
        if (Utils.isValidExecutable((stringArray = installation.getStartCommand())[0], true)) {
            options.setStartPath(stringArray[0]);
            options.setStartArgs(stringArray[1]);
        }
        if (Utils.isValidExecutable((stringArray = installation.getStopCommand())[0], true)) {
            options.setStopPath(stringArray[0]);
            options.setStopArgs(stringArray[1]);
        }
        options.setPort(installation.getDefaultPort());
        this.setRegistered(true);
    }

    public void setRegistered(boolean bl) {
        boolean bl2 = this.isRegistered();
        if (bl != bl2) {
            final DatabaseServer databaseServer = DatabaseServerManager.getDatabaseServer();
            options.setProviderRegistered(bl);
            if (!bl) {
                databaseServer.disconnect();
            } else {
                RequestProcessor.getDefault().post(new Runnable(){

                    public void run() {
                        try {
                            databaseServer.checkConfiguration();
                        }
                        catch (DatabaseException databaseException) {
                            LOGGER.log(Level.INFO, null, databaseException);
                        }
                    }
                });
            }
            this.update();
            this.notifyChange();
        }
    }

    public synchronized boolean isRegistered() {
        return options.isProviderRegistered();
    }

    void notifyChange() {
        ChangeEvent changeEvent = new ChangeEvent((Object)this);
        for (ChangeListener changeListener : this.listeners) {
            changeListener.stateChanged(changeEvent);
        }
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.listeners.add(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.listeners.remove(changeListener);
    }

    private static class FactoryHolder {
        static final NodeProviderFactory FACTORY = new NodeProviderFactory(){

            public ServerNodeProvider createInstance(Lookup lookup) {
                DEFAULT = new ServerNodeProvider(lookup);
                return DEFAULT;
            }
        };

        private FactoryHolder() {
        }
    }
}

