/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.management.api.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.netbeans.modules.dlight.api.storage.DataTableMetadata;
import org.netbeans.modules.dlight.management.api.DLightSession;
import org.netbeans.modules.dlight.spi.collector.DataCollector;
import org.netbeans.modules.dlight.spi.storage.DataStorage;
import org.netbeans.modules.dlight.spi.storage.DataStorageFactory;
import org.netbeans.modules.dlight.spi.storage.DataStorageType;
import org.netbeans.modules.dlight.spi.storage.ProxyDataStorage;
import org.netbeans.modules.dlight.util.DLightLogger;
import org.openide.util.Lookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DataStorageManager {
    private Collection<? extends DataStorageFactory> dataStorageFactories;
    private Map<DLightSession, List<DataStorage>> activeDataStorages = new HashMap<DLightSession, List<DataStorage>>();
    private static final Logger log = DLightLogger.getLogger(DataStorageManager.class);
    private static final DataStorageManager instance = new DataStorageManager();
    private DLightSession lastSession;

    private DataStorageManager() {
        this.dataStorageFactories = Lookup.getDefault().lookupAll(DataStorageFactory.class);
        log.fine(this.dataStorageFactories.size() + " data storage(s) found!");
    }

    public static DataStorageManager getInstance() {
        return instance;
    }

    public List<DataStorage> closeSession(DLightSession dLightSession) {
        if (dLightSession == null) {
            return null;
        }
        List<DataStorage> list = this.activeDataStorages.get(dLightSession);
        if (list != null) {
            for (DataStorage dataStorage : list) {
                if (!dataStorage.shutdown()) {
                    log.finest("DataStorage " + dataStorage + " is not closed");
                    continue;
                }
                log.finest("DataStorage " + dataStorage + " successfully closed");
            }
        }
        return this.activeDataStorages.remove(dLightSession);
    }

    public void clearActiveStorages(DLightSession dLightSession) {
        List<DataStorage> list = this.activeDataStorages.get(dLightSession);
        if (list != null) {
            list.clear();
        }
        this.lastSession = dLightSession;
    }

    public Map<DataStorageType, DataStorage> getDataStoragesFor(DLightSession dLightSession, DataCollector<?> dataCollector) {
        HashMap<DataStorageType, DataStorage> hashMap = new HashMap<DataStorageType, DataStorage>();
        for (DataStorageType dataStorageType : dataCollector.getRequiredDataStorageTypes()) {
            hashMap.put(dataStorageType, this.getDataStorageFor(dLightSession, dataStorageType, dataCollector.getDataTablesMetadata()));
        }
        return hashMap;
    }

    private DataStorage getDataStorageFor(DLightSession dLightSession, DataStorageType dataStorageType, List<DataTableMetadata> list) {
        if (dLightSession == null) {
            return null;
        }
        List<DataStorage> list2 = this.activeDataStorages.get(dLightSession);
        if (list2 != null) {
            for (DataStorage dataStorage : list2) {
                if (!dataStorage.supportsType(dataStorageType)) continue;
                dataStorage.createTables(list);
                return dataStorage;
            }
        }
        for (DataStorageFactory dataStorageFactory : this.dataStorageFactories) {
            if (!dataStorageFactory.getStorageTypes().contains(dataStorageType)) continue;
            DataStorage dataStorage = dataStorageFactory.createStorage();
            if (dataStorage instanceof ProxyDataStorage) {
                ProxyDataStorage proxyDataStorage = (ProxyDataStorage)dataStorage;
                DataStorage dataStorage2 = this.getDataStorageFor(dLightSession, proxyDataStorage.getBackendDataStorageType(), proxyDataStorage.getBackendTablesMetadata());
                proxyDataStorage.attachTo(dataStorage2);
            }
            if (dataStorage == null) continue;
            dataStorage.createTables(list);
            if (list2 == null) {
                list2 = new ArrayList<DataStorage>();
            }
            list2.add(dataStorage);
            this.activeDataStorages.put(dLightSession, list2);
            return dataStorage;
        }
        return null;
    }
}

