/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.refactoring;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.text.BadLocationException;
import org.netbeans.api.queries.FileEncodingQuery;
import org.netbeans.editor.BaseDocument;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.text.PositionRef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Modifications {
    Map<FileObject, List<Difference>> diffs = new HashMap<FileObject, List<Difference>>();

    public void addDifference(FileObject fileObject, Difference difference) {
        List<Difference> list = this.diffs.get(fileObject);
        if (list == null) {
            list = new ArrayList<Difference>();
            list.add(difference);
            this.diffs.put(fileObject, list);
        } else {
            list.add(difference);
        }
    }

    public void commit() throws IOException {
        for (Map.Entry<FileObject, List<Difference>> entry : this.diffs.entrySet()) {
            this.commit(entry.getKey(), entry.getValue(), null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void commit(FileObject fileObject, List<Difference> list, Writer writer) throws IOException {
        Object object;
        EditorCookie editorCookie;
        DataObject dataObject = DataObject.find((FileObject)fileObject);
        EditorCookie editorCookie2 = editorCookie = dataObject != null ? (EditorCookie)dataObject.getCookie(EditorCookie.class) : null;
        if (editorCookie != null && writer == null && (object = editorCookie.getDocument()) != null) {
            if (object instanceof BaseDocument) {
                ((BaseDocument)object).atomicLock();
            }
            try {
                for (Difference difference : list) {
                    if (difference.isExcluded()) continue;
                    try {
                        switch (difference.getKind()) {
                            case INSERT: {
                                object.insertString(difference.getStartPosition().getOffset(), difference.getNewText(), null);
                                break;
                            }
                            case REMOVE: {
                                object.remove(difference.getStartPosition().getOffset(), difference.getEndPosition().getOffset() - difference.getStartPosition().getOffset());
                                break;
                            }
                            case CHANGE: {
                                object.remove(difference.getStartPosition().getOffset(), difference.getEndPosition().getOffset() - difference.getStartPosition().getOffset());
                                object.insertString(difference.getStartPosition().getOffset(), difference.getNewText(), null);
                            }
                        }
                    }
                    catch (BadLocationException badLocationException) {
                        IOException iOException = new IOException();
                        iOException.initCause(badLocationException);
                        throw iOException;
                        return;
                    }
                }
            }
            finally {
                if (object instanceof BaseDocument) {
                    ((BaseDocument)object).atomicUnlock();
                }
            }
        }
        object = null;
        ByteArrayOutputStream byteArrayOutputStream = null;
        Reader reader = null;
        try {
            Charset charset = FileEncodingQuery.getEncoding((FileObject)fileObject);
            object = fileObject.getInputStream();
            byteArrayOutputStream = new ByteArrayOutputStream();
            FileUtil.copy((InputStream)object, (OutputStream)byteArrayOutputStream);
            ((InputStream)object).close();
            object = null;
            byte[] byArray = byteArrayOutputStream.toByteArray();
            int n = this.convertToLF(byArray);
            byteArrayOutputStream.close();
            byteArrayOutputStream = null;
            reader = new InputStreamReader((InputStream)new ByteArrayInputStream(byArray, 0, n), charset);
            if (writer == null) {
                writer = new OutputStreamWriter(fileObject.getOutputStream(), charset);
            }
            int n2 = 0;
            Difference[] differenceArray = list.toArray(new Difference[list.size()]);
            Arrays.sort(differenceArray, new Comparator<Difference>(){

                @Override
                public int compare(Difference difference, Difference difference2) {
                    int n = 0;
                    if (difference.getStartPosition().getOffset() < difference2.getStartPosition().getOffset()) {
                        n = -1;
                    } else if (difference.getStartPosition().getOffset() > difference2.getStartPosition().getOffset()) {
                        n = 1;
                    }
                    return n;
                }
            });
            Difference[] differenceArray2 = differenceArray;
            int n3 = differenceArray2.length;
            block19: for (int i = 0; i < n3; ++i) {
                int n4;
                int n5;
                Difference difference = differenceArray2[i];
                if (difference.isExcluded() || (n5 = difference.getStartPosition().getOffset()) < n2) continue;
                int n6 = n5 - n2;
                char[] cArray = new char[n6];
                int n7 = 0;
                while ((n4 = reader.read(cArray, 0, n6 - n7)) > 0 && n7 < n6) {
                    writer.write(cArray, 0, n4);
                    n7 += n4;
                    n2 += n4;
                }
                switch (difference.getKind()) {
                    case INSERT: {
                        writer.write(difference.getNewText());
                        continue block19;
                    }
                    case REMOVE: {
                        int n8 = difference.getEndPosition().getOffset() - difference.getStartPosition().getOffset();
                        reader.skip(n8);
                        n2 += n8;
                        continue block19;
                    }
                    case CHANGE: {
                        int n8 = difference.getEndPosition().getOffset() - difference.getStartPosition().getOffset();
                        reader.skip(n8);
                        n2 += n8;
                        writer.write(difference.getNewText());
                    }
                }
            }
            char[] cArray = new char[1024];
            while ((n3 = reader.read(cArray)) > 0) {
                writer.write(cArray, 0, n3);
            }
            return;
        }
        finally {
            if (object != null) {
                ((InputStream)object).close();
            }
            if (byteArrayOutputStream != null) {
                byteArrayOutputStream.close();
            }
            if (reader != null) {
                reader.close();
            }
            if (writer != null) {
                writer.close();
            }
        }
    }

    private int convertToLF(byte[] byArray) {
        int n = 0;
        for (int i = 0; i < byArray.length; ++i) {
            if (byArray[i] == 13) continue;
            byArray[n++] = byArray[i];
        }
        return n;
    }

    public String getResultingSource(FileObject fileObject) throws IOException {
        assert (fileObject != null) : "Provided fileObject is null";
        StringWriter stringWriter = new StringWriter();
        this.commit(fileObject, this.diffs.get(fileObject), stringWriter);
        return stringWriter.toString();
    }

    public static final class Difference {
        Kind kind;
        PositionRef startPos;
        PositionRef endPos;
        String oldText;
        String newText;
        String description;
        private boolean excluded;

        Difference(Kind kind, PositionRef positionRef, PositionRef positionRef2, String string, String string2, String string3) {
            this.kind = kind;
            this.startPos = positionRef;
            this.endPos = positionRef2;
            this.oldText = string;
            this.newText = string2;
            this.excluded = false;
            this.description = string3;
        }

        public Kind getKind() {
            return this.kind;
        }

        public String getDesription() {
            return this.description;
        }

        public PositionRef getStartPosition() {
            return this.startPos;
        }

        public PositionRef getEndPosition() {
            return this.endPos;
        }

        public String getOldText() {
            return this.oldText;
        }

        public String getNewText() {
            return this.newText;
        }

        public boolean isExcluded() {
            return this.excluded;
        }

        public void setExclude(boolean bl) {
            this.excluded = bl;
        }

        public String toString() {
            return (Object)((Object)this.kind) + "<" + this.startPos.getOffset() + ", " + this.endPos.getOffset() + ">: " + this.oldText + " -> " + this.newText;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum Kind {
            INSERT,
            REMOVE,
            CHANGE;

        }
    }
}

