/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.updateprovider;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.util.Cancellable;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class NetworkAccess {
    private static final Logger err = Logger.getLogger(NetworkAccess.class.getName());

    private NetworkAccess() {
    }

    public static Task createNetworkAcessTask(URL uRL, int n, NetworkListener networkListener) {
        return new Task(uRL, n, networkListener);
    }

    public static interface NetworkListener {
        public void streamOpened(InputStream var1, int var2);

        public void accessCanceled();

        public void accessTimeOut();

        public void notifyException(Exception var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface SizedConnection
    extends Callable<InputStream> {
        public int getContentLength();
    }

    public static class Task
    implements Cancellable {
        private URL url;
        private int timeout;
        private NetworkListener listener;
        private ExecutorService es = Executors.newSingleThreadExecutor();
        private Future<InputStream> connect = null;
        private RequestProcessor.Task rpTask = null;

        private Task(URL uRL, int n, NetworkListener networkListener) {
            if (uRL == null) {
                throw new IllegalArgumentException("URL cannot be null.");
            }
            if (networkListener == null) {
                throw new IllegalArgumentException("NetworkListener cannot be null.");
            }
            this.url = uRL;
            this.timeout = n;
            this.listener = networkListener;
            this.postTask();
        }

        private void postTask() {
            final SizedConnection sizedConnection = this.createCallableNetwork(this.url, this.timeout);
            this.rpTask = RequestProcessor.getDefault().post(new Runnable(){

                public void run() {
                    Task.this.connect = Task.this.es.submit(sizedConnection);
                    InputStream inputStream = null;
                    try {
                        inputStream = (InputStream)Task.this.connect.get(Task.this.timeout, TimeUnit.MILLISECONDS);
                        if (Task.this.connect.isDone()) {
                            Task.this.listener.streamOpened(inputStream, sizedConnection.getContentLength());
                        } else if (Task.this.connect.isCancelled()) {
                            Task.this.listener.accessCanceled();
                        } else {
                            Task.this.listener.accessTimeOut();
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        Task.this.listener.notifyException(interruptedException);
                    }
                    catch (ExecutionException executionException) {
                        Throwable throwable = executionException.getCause();
                        if (throwable != null && throwable instanceof Exception) {
                            Task.this.listener.notifyException((Exception)throwable);
                        } else {
                            Task.this.listener.notifyException(executionException);
                        }
                    }
                    catch (CancellationException cancellationException) {
                        Task.this.listener.accessCanceled();
                    }
                    catch (TimeoutException timeoutException) {
                        IOException iOException = new IOException(NbBundle.getMessage(NetworkAccess.class, (String)"NetworkAccess_Timeout", (Object)Task.this.url));
                        iOException.initCause(timeoutException);
                        Task.this.listener.notifyException(iOException);
                    }
                }
            });
        }

        public void waitFinished() {
            assert (this.rpTask != null) : "RequestProcessor.Task must be initialized.";
            this.rpTask.waitFinished();
        }

        public boolean isFinished() {
            assert (this.rpTask != null) : "RequestProcessor.Task must be initialized.";
            return this.rpTask.isFinished();
        }

        private SizedConnection createCallableNetwork(final URL uRL, final int n) {
            return new SizedConnection(){
                private int contentLength = -1;

                public int getContentLength() {
                    return this.contentLength;
                }

                public InputStream call() throws Exception {
                    URLConnection uRLConnection = uRL.openConnection();
                    uRLConnection.setConnectTimeout(n);
                    InputStream inputStream = uRLConnection.getInputStream();
                    this.contentLength = uRLConnection.getContentLength();
                    Map<String, List<String>> map = uRLConnection.getHeaderFields();
                    StringBuilder stringBuilder = new StringBuilder("Connection opened for:\n");
                    stringBuilder.append("    Url: " + uRLConnection.getURL() + "\n");
                    for (String string : map.keySet()) {
                        stringBuilder.append("    " + (string == null ? "Status" : string) + ": " + map.get(string) + "\n");
                    }
                    stringBuilder.append("\n");
                    err.log(Level.FINE, stringBuilder.toString());
                    return new BufferedInputStream(inputStream);
                }
            };
        }

        public boolean cancel() {
            return this.connect.cancel(true);
        }
    }
}

