/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.inspector;

import org.netbeans.modules.vmd.api.inspector.InspectorFolderPath;
import org.netbeans.modules.vmd.inspector.InspectorFolderWrapper;
import org.openide.nodes.Node;

final class DebugInspector {
    private static String tabs = "";
    private static final String space = "     ";
    private static Node childTest;

    DebugInspector() {
    }

    static void printPath(InspectorFolderPath inspectorFolderPath) {
        System.out.println("InspectorPath" + inspectorFolderPath.toString());
    }

    static void printFoldersTree(InspectorFolderWrapper inspectorFolderWrapper) {
        tabs = "";
        System.out.println((Object)inspectorFolderWrapper.getNode());
        System.out.println(tabs + "  -Node children =:" + inspectorFolderWrapper.getNode().getChildren().getNodesCount());
        DebugInspector.deepDive(inspectorFolderWrapper);
    }

    private static void deepDive(InspectorFolderWrapper inspectorFolderWrapper) {
        if (inspectorFolderWrapper.getChildren() == null) {
            return;
        }
        tabs = tabs + space;
        for (InspectorFolderWrapper inspectorFolderWrapper2 : inspectorFolderWrapper.getChildren()) {
            System.out.println(tabs + "|-" + inspectorFolderWrapper2);
            System.out.println(tabs + "  -Node children =:" + inspectorFolderWrapper2.getNode().getChildren().getNodesCount());
            if (inspectorFolderWrapper2.getChildren() == null) continue;
            DebugInspector.deepDive(inspectorFolderWrapper2);
        }
        tabs = tabs.replaceFirst(space, "");
    }

    static void printNodesTree(Node node) {
        tabs = "";
        System.out.println(node);
        System.out.println(tabs + "  -Node children =:" + node.getChildren().getNodesCount());
        DebugInspector.deepDive(node);
    }

    private static void deepDive(Node node) {
        tabs = tabs + space;
        for (Node node2 : node.getChildren().getNodes()) {
            System.out.println(tabs + "|-" + node2.getDisplayName() + " " + node2);
            System.out.println(tabs + "  -Node children =:" + node2.getChildren().getNodesCount());
            if (node2.getChildren().getNodes().length <= 0) continue;
            DebugInspector.deepDive(node2);
        }
        tabs = tabs.replaceFirst(space, "");
    }

    static void checkRootNode(Node node, Node node2) {
        childTest = node2;
        System.out.println("Test start: root node: " + node + " child: " + node2);
        DebugInspector.checkParent(node, node2);
    }

    private static void checkParent(Node node, Node node2) {
        if (node2.getParentNode() != null) {
            DebugInspector.checkParent(node, node2.getParentNode());
        } else if (node2 == node) {
            System.out.println("Node: " + node + " is root node of node : " + childTest);
        } else {
            System.out.println("Node: " + node + " is NOT root node of node : " + childTest + " real root node: " + node2);
        }
    }
}

