/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.api.inspector;

import java.beans.PropertyVetoException;
import org.netbeans.modules.vmd.api.io.DataObjectContext;
import org.netbeans.modules.vmd.api.io.ProjectUtils;
import org.netbeans.modules.vmd.api.model.DesignDocument;
import org.netbeans.modules.vmd.inspector.InspectorManagerView;
import org.openide.explorer.ExplorerManager;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;

public final class InspectorUIManagerSupport {
    public static void selectNodesInInspector(DesignDocument designDocument, String string) {
        DataObjectContext dataObjectContext = ProjectUtils.getDataObjectContextForDocument((DesignDocument)designDocument);
        ExplorerManager explorerManager = InspectorManagerView.getExplorerManager(dataObjectContext);
        if (explorerManager == null) {
            return;
        }
        Node node = explorerManager.getRootContext();
        Node node2 = InspectorUIManagerSupport.dive(node, string);
        if (node2 != null) {
            try {
                explorerManager.setSelectedNodes(new Node[]{node2});
            }
            catch (PropertyVetoException propertyVetoException) {
                Exceptions.printStackTrace((Throwable)propertyVetoException);
            }
        }
    }

    private static Node dive(Node node, String string) {
        Children children = node.getChildren();
        for (Node node2 : children.getNodes()) {
            Node node3;
            if (node2.getHtmlDisplayName().equals(string) || node2.getDisplayName().equals(string)) {
                return node2;
            }
            if (node2.getChildren() == null || (node3 = InspectorUIManagerSupport.dive(node2, string)) == null) continue;
            return node3;
        }
        return null;
    }
}

