/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.api.phpmodule;

import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.php.api.phpmodule.PhpModuleProperties;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;
import org.openide.util.Utilities;
import org.openide.windows.WindowManager;

public abstract class PhpModule {
    public abstract String getName();

    public abstract String getDisplayName();

    public abstract FileObject getSourceDirectory();

    public abstract FileObject getTestDirectory();

    public abstract PhpModuleProperties getProperties();

    public static PhpModule forFileObject(FileObject fileObject) {
        return PhpModule.lookupPhpModule(FileOwnerQuery.getOwner((FileObject)fileObject));
    }

    public static PhpModule inferPhpModule() {
        PhpModule phpModule;
        Lookup lookup;
        Lookup lookup2;
        Lookup lookup3 = WindowManager.getDefault().getRegistry().getActivatedNodes();
        if (lookup3 != null) {
            lookup2 = lookup3;
            int n = ((Lookup)lookup2).length;
            for (int i = 0; i < n; ++i) {
                lookup = lookup2[i];
                Project[] projectArray = PhpModule.lookupPhpModule(lookup.getLookup());
                if (projectArray == null) continue;
                return projectArray;
            }
        }
        if ((phpModule = PhpModule.lookupPhpModule(lookup2 = Utilities.actionsGlobalContext())) != null) {
            return phpModule;
        }
        FileObject fileObject = (FileObject)lookup2.lookup(FileObject.class);
        if (fileObject != null && (phpModule = PhpModule.forFileObject(fileObject)) != null) {
            return phpModule;
        }
        lookup = OpenProjects.getDefault();
        phpModule = PhpModule.lookupPhpModule(lookup.getMainProject());
        if (phpModule != null) {
            return phpModule;
        }
        for (Project project : lookup.getOpenProjects()) {
            phpModule = PhpModule.lookupPhpModule(project);
            if (phpModule == null) continue;
            return phpModule;
        }
        return null;
    }

    private static PhpModule lookupPhpModule(Project project) {
        if (project != null) {
            return PhpModule.lookupPhpModule(project.getLookup());
        }
        return null;
    }

    private static PhpModule lookupPhpModule(Lookup lookup) {
        PhpModule phpModule = (PhpModule)lookup.lookup(PhpModule.class);
        if (phpModule != null) {
            return phpModule;
        }
        Project project = (Project)lookup.lookup(Project.class);
        if (project != null && (phpModule = (PhpModule)project.getLookup().lookup(PhpModule.class)) != null) {
            return phpModule;
        }
        return null;
    }
}

