/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.threads;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import org.netbeans.lib.profiler.results.DataManagerListener;
import org.netbeans.lib.profiler.results.threads.ThreadData;
import org.netbeans.lib.profiler.results.threads.ThreadsDataManager;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.lib.profiler.ui.threads.ThreadDetailsComponent;

public class ThreadsDetailsPanel
extends JPanel
implements ActionListener,
DataManagerListener {
    private static final ResourceBundle messages = ResourceBundle.getBundle("org.netbeans.lib.profiler.ui.threads.Bundle");
    private static final String TEXT_DISPLAY_ALL = messages.getString("ThreadsDetailsPanel_TextDisplayAll");
    private static final String TEXT_DISPLAY_ALL_EX = messages.getString("ThreadsDetailsPanel_TextDisplayAllEx");
    private static final String TEXT_DISPLAY_LIVE = messages.getString("ThreadsDetailsPanel_TextDisplayLive");
    private static final String TEXT_DISPLAY_LIVE_EX = messages.getString("ThreadsDetailsPanel_TextDisplayLiveEx");
    private static final String TEXT_DISPLAY_FINISHED = messages.getString("ThreadsDetailsPanel_TextDisplayFinished");
    private static final String TEXT_DISPLAY_FINISHED_EX = messages.getString("ThreadsDetailsPanel_TextDisplayFinishedEx");
    private static final String TEXT_DISPLAY_SELECTION = messages.getString("ThreadsDetailsPanel_TextDisplaySelection");
    private static final String NO_CONTENT_MSG = messages.getString("ThreadsDetailsPanel_NoContentMsg");
    private static final String EVENTQUEUE_THREAD_DESCR = messages.getString("ThreadsDetailsPanel_EventQueueThreadDescr");
    private static final String IMAGEFETCHER_THREAD_DESCR = messages.getString("ThreadsDetailsPanel_ImageFetcherThreadDescr");
    private static final String IMAGEANIMATOR_THREAD_DESCR = messages.getString("ThreadsDetailsPanel_ImageAnimatorThreadDescr");
    private static final String AWTWINDOWS_THREAD_DESCR = messages.getString("ThreadsDetailsPanel_AwtWindowsThreadDescr");
    private static final String AWTMOTIF_THREAD_DESCR = messages.getString("ThreadsDetailsPanel_AwtMotifThreadDescr");
    private static final String AWTSHUTDWN_THREAD_DESCR = messages.getString("ThreadsDetailsPanel_AwtShutDwnThreadDescr");
    private static final String MAIN_THREAD_DESCR = messages.getString("ThreadsDetailsPanel_MainThreadDescr");
    private static final String FINALIZER_THREAD_DESCR = messages.getString("ThreadsDetailsPanel_FinalizerThreadDescr");
    private static final String REFHANDLER_THREAD_DESCR = messages.getString("ThreadsDetailsPanel_RefHandlerThreadDescr");
    private static final String SIGDISPATCH_THREAD_DESCR = messages.getString("ThreadsDetailsPanel_SigDispatchThreadDescr");
    private static final String J2DISPOSER_THREAD_DESCR = messages.getString("ThreadsDetailsPanel_J2DisposerThreadDescr");
    private static final String TIMERQUEUE_THREAD_DESCR = messages.getString("ThreadsDetailsPanel_TimerQueueThreadDescr");
    private static final String USER_THREAD_DESCR = messages.getString("ThreadsDetailsPanel_UserThreadDescr");
    private static final String COMBO_ACCESS_NAME = messages.getString("ThreadsDetailsPanel_ComboAccessName");
    private static final String COMBO_ACCESS_DESCR = messages.getString("ThreadsDetailsPanel_ComboAccessDescr");
    private static final String CONTENT_ACCESS_NAME = messages.getString("ThreadsDetailsPanel_ContentAccessName");
    private static final String CONTENT_ACCESS_DESCR = messages.getString("ThreadsDetailsPanel_ContentAccessDescr");
    private static final String SHOW_LABEL_TEXT = messages.getString("ThreadsPanel_ShowLabelText");
    private static final int DISPLAY_ALL = 0;
    private static final int DISPLAY_LIVE = 1;
    private static final int DISPLAY_FINISHED = 2;
    private static final int DISPLAY_SELECTED = 3;
    private static final int DISPLAY_ALL_EX = 4;
    private static final int DISPLAY_LIVE_EX = 5;
    private static final int DISPLAY_FINISHED_EX = 6;
    private ArrayList displayedPanels = new ArrayList(10);
    private ArrayList excludedThreads = new ArrayList(5);
    private ArrayList filteredThreads = new ArrayList(10);
    private DefaultComboBoxModel comboModel;
    private HashMap descriptions = new HashMap(20);
    private HashMap indexToDisplayedIndex = new HashMap(15);
    private HashMap unusedPanels = new HashMap(5);
    private JComboBox threadsSelectionCombo;
    private JPanel content;
    private JPanel noContentPanel;
    private JScrollPane scrollPane;
    private JToolBar buttonsToolBar;
    private ThreadsDataManager manager;
    private boolean internalChange = false;
    private boolean noContent = false;
    private boolean resetPerformed = true;
    private boolean supportsSleepingState;
    private int displayMode = 3;

    public ThreadsDetailsPanel(ThreadsDataManager threadsDataManager, boolean bl) {
        this.manager = threadsDataManager;
        this.supportsSleepingState = bl;
        this.noContentPanel = new JPanel();
        this.noContentPanel.setLayout(new BorderLayout());
        this.noContentPanel.setBorder(BorderFactory.createEmptyBorder(12, 12, 12, 12));
        JLabel jLabel = new JLabel(new ImageIcon(this.getClass().getResource("/org/netbeans/lib/profiler/ui/resources/threadsView.png")));
        jLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 5));
        jLabel.setVerticalAlignment(1);
        jLabel.setEnabled(false);
        JTextArea jTextArea = new JTextArea(NO_CONTENT_MSG);
        jTextArea.setFont(jTextArea.getFont().deriveFont(14));
        jTextArea.setEditable(false);
        jTextArea.setEnabled(false);
        jTextArea.setWrapStyleWord(true);
        jTextArea.setLineWrap(true);
        jTextArea.setBackground(this.noContentPanel.getBackground());
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)jLabel, "West");
        jPanel.add((Component)jTextArea, "Center");
        this.noContentPanel.add((Component)jPanel, "North");
        this.threadsSelectionCombo = new JComboBox(){

            public Dimension getMaximumSize() {
                return new Dimension(250, this.getPreferredSize().height);
            }
        };
        this.threadsSelectionCombo.getAccessibleContext().setAccessibleName(COMBO_ACCESS_NAME);
        this.threadsSelectionCombo.getAccessibleContext().setAccessibleDescription(COMBO_ACCESS_DESCR);
        this.updateCombo();
        JLabel jLabel2 = new JLabel(SHOW_LABEL_TEXT);
        jLabel2.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        jLabel2.setLabelFor(this.threadsSelectionCombo);
        int n = 0;
        jLabel2.setDisplayedMnemonic(jLabel2.getText().charAt(n));
        jLabel2.setDisplayedMnemonicIndex(n);
        this.buttonsToolBar = new JToolBar(0){

            public Component add(Component component) {
                if (component instanceof JButton) {
                    UIUtils.fixButtonUI((JButton)component);
                }
                return super.add(component);
            }
        };
        this.content = new JPanel(){

            public Dimension getPreferredSize() {
                Dimension dimension = super.getPreferredSize();
                return new Dimension(Math.min(dimension.width, ((ThreadsDetailsPanel)ThreadsDetailsPanel.this).scrollPane.getViewportBorderBounds().width), dimension.height);
            }
        };
        this.content.getAccessibleContext().setAccessibleName(CONTENT_ACCESS_NAME);
        this.content.getAccessibleContext().setAccessibleName(CONTENT_ACCESS_DESCR);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        this.scrollPane = new JScrollPane(jPanel2, 20, 31);
        this.scrollPane.getVerticalScrollBar().setUnitIncrement(30);
        this.buttonsToolBar.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.buttonsToolBar.setFloatable(false);
        this.buttonsToolBar.putClientProperty("JToolBar.isRollover", Boolean.TRUE);
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.setLayout(new BorderLayout());
        this.content.setLayout(new GridLayout(0, 1));
        jPanel2.add((Component)this.content, "North");
        this.buttonsToolBar.add(jLabel2);
        this.buttonsToolBar.add(this.threadsSelectionCombo);
        this.add((Component)this.buttonsToolBar, "North");
        this.add((Component)this.scrollPane, "Center");
        this.threadsSelectionCombo.addActionListener(this);
        threadsDataManager.addDataListener((DataManagerListener)this);
        this.addHierarchyListener(new HierarchyListener(){

            public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
                if ((hierarchyEvent.getChangeFlags() & 4L) != 0L && ThreadsDetailsPanel.this.isShowing()) {
                    ThreadsDetailsPanel.this.dataChanged();
                }
            }
        });
    }

    public BufferedImage getCurrentViewScreenshot(boolean bl) {
        if (bl) {
            return UIUtils.createScreenshot(this.scrollPane);
        }
        return UIUtils.createScreenshot(this.content);
    }

    public long getDataEndTime() {
        return this.manager.getEndTime();
    }

    public long getDataStartTime() {
        return this.manager.getStartTime();
    }

    public String getThreadClassName(int n) {
        return this.manager.getThreadClassName(n);
    }

    public ThreadData getThreadData(int n) {
        return this.manager.getThreadData(n);
    }

    public String getThreadDescription(int n) {
        String string = (String)this.descriptions.get(new Integer(n));
        if (string == null) {
            string = this.createDescription(this.manager.getThreadName(n));
            this.descriptions.put(new Integer(n), string);
        }
        return string;
    }

    public String getThreadName(int n) {
        return this.manager.getThreadName(n);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.internalChange) {
            return;
        }
        if (actionEvent.getSource() == this.threadsSelectionCombo) {
            String string = (String)this.threadsSelectionCombo.getSelectedItem();
            int n = this.displayMode;
            switch (this.threadsSelectionCombo.getSelectedIndex()) {
                case 0: {
                    this.displayMode = 0;
                    break;
                }
                case 1: {
                    this.displayMode = 1;
                    break;
                }
                case 2: {
                    this.displayMode = 2;
                    break;
                }
                case 3: {
                    this.displayMode = 3;
                    break;
                }
                case 4: {
                    if (string == TEXT_DISPLAY_ALL_EX) {
                        this.displayMode = 4;
                        break;
                    }
                    if (string == TEXT_DISPLAY_LIVE_EX) {
                        this.displayMode = 5;
                        break;
                    }
                    if (string != TEXT_DISPLAY_FINISHED_EX) break;
                    this.displayMode = 6;
                }
            }
            if (n != this.displayMode) {
                switch (this.displayMode) {
                    case 0: {
                        this.excludedThreads.clear();
                        break;
                    }
                    case 1: {
                        this.excludedThreads.clear();
                        break;
                    }
                    case 2: {
                        this.excludedThreads.clear();
                        break;
                    }
                    case 3: {
                        this.excludedThreads.clear();
                        this.filteredThreads.clear();
                    }
                }
                this.updateCombo();
                this.dataChanged();
            }
        }
    }

    public void addSaveViewAction(AbstractAction abstractAction) {
        JButton jButton = this.buttonsToolBar.add(abstractAction);
        this.buttonsToolBar.remove(jButton);
        this.buttonsToolBar.add((Component)jButton, 0);
        this.buttonsToolBar.add((Component)new JToolBar.Separator(), 1);
    }

    public void dataChanged() {
        if (this.resetPerformed) {
            this.supportsSleepingState = this.manager.supportsSleepingStateMonitoring();
            this.resetPerformed = false;
        }
        UIUtils.runInEventDispatchThread(new Runnable(){

            public void run() {
                if (!ThreadsDetailsPanel.this.isShowing()) {
                    return;
                }
                ThreadsDetailsPanel.this.updateFilteredData();
                if (ThreadsDetailsPanel.this.updateDisplayedPanels()) {
                    ThreadsDetailsPanel.this.content.invalidate();
                    ThreadsDetailsPanel.this.revalidate();
                    ThreadsDetailsPanel.this.repaint();
                }
            }
        });
    }

    public void dataReset() {
        this.resetPerformed = true;
        this.filteredThreads.clear();
        this.excludedThreads.clear();
        this.descriptions.clear();
        this.content.removeAll();
        this.unusedPanels.clear();
        this.displayedPanels.clear();
        this.displayMode = 3;
        UIUtils.runInEventDispatchThread(new Runnable(){

            public void run() {
                ThreadsDetailsPanel.this.updateCombo();
                ThreadsDetailsPanel.this.content.invalidate();
                ThreadsDetailsPanel.this.revalidate();
                ThreadsDetailsPanel.this.repaint();
            }
        });
    }

    public boolean fitsVisibleArea() {
        return !this.scrollPane.getVerticalScrollBar().isVisible();
    }

    public boolean hasView() {
        return !this.noContent && this.content.getComponentCount() > 0;
    }

    public void hideThreadDetails(int n) {
        if (this.displayMode == 3) {
            this.filteredThreads.remove(new Integer(n));
        } else {
            if (this.displayMode == 0) {
                this.displayMode = 4;
                this.updateCombo();
            } else if (this.displayMode == 1) {
                this.displayMode = 5;
                this.updateCombo();
            } else if (this.displayMode == 2) {
                this.displayMode = 6;
                this.updateCombo();
            }
            this.excludedThreads.add(new Integer(n));
            this.updateFilteredData();
        }
        if (this.updateDisplayedPanels()) {
            this.content.invalidate();
            this.revalidate();
            this.repaint();
        }
    }

    public void showDetails(int[] nArray) {
        this.displayMode = 3;
        this.filteredThreads.clear();
        this.excludedThreads.clear();
        for (int i = 0; i < nArray.length; ++i) {
            this.filteredThreads.add(new Integer(nArray[i]));
        }
        this.updateCombo();
        if (this.updateDisplayedPanels()) {
            this.content.invalidate();
            this.revalidate();
            this.repaint();
        }
    }

    private ThreadDetailsComponent getPanel(int n) {
        ThreadDetailsComponent threadDetailsComponent = (ThreadDetailsComponent)this.unusedPanels.remove(new Integer(n));
        if (threadDetailsComponent == null) {
            threadDetailsComponent = this.unusedPanels.size() > 0 ? (ThreadDetailsComponent)this.unusedPanels.remove(this.unusedPanels.keySet().iterator().next()) : new ThreadDetailsComponent(this, this.supportsSleepingState);
        }
        threadDetailsComponent.setIndex(n);
        return threadDetailsComponent;
    }

    private String createDescription(String string) {
        if (string.startsWith("AWT-EventQueue-")) {
            return EVENTQUEUE_THREAD_DESCR;
        }
        if (string.startsWith("Image Fetcher ")) {
            return IMAGEFETCHER_THREAD_DESCR;
        }
        if (string.startsWith("Image Animator ")) {
            return IMAGEANIMATOR_THREAD_DESCR;
        }
        if (string.equals("AWT-Windows")) {
            return AWTWINDOWS_THREAD_DESCR;
        }
        if (string.equals("AWT-Motif")) {
            return AWTMOTIF_THREAD_DESCR;
        }
        if (string.equals("AWT-Shutdown")) {
            return AWTSHUTDWN_THREAD_DESCR;
        }
        if (string.equals("main")) {
            return MAIN_THREAD_DESCR;
        }
        if (string.equals("Finalizer")) {
            return FINALIZER_THREAD_DESCR;
        }
        if (string.equals("Reference Handler")) {
            return REFHANDLER_THREAD_DESCR;
        }
        if (string.equals("Signal Dispatcher")) {
            return SIGDISPATCH_THREAD_DESCR;
        }
        if (string.equals("Java2D Disposer")) {
            return J2DISPOSER_THREAD_DESCR;
        }
        if (string.equals("TimerQueue")) {
            return TIMERQUEUE_THREAD_DESCR;
        }
        return USER_THREAD_DESCR;
    }

    private void updateCombo() {
        this.internalChange = true;
        this.comboModel = new DefaultComboBoxModel<Object>(new Object[]{TEXT_DISPLAY_ALL, TEXT_DISPLAY_LIVE, TEXT_DISPLAY_FINISHED, TEXT_DISPLAY_SELECTION});
        int n = 0;
        switch (this.displayMode) {
            case 0: {
                n = 0;
                break;
            }
            case 1: {
                n = 1;
                break;
            }
            case 2: {
                n = 2;
                break;
            }
            case 3: {
                n = 3;
                break;
            }
            case 4: {
                this.comboModel.addElement(TEXT_DISPLAY_ALL_EX);
                n = 4;
                break;
            }
            case 5: {
                this.comboModel.addElement(TEXT_DISPLAY_LIVE_EX);
                n = 4;
                break;
            }
            case 6: {
                this.comboModel.addElement(TEXT_DISPLAY_FINISHED_EX);
                n = 4;
            }
        }
        this.threadsSelectionCombo.setModel(this.comboModel);
        this.threadsSelectionCombo.setSelectedIndex(n);
        this.internalChange = false;
    }

    private boolean updateDisplayedPanels() {
        Object object;
        int n;
        int n2;
        boolean bl = false;
        int n3 = this.filteredThreads.size();
        if (n3 == 0) {
            if (!this.noContent) {
                this.noContent = true;
                this.remove(this.scrollPane);
                this.add((Component)this.noContentPanel, "Center");
                this.invalidate();
                this.revalidate();
                this.repaint();
            }
            return bl;
        }
        if (this.noContent) {
            this.noContent = false;
            this.remove(this.noContentPanel);
            this.add((Component)this.scrollPane, "Center");
            this.invalidate();
            this.revalidate();
            this.repaint();
        }
        if (n3 > (n2 = this.displayedPanels.size())) {
            for (n = n2; n < n3; ++n) {
                object = this.getPanel((Integer)this.filteredThreads.get(n));
                this.displayedPanels.add(object);
                this.content.add((Component)object);
            }
            bl = true;
        } else if (n3 < n2) {
            for (n = n3; n < n2; ++n) {
                object = (ThreadDetailsComponent)this.displayedPanels.remove(n3);
                this.unusedPanels.put(new Integer(((ThreadDetailsComponent)object).getIndex()), object);
                this.content.remove((Component)object);
            }
            bl = true;
        }
        this.indexToDisplayedIndex.clear();
        n = 0;
        object = this.filteredThreads.iterator();
        while (object.hasNext()) {
            int n4 = (Integer)object.next();
            ((ThreadDetailsComponent)this.displayedPanels.get(n)).setIndex(n4);
            this.indexToDisplayedIndex.put(new Integer(n4), new Integer(n));
            ++n;
        }
        return bl;
    }

    private boolean updateDisplayedPanels1() {
        Object object;
        int n;
        this.content.removeAll();
        this.indexToDisplayedIndex.clear();
        for (n = this.displayedPanels.size() - 1; n >= 0; --n) {
            object = (ThreadDetailsComponent)this.displayedPanels.remove(n);
            this.unusedPanels.put(new Integer(((ThreadDetailsComponent)object).getIndex()), object);
        }
        n = 0;
        object = this.filteredThreads.iterator();
        while (object.hasNext()) {
            int n2 = (Integer)object.next();
            ThreadDetailsComponent threadDetailsComponent = this.getPanel(n2);
            this.content.add(threadDetailsComponent);
            this.displayedPanels.add(threadDetailsComponent);
            this.indexToDisplayedIndex.put(new Integer(n2), new Integer(n++));
        }
        return true;
    }

    private void updateFilteredData() {
        byte by;
        ThreadData threadData;
        int n;
        if (this.displayMode == 3) {
            return;
        }
        this.filteredThreads.clear();
        if (this.displayMode == 0 || this.displayMode == 4) {
            for (n = 0; n < this.manager.getThreadsCount(); ++n) {
                this.filteredThreads.add(new Integer(n));
            }
        }
        if (this.displayMode == 1 || this.displayMode == 5) {
            for (n = 0; n < this.manager.getThreadsCount(); ++n) {
                threadData = this.manager.getThreadData(n);
                if (threadData.size() <= 0 || (by = threadData.getLastState()) == 0) continue;
                this.filteredThreads.add(new Integer(n));
            }
        }
        if (this.displayMode == 2 || this.displayMode == 6) {
            for (n = 0; n < this.manager.getThreadsCount(); ++n) {
                threadData = this.manager.getThreadData(n);
                if (threadData.size() > 0) {
                    by = threadData.getLastState();
                    if (by != 0) continue;
                    this.filteredThreads.add(new Integer(n));
                    continue;
                }
                this.filteredThreads.add(new Integer(n));
            }
        }
        if (this.displayMode == 4 || this.displayMode == 5 || this.displayMode == 6) {
            this.filteredThreads.removeAll(this.excludedThreads);
        }
    }
}

