/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.charts.xy;

import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;
import org.netbeans.lib.profiler.charts.ChartConfigurationListener;
import org.netbeans.lib.profiler.charts.PaintersModel;
import org.netbeans.lib.profiler.charts.Timeline;
import org.netbeans.lib.profiler.charts.xy.synchronous.SynchronousXYChart;
import org.netbeans.lib.profiler.charts.xy.synchronous.SynchronousXYItemsModel;

public class ProfilerXYChart
extends SynchronousXYChart {
    private static final ResourceBundle messages = ResourceBundle.getBundle("org.netbeans.lib.profiler.ui.charts.xy.Bundle");
    private static final String ZOOM_IN_STRING = messages.getString("ProfilerXYChart_ZoomInString");
    private static final String ZOOM_OUT_STRING = messages.getString("ProfilerXYChart_ZoomOutString");
    private static final String FIXED_SCALE_STRING = messages.getString("ProfilerXYChart_FixedScaleString");
    private static final String SCALE_TO_FIT_STRING = messages.getString("ProfilerXYChart_ScaleToFitString");
    private static final Icon ZOOM_IN_ICON = new ImageIcon(ProfilerXYChart.class.getResource("/org/netbeans/lib/profiler/ui/resources/zoomIn.png"));
    private static final Icon ZOOM_OUT_ICON = new ImageIcon(ProfilerXYChart.class.getResource("/org/netbeans/lib/profiler/ui/resources/zoomOut.png"));
    private static final Icon FIXED_SCALE_ICON = new ImageIcon(ProfilerXYChart.class.getResource("/org/netbeans/lib/profiler/ui/resources/zoom.png"));
    private static final Icon SCALE_TO_FIT_ICON = new ImageIcon(ProfilerXYChart.class.getResource("/org/netbeans/lib/profiler/ui/resources/scaleToFit.png"));
    private ZoomInAction zoomInAction;
    private ZoomOutAction zoomOutAction;
    private ToggleViewAction toggleViewAction;

    public ProfilerXYChart(SynchronousXYItemsModel synchronousXYItemsModel, PaintersModel paintersModel) {
        super(synchronousXYItemsModel, paintersModel);
        this.setBottomBased(true);
        this.setFitsHeight(true);
        this.setMousePanningEnabled(false);
        this.addConfigurationListener((ChartConfigurationListener)new VisibleBoundsListener());
    }

    public Action zoomInAction() {
        if (this.zoomInAction == null) {
            this.zoomInAction = new ZoomInAction();
        }
        return this.zoomInAction;
    }

    public Action zoomOutAction() {
        if (this.zoomOutAction == null) {
            this.zoomOutAction = new ZoomOutAction();
        }
        return this.zoomOutAction;
    }

    public Action toggleViewAction() {
        if (this.toggleViewAction == null) {
            this.toggleViewAction = new ToggleViewAction();
        }
        return this.toggleViewAction;
    }

    private class VisibleBoundsListener
    extends ChartConfigurationListener.Adapter {
        private VisibleBoundsListener() {
        }

        public void dataBoundsChanged(long l, long l2, long l3, long l4, long l5, long l6, long l7, long l8) {
            if (ProfilerXYChart.this.zoomInAction != null) {
                ProfilerXYChart.this.zoomInAction.updateAction();
            }
            if (ProfilerXYChart.this.zoomOutAction != null) {
                ProfilerXYChart.this.zoomOutAction.updateAction();
            }
        }

        public void scaleChanged(double d, double d2, double d3, double d4) {
            if (ProfilerXYChart.this.zoomInAction != null) {
                ProfilerXYChart.this.zoomInAction.updateAction();
            }
            if (ProfilerXYChart.this.zoomOutAction != null) {
                ProfilerXYChart.this.zoomOutAction.updateAction();
            }
        }
    }

    private class ToggleViewAction
    extends AbstractAction {
        private long origOffsetX = -1L;
        private double origScaleX = -1.0;

        public ToggleViewAction() {
            this.updateAction();
            ProfilerXYChart.this.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent mouseEvent) {
                    if (SwingUtilities.isMiddleMouseButton(mouseEvent)) {
                        ToggleViewAction.this.actionPerformed(null);
                    }
                }
            });
        }

        public void actionPerformed(ActionEvent actionEvent) {
            boolean bl = ProfilerXYChart.this.fitsWidth();
            if (!bl) {
                this.origOffsetX = ProfilerXYChart.this.getOffsetX();
                if (ProfilerXYChart.this.tracksDataWidth() && this.origOffsetX == ProfilerXYChart.this.getMaxOffsetX()) {
                    this.origOffsetX = Long.MAX_VALUE;
                }
                this.origScaleX = ProfilerXYChart.this.getScaleX();
            }
            ProfilerXYChart.this.setFitsWidth(!bl);
            if (bl && this.origOffsetX != -1L && this.origScaleX != -1.0) {
                ProfilerXYChart.this.setScale(this.origScaleX, ProfilerXYChart.this.getScaleY());
                ProfilerXYChart.this.setOffset(this.origOffsetX, ProfilerXYChart.this.getOffsetY());
            }
            this.updateAction();
            if (ProfilerXYChart.this.zoomInAction != null) {
                ProfilerXYChart.this.zoomInAction.updateAction();
            }
            if (ProfilerXYChart.this.zoomOutAction != null) {
                ProfilerXYChart.this.zoomOutAction.updateAction();
            }
            ProfilerXYChart.this.repaintDirty();
        }

        private void updateAction() {
            boolean bl = ProfilerXYChart.this.fitsWidth();
            Icon icon = bl ? FIXED_SCALE_ICON : SCALE_TO_FIT_ICON;
            String string = bl ? FIXED_SCALE_STRING : SCALE_TO_FIT_STRING;
            this.putValue("ShortDescription", string);
            this.putValue("SmallIcon", icon);
        }
    }

    private class ZoomOutAction
    extends AbstractAction {
        private static final float USED_CHART_WIDTH_THRESHOLD = 0.33f;

        public ZoomOutAction() {
            this.putValue("ShortDescription", ZOOM_OUT_STRING);
            this.putValue("SmallIcon", ZOOM_OUT_ICON);
            this.updateAction();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            boolean bl = ProfilerXYChart.this.currentlyFollowingDataWidth();
            ProfilerXYChart.this.zoom(ProfilerXYChart.this.getWidth() / 2, ProfilerXYChart.this.getHeight() / 2, 0.5);
            if (bl) {
                ProfilerXYChart.this.setOffset(ProfilerXYChart.this.getMaxOffsetX(), ProfilerXYChart.this.getOffsetY());
            }
            ProfilerXYChart.this.repaintDirty();
        }

        private void updateAction() {
            Timeline timeline = ((SynchronousXYItemsModel)ProfilerXYChart.this.getItemsModel()).getTimeline();
            this.setEnabled(timeline.getTimestampsCount() > 0 && !ProfilerXYChart.this.fitsWidth() && (float)ProfilerXYChart.this.getContentsWidth() > (float)ProfilerXYChart.this.getWidth() * 0.33f);
        }
    }

    private class ZoomInAction
    extends AbstractAction {
        private static final int ONE_SECOND_WIDTH_THRESHOLD = 200;

        public ZoomInAction() {
            this.putValue("ShortDescription", ZOOM_IN_STRING);
            this.putValue("SmallIcon", ZOOM_IN_ICON);
            this.updateAction();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            boolean bl = ProfilerXYChart.this.currentlyFollowingDataWidth();
            ProfilerXYChart.this.zoom(ProfilerXYChart.this.getWidth() / 2, ProfilerXYChart.this.getHeight() / 2, 2.0);
            if (bl) {
                ProfilerXYChart.this.setOffset(ProfilerXYChart.this.getMaxOffsetX(), ProfilerXYChart.this.getOffsetY());
            }
            ProfilerXYChart.this.repaintDirty();
        }

        private void updateAction() {
            Timeline timeline = ((SynchronousXYItemsModel)ProfilerXYChart.this.getItemsModel()).getTimeline();
            this.setEnabled(timeline.getTimestampsCount() > 1 && !ProfilerXYChart.this.fitsWidth() && ProfilerXYChart.this.getViewWidth(1000.0) < 200.0);
        }
    }
}

