/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.dtrace.collector;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.modules.dlight.api.storage.DataRow;
import org.netbeans.modules.dlight.api.storage.DataTableMetadata;
import org.netbeans.modules.dlight.util.DLightLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DtraceParser {
    private static final Logger log = DLightLogger.getLogger(DtraceParser.class);
    private final DataTableMetadata metadata;
    private final List<String> colnames;
    private static final Pattern regex = Pattern.compile("[^\\s\"']+|\"[^\"]*\"|'[^']*'");
    private static final String dquote = "\"";
    private static final String squote = "'";

    public DtraceParser(DataTableMetadata dataTableMetadata) {
        this.metadata = dataTableMetadata;
        if (dataTableMetadata != null) {
            this.colnames = new ArrayList<String>(dataTableMetadata.getColumnsCount());
            for (DataTableMetadata.Column column : dataTableMetadata.getColumns()) {
                this.colnames.add(column.getColumnName());
            }
        } else {
            this.colnames = Collections.emptyList();
        }
    }

    private List<String> parse(String string) {
        assert (this.metadata != null);
        return this.parse(string, this.metadata.getColumnsCount());
    }

    protected List<String> parse(String string, int n) {
        ArrayList<String> arrayList = new ArrayList<String>();
        Matcher matcher = regex.matcher(string);
        while (matcher.find()) {
            arrayList.add(matcher.group());
        }
        if (arrayList.size() < n && log.isLoggable(Level.INFO)) {
            log.info("^^^^^Line:" + string + " lines array size is " + "less than medatadat.getCoulmnsCount() columnsCount=" + this.metadata.getColumnsCount() + " lines splited=" + arrayList.size());
            return null;
        }
        List list = this.metadata.getColumns();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (int i = 0; i < n; ++i) {
            Class clazz = ((DataTableMetadata.Column)list.get(i)).getColumnClass();
            if (clazz == String.class) {
                String string2 = (String)arrayList.get(i);
                if (string2 != null && string2.startsWith(dquote)) {
                    string2 = string2.substring(1);
                }
                if (string2 != null && string2.endsWith(dquote)) {
                    string2 = string2.substring(0, string2.length() - 1);
                }
                arrayList2.add(i, string2);
                continue;
            }
            arrayList2.add(i, (String)arrayList.get(i));
        }
        return arrayList2;
    }

    public DataRow process(String string) {
        List<String> list = this.parse(string);
        if (list == null) {
            return null;
        }
        return new DataRow(this.colnames, list);
    }

    public DataRow processClose() {
        return null;
    }
}

