/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.editor.reformat;

import java.util.Iterator;
import java.util.LinkedList;
import org.netbeans.modules.cnd.editor.reformat.ExtendedTokenSequence;
import org.netbeans.modules.cnd.editor.reformat.Reformatter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DiffLinkedList {
    private LinkedList<Reformatter.Diff> storage = new LinkedList();

    DiffLinkedList() {
    }

    Reformatter.Diff addFirst(int n, int n2, int n3, int n4, boolean bl) {
        Reformatter.Diff diff = new Reformatter.Diff(n, n2, n3, n4, bl);
        this.storage.add(this.getIndex(n, n2), diff);
        return diff;
    }

    private int getIndex(int n, int n2) {
        int n3 = 0;
        Iterator iterator = this.storage.iterator();
        while (iterator.hasNext()) {
            Reformatter.Diff diff = (Reformatter.Diff)iterator.next();
            if (diff.getStartOffset() <= n) {
                if (diff.getStartOffset() != n || diff.getEndOffset() != n2) break;
                iterator.remove();
                break;
            }
            ++n3;
        }
        return n3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DiffResult getDiffs(ExtendedTokenSequence extendedTokenSequence, int n) {
        int n2;
        int n3;
        if (n != 0) {
            int n4 = extendedTokenSequence.index();
            try {
                if (n > 0) {
                    while (extendedTokenSequence.moveNext() && --n != 0) {
                    }
                } else {
                    while (extendedTokenSequence.movePrevious() && ++n != 0) {
                    }
                }
                n3 = extendedTokenSequence.offset();
                n2 = extendedTokenSequence.offset() + extendedTokenSequence.token().length();
            }
            finally {
                extendedTokenSequence.moveIndex(n4);
                extendedTokenSequence.moveNext();
            }
        } else {
            n3 = extendedTokenSequence.offset();
            n2 = extendedTokenSequence.offset() + extendedTokenSequence.token().length();
        }
        return this.getDiffs(n3, n2);
    }

    DiffResult getDiffs(int n, int n2) {
        DiffResult diffResult = null;
        for (Reformatter.Diff diff : this.storage) {
            if (diff.getStartOffset() == n) {
                if (diff.getEndOffset() == n2) {
                    if (diffResult == null) {
                        diffResult = new DiffResult();
                    }
                    diffResult.replace = diff;
                } else {
                    if (diffResult == null) {
                        diffResult = new DiffResult();
                    }
                    diffResult.before = diff;
                }
            } else if (diff.getEndOffset() == n2) {
                if (diffResult == null) {
                    diffResult = new DiffResult();
                }
                diffResult.after = diff;
            }
            if (diff.getEndOffset() >= n) continue;
            return diffResult;
        }
        return diffResult;
    }

    Reformatter.Diff getFirst() {
        if (this.storage.isEmpty()) {
            return null;
        }
        return this.storage.getFirst();
    }

    LinkedList<Reformatter.Diff> getStorage() {
        return this.storage;
    }

    static class DiffResult {
        Reformatter.Diff before;
        Reformatter.Diff replace;
        Reformatter.Diff after;

        DiffResult() {
        }
    }
}

