/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.editor.api;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.StyledDocument;
import org.netbeans.modules.cnd.editor.indent.CppIndentTask;
import org.netbeans.modules.cnd.utils.MIMEExtensions;
import org.netbeans.modules.cnd.utils.MIMENames;
import org.netbeans.modules.editor.indent.api.Reformat;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;

public final class FormattingSupport {
    private FormattingSupport() {
    }

    public static String getLineIndentation(Document document, int n) {
        int n2 = new CppIndentTask(document).getLineIndentation(n);
        StringBuilder stringBuilder = new StringBuilder(n2);
        for (int i = 0; i < n2; ++i) {
            stringBuilder.append(' ');
        }
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CharSequence getFormattedText(Document document, int n, CharSequence charSequence) {
        if (document == null) {
            System.err.println("original document is not specified for getFormattedText" + document);
            return charSequence;
        }
        String string = (String)document.getProperty("mimeType");
        if (!MIMENames.isHeaderOrCppOrC((String)string)) {
            System.err.println("Unsupported MIME type of document " + document);
            return charSequence;
        }
        String string2 = MIMEExtensions.get((String)string).getDefaultExtension();
        try {
            FileSystem fileSystem = FileUtil.createMemoryFileSystem();
            FileObject fileObject = fileSystem.getRoot();
            String string3 = FileUtil.findFreeFileName((FileObject)fileObject, (String)"cnd-format", (String)string2);
            FileObject fileObject2 = FileUtil.createData((FileObject)fileObject, (String)(string3 + "." + string2));
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(fileObject2.getOutputStream());
            try {
                ((Writer)outputStreamWriter).append(charSequence);
                ((Writer)outputStreamWriter).flush();
            }
            finally {
                ((Writer)outputStreamWriter).close();
            }
            DataObject dataObject = DataObject.find((FileObject)fileObject2);
            EditorCookie editorCookie = (EditorCookie)dataObject.getCookie(EditorCookie.class);
            if (editorCookie != null) {
                int n2;
                StyledDocument styledDocument = editorCookie.openDocument();
                Reformat reformat = Reformat.get((Document)styledDocument);
                reformat.lock();
                try {
                    try {
                        reformat.reformat(0, styledDocument.getLength());
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                }
                finally {
                    reformat.unlock();
                }
                SaveCookie saveCookie = (SaveCookie)dataObject.getCookie(SaveCookie.class);
                if (saveCookie != null) {
                    saveCookie.save();
                }
                String string4 = styledDocument.getText(0, styledDocument.getLength());
                StringBuilder stringBuilder = new StringBuilder();
                int n3 = string4.length();
                int n4 = n3 - 1;
                for (n2 = 0; n2 < n3 && Character.isWhitespace(string4.charAt(n2)); ++n2) {
                }
                while (n4 > n2 && Character.isWhitespace(string4.charAt(n4))) {
                    --n4;
                }
                String string5 = FormattingSupport.getLineIndentation(document, n);
                stringBuilder.append(string5);
                for (int i = n2; i <= n4; ++i) {
                    char c = string4.charAt(i);
                    if (c == '\n') {
                        if (i > n4) continue;
                        stringBuilder.append(c);
                        stringBuilder.append(string5);
                        continue;
                    }
                    stringBuilder.append(c);
                }
                return stringBuilder.toString();
            }
            fileObject2.delete();
        }
        catch (BadLocationException badLocationException) {
        }
        catch (IOException iOException) {
            iOException.printStackTrace(System.err);
        }
        return charSequence;
    }
}

