/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.project.ui.customizer;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Comparator;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.netbeans.api.mobility.project.ui.customizer.ProjectProperties;
import org.netbeans.spi.mobility.project.ui.customizer.CustomizerPanel;
import org.netbeans.spi.mobility.project.ui.customizer.VisualPropertyGroup;
import org.netbeans.spi.mobility.project.ui.customizer.support.VisualPropertySupport;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class CustomizerCompile
extends JPanel
implements CustomizerPanel,
VisualPropertyGroup {
    public static final String[] DEBUG_LEVELS = new String[]{"debug", "info", "warn", "error", "fatal"};
    public static final String[] ENCODINGS = Charset.availableCharsets().keySet().toArray(new String[0]);
    private static final String[] PROPERTY_GROUP = new String[]{"javac.deprecation", "javac.debug", "javac.optimize", "javac.encoding", "debug.level"};
    private VisualPropertySupport vps;
    private JCheckBox debugCheck;
    private JCheckBox defaultCheck;
    private JCheckBox deprecateCheck;
    private JComboBox jComboBoxEncoding;
    private JComboBox jComboDebugLevel;
    private JLabel jLabelDebugLevel;
    private JLabel jLabelEncoding;
    private JPanel jPanel1;
    private JLabel javacLabel;
    private JCheckBox optimizeCheck;

    public CustomizerCompile() {
        this.initComponents();
        this.initAccessibility();
        Arrays.sort(ENCODINGS, new EncodingComparator());
    }

    public void initValues(ProjectProperties projectProperties, String string) {
        this.vps = VisualPropertySupport.getDefault(projectProperties);
        this.vps.register(this.defaultCheck, string, this);
    }

    public void initGroupValues(boolean bl) {
        this.vps.register(this.deprecateCheck, "javac.deprecation", bl);
        this.vps.register(this.debugCheck, "javac.debug", bl);
        this.vps.register(this.optimizeCheck, "javac.optimize", bl);
        this.vps.register(this.jComboBoxEncoding, ENCODINGS, "javac.encoding", bl);
        this.vps.register(this.jComboDebugLevel, DEBUG_LEVELS, "debug.level", bl);
        this.javacLabel.setEnabled(!bl);
        this.jLabelEncoding.setEnabled(!bl);
        this.jLabelDebugLevel.setEnabled(!bl);
    }

    public String[] getGroupPropertyNames() {
        return PROPERTY_GROUP;
    }

    private void initComponents() {
        this.defaultCheck = new JCheckBox();
        this.javacLabel = new JLabel();
        this.debugCheck = new JCheckBox();
        this.optimizeCheck = new JCheckBox();
        this.deprecateCheck = new JCheckBox();
        this.jLabelEncoding = new JLabel();
        this.jComboBoxEncoding = new JComboBox();
        this.jLabelDebugLevel = new JLabel();
        this.jComboDebugLevel = new JComboBox();
        this.jPanel1 = new JPanel();
        this.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((AbstractButton)this.defaultCheck, (String)NbBundle.getMessage(CustomizerCompile.class, (String)"LBL_Use_Default"));
        this.defaultCheck.setMargin(new Insets(0, 0, 0, 2));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.defaultCheck, gridBagConstraints);
        this.defaultCheck.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerCompile.class, (String)"ACSD_CustCompile_UseDefault"));
        Mnemonics.setLocalizedText((JLabel)this.javacLabel, (String)NbBundle.getMessage(CustomizerCompile.class, (String)"LBL_CustCompile_JavacOptions"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.add((Component)this.javacLabel, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.debugCheck, (String)NbBundle.getMessage(CustomizerCompile.class, (String)"LBL_CustCompile_DebuggingInfo"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.add((Component)this.debugCheck, gridBagConstraints);
        this.debugCheck.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerCompile.class, (String)"ACSD_CustCompile_GenDebug"));
        Mnemonics.setLocalizedText((AbstractButton)this.optimizeCheck, (String)NbBundle.getMessage(CustomizerCompile.class, (String)"LBL_CustCompile_Optimization"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.add((Component)this.optimizeCheck, gridBagConstraints);
        this.optimizeCheck.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerCompile.class, (String)"ACSD_CustCompile_Optimalization"));
        Mnemonics.setLocalizedText((AbstractButton)this.deprecateCheck, (String)NbBundle.getMessage(CustomizerCompile.class, (String)"LBL_CustCompile_ReportDeprecated"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.add((Component)this.deprecateCheck, gridBagConstraints);
        this.deprecateCheck.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerCompile.class, (String)"ACSD_CustCompile_Deprecated"));
        this.jLabelEncoding.setLabelFor(this.jComboBoxEncoding);
        Mnemonics.setLocalizedText((JLabel)this.jLabelEncoding, (String)NbBundle.getMessage(CustomizerCompile.class, (String)"LBL_CustCompile_Encoding"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(11, 0, 0, 0);
        this.add((Component)this.jLabelEncoding, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(11, 5, 0, 0);
        this.add((Component)this.jComboBoxEncoding, gridBagConstraints);
        this.jLabelDebugLevel.setLabelFor(this.jComboDebugLevel);
        Mnemonics.setLocalizedText((JLabel)this.jLabelDebugLevel, (String)NbBundle.getMessage(CustomizerCompile.class, (String)"LBL_CustCompile_DebugLevel"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(11, 0, 0, 0);
        this.add((Component)this.jLabelDebugLevel, gridBagConstraints);
        this.jComboDebugLevel.setEditable(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(11, 5, 0, 0);
        this.add((Component)this.jComboDebugLevel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jPanel1, gridBagConstraints);
    }

    private void initAccessibility() {
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CustomizerCompile.class, (String)"ACSN_CustCompile"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerCompile.class, (String)"ACSD_CustCompile"));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class EncodingComparator
    implements Comparator<String> {
        String defCharset = Charset.defaultCharset().displayName();

        private EncodingComparator() {
        }

        @Override
        public int compare(String string, String string2) {
            if ("UTF-8".equals(string)) {
                return -2147483647;
            }
            if ("UTF-8".equals(string2)) {
                return 0x7FFFFFFE;
            }
            if (this.defCharset.equals(string)) {
                return Integer.MIN_VALUE;
            }
            if (this.defCharset.equals(string2)) {
                return Integer.MAX_VALUE;
            }
            return string.compareToIgnoreCase(string2);
        }
    }
}

