/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.project.ui;

import java.awt.EventQueue;
import java.awt.Image;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashSet;
import java.util.List;
import javax.swing.Action;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.modules.mobility.project.J2MEProject;
import org.netbeans.modules.mobility.project.ui.AbilitiesPanel;
import org.netbeans.modules.mobility.project.ui.DecoratedNode;
import org.netbeans.modules.mobility.project.ui.ResourcesChildren;
import org.netbeans.modules.mobility.project.ui.actions.AddFolderAction;
import org.netbeans.modules.mobility.project.ui.actions.AddJarAction;
import org.netbeans.modules.mobility.project.ui.actions.AddLibraryAction;
import org.netbeans.modules.mobility.project.ui.actions.AddProjectAction;
import org.netbeans.modules.mobility.project.ui.actions.NodeAction;
import org.netbeans.modules.mobility.project.ui.customizer.VisualClassPathItem;
import org.netbeans.spi.project.ProjectConfiguration;
import org.netbeans.spi.project.support.ant.AntProjectEvent;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.AntProjectListener;
import org.netbeans.spi.project.support.ant.PropertyProvider;
import org.openide.actions.PasteAction;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.ChildFactory;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.NodeTransfer;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;
import org.openide.util.actions.SystemAction;
import org.openide.util.datatransfer.PasteType;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ResourcesNode
extends DecoratedNode
implements ChangeListener,
PropertyChangeListener,
Runnable {
    private static final String PLATFORM_ICON = "org/netbeans/modules/mobility/cldcplatform/resources/platform.gif";
    private final ResourcesChildren children;
    private final InstanceContent content;
    private final ProjectConfiguration config;
    private final L l = new L();

    protected ResourcesNode(J2MEProject j2MEProject, ProjectConfiguration projectConfiguration) {
        this(j2MEProject, projectConfiguration, new ResourcesChildren(j2MEProject, projectConfiguration), new InstanceContent());
    }

    private ResourcesNode(J2MEProject j2MEProject, ProjectConfiguration projectConfiguration, ResourcesChildren resourcesChildren, InstanceContent instanceContent) {
        super(Children.create((ChildFactory)resourcesChildren, (boolean)true), (Lookup)new ProxyLookup(new Lookup[]{Lookups.fixed((Object[])new Object[]{j2MEProject, AbilitiesPanel.hintInstance}), new AbstractLookup((AbstractLookup.Content)instanceContent)}));
        this.config = projectConfiguration;
        this.children = resourcesChildren;
        this.content = instanceContent;
        assert (this.children != null);
        assert (j2MEProject != null);
        instanceContent.set(Arrays.asList(projectConfiguration == null ? j2MEProject.getConfigurationHelper().getActiveConfiguration() : projectConfiguration), null);
        this.setIconBaseWithExtension(PLATFORM_ICON);
        this.setDisplayName(NbBundle.getMessage(ResourcesNode.class, (String)"LBL_NodeCache_Resources"));
        this.change();
        AntProjectHelper antProjectHelper = (AntProjectHelper)j2MEProject.getLookup().lookup(AntProjectHelper.class);
        PropertyProvider propertyProvider = antProjectHelper.getPropertyProvider("nbproject/project.properties");
        propertyProvider.addChangeListener(WeakListeners.change((ChangeListener)this, (Object)propertyProvider));
        j2MEProject.getConfigurationHelper().addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)propertyProvider));
        antProjectHelper.addAntProjectListener((AntProjectListener)WeakListeners.create(AntProjectListener.class, (EventListener)this.l, (Object)antProjectHelper));
        JavaPlatformManager javaPlatformManager = JavaPlatformManager.getDefault();
        javaPlatformManager.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.l, (Object)javaPlatformManager));
        LibraryManager libraryManager = LibraryManager.getDefault();
        libraryManager.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)this.l));
    }

    @Override
    protected boolean isBroken() {
        J2MEProject j2MEProject = (J2MEProject)this.getLookup().lookup(J2MEProject.class);
        boolean bl = j2MEProject.isConfigBroken(this.config);
        return bl;
    }

    private void change() {
        J2MEProject j2MEProject = (J2MEProject)this.getLookup().lookup(J2MEProject.class);
        assert (j2MEProject != null);
        ProjectConfiguration projectConfiguration = this.config == null ? j2MEProject.getConfigurationHelper().getActiveConfiguration() : this.config;
        this.content.set(projectConfiguration == null ? Collections.EMPTY_SET : Collections.singleton(projectConfiguration), null);
        EventQueue.invokeLater(this);
        this.children.update();
    }

    @Override
    public void run() {
        this.updateDisplayName();
    }

    private void updateDisplayName() {
        J2MEProject j2MEProject = (J2MEProject)this.getLookup().lookup(J2MEProject.class);
        assert (j2MEProject != null);
        boolean bl = j2MEProject.isUsingDefaultLibs(this.config);
        this.setValue("gray", bl);
        if (bl) {
            ProjectConfiguration projectConfiguration = j2MEProject.getConfigurationHelper().getDefaultConfiguration();
            if (projectConfiguration != null) {
                String string = j2MEProject.getConfigurationHelper().getDefaultConfiguration().getDisplayName();
                this.setDisplayName(NbBundle.getMessage(ResourcesNode.class, (String)"LBL_NodeCache_InheritedResources", (Object)string));
                return;
            }
            this.setValue("gray", true);
        }
        this.setDisplayName(NbBundle.getMessage(ResourcesNode.class, (String)"LBL_NodeCache_Resources"));
    }

    public Action[] getActions(boolean bl) {
        Action[] actionArray;
        boolean bl2 = Boolean.TRUE.equals(this.getValue("gray"));
        if (bl2) {
            actionArray = new Action[]{};
        } else {
            Action[] actionArray2 = new Action[6];
            actionArray2[0] = AddProjectAction.getStaticInstance();
            actionArray2[1] = AddJarAction.getStaticInstance();
            actionArray2[2] = AddFolderAction.getStaticInstance();
            actionArray2[3] = AddLibraryAction.getStaticInstance();
            actionArray2[4] = null;
            actionArray = actionArray2;
            actionArray2[5] = SystemAction.get(PasteAction.class);
        }
        return actionArray;
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        this.change();
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.change();
    }

    @Override
    public Image getIcon(int n) {
        Image image = ImageUtilities.loadImage((String)"org/netbeans/modules/mobility/project/ui/resources/libraries-badge.png");
        return ImageUtilities.mergeImages((Image)super.getIcon(n), (Image)image, (int)6, (int)8);
    }

    private PasteType getPasteType(final Transferable transferable, DataFlavor[] dataFlavorArray) {
        final HashSet<VisualClassPathItem> hashSet = new HashSet<VisualClassPathItem>();
        for (DataFlavor dataFlavor : dataFlavorArray) {
            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            class NDPasteType
            extends PasteType {
                NDPasteType() {
                }

                public Transferable paste() throws IOException {
                    if (hashSet.size() != 0) {
                        NodeAction.pasteAction(hashSet, (Node)ResourcesNode.this);
                        hashSet.clear();
                    }
                    return transferable;
                }
            }
            Node node;
            if (!"application".equals(dataFlavor.getPrimaryType())) continue;
            if ("x-java-file-list".equals(dataFlavor.getSubType())) {
                try {
                    node = (Node)transferable.getTransferData(dataFlavor);
                    if (node == null) continue;
                    for (File file : node) {
                        String string = file.getName().toLowerCase();
                        if (file.isDirectory()) {
                            file = FileUtil.normalizeFile((File)file);
                            hashSet.add(new VisualClassPathItem(file, 4, null, file.getPath()));
                            continue;
                        }
                        if (string.endsWith(".zip") || string.endsWith(".jar")) {
                            file = FileUtil.normalizeFile((File)file);
                            hashSet.add(new VisualClassPathItem(file, 0, null, file.getPath()));
                            continue;
                        }
                        hashSet.clear();
                    }
                    return hashSet.size() == 0 ? null : new NDPasteType();
                }
                catch (Exception exception) {
                    Exceptions.printStackTrace((Throwable)exception);
                    return null;
                }
            }
            if ("x-java-openide-multinode".equals(dataFlavor.getSubType())) {
                node = NodeTransfer.nodes((Transferable)transferable, (int)3);
                if (node == null) {
                    return null;
                }
                for (Node node2 : node) {
                    if (node2 != null && node2.getValue("resource") != null) {
                        VisualClassPathItem visualClassPathItem = (VisualClassPathItem)node2.getValue("VCPI");
                        if (visualClassPathItem == null) continue;
                        hashSet.add(visualClassPathItem);
                        continue;
                    }
                    hashSet.clear();
                }
                return hashSet.size() == 0 ? null : new NDPasteType();
            }
            if (!"x-java-openide-nodednd".equals(dataFlavor.getSubType())) continue;
            node = NodeTransfer.node((Transferable)transferable, (int)3);
            if (node != null && node.getValue("resource") != null) {
                VisualClassPathItem visualClassPathItem = (VisualClassPathItem)node.getValue("VCPI");
                if (visualClassPathItem != null) {
                    hashSet.add(visualClassPathItem);
                }
            } else {
                hashSet.clear();
                continue;
            }
            return hashSet.size() == 0 ? null : new NDPasteType();
        }
        return null;
    }

    public PasteType getDropType(Transferable transferable, int n, int n2) {
        Boolean bl = Boolean.TRUE.equals(this.getValue("gray"));
        if (!bl.booleanValue()) {
            DataFlavor[] dataFlavorArray = transferable.getTransferDataFlavors();
            PasteType pasteType = this.getPasteType(transferable, dataFlavorArray);
            return pasteType;
        }
        return null;
    }

    protected void createPasteTypes(Transferable transferable, List<PasteType> list) {
        PasteType pasteType = this.getDropType(transferable, 0, 0);
        if (pasteType != null) {
            list.add(pasteType);
        }
    }

    private class L
    implements PropertyChangeListener,
    AntProjectListener {
        private L() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            ResourcesNode.this.checkBroken();
        }

        public void configurationXmlChanged(AntProjectEvent antProjectEvent) {
            ResourcesNode.this.checkBroken();
        }

        public void propertiesChanged(AntProjectEvent antProjectEvent) {
            ResourcesNode.this.checkBroken();
        }
    }
}

