/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.project;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import javax.swing.text.StyledDocument;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.mobility.antext.preprocessor.CommentingPreProcessor;
import org.netbeans.modules.mobility.project.ProjectConfigurationsHelper;
import org.netbeans.modules.mobility.project.bridge.J2MEProjectUtilitiesProvider;
import org.netbeans.spi.project.ProjectConfiguration;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.openide.ErrorManager;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.text.NbDocument;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;
import org.openide.windows.TopComponent;

public class TextSwitcher
implements PropertyChangeListener {
    public static final String TEXT_SWITCH_SUPPORT = "TEXT_SWITCH_SUPPORT";
    public static final String SKIP_DUCUMENT_CHANGES = "SKIP_DUCUMENT_CHANGES";
    protected final Project p;
    protected final AntProjectHelper h;
    protected ProjectConfigurationsHelper pch;
    protected static RequestProcessor switchProcessor = new RequestProcessor("TEXT_SWITCH_SUPPORT");
    protected static Object lockObserver = new Object();

    public TextSwitcher(Project project, AntProjectHelper antProjectHelper) {
        this.p = project;
        this.h = antProjectHelper;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (this.pch == null) {
            this.pch = (ProjectConfigurationsHelper)this.p.getLookup().lookup(ProjectConfigurationsHelper.class);
        }
        if (this.pch != null && this.pch.isPreprocessorOn() && ("activeConfiguration".equals(string) || "ProjectProperties".equals(string))) {
            new Runner((ProjectConfiguration)propertyChangeEvent.getNewValue()).start();
        }
    }

    private class Runner
    implements Runnable {
        private final ProjectConfiguration selectedConfig;
        private HashSet<DataObject> processed;

        public Runner(ProjectConfiguration projectConfiguration) {
            this.selectedConfig = projectConfiguration;
        }

        public synchronized void start() {
            if (this.selectedConfig == null) {
                return;
            }
            switchProcessor.post((Runnable)this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Object object = lockObserver;
            synchronized (object) {
                DataObject dataObject;
                this.processed = new HashSet();
                Node[] nodeArray = TopComponent.getRegistry().getActivatedNodes();
                for (int i = 0; i < nodeArray.length; ++i) {
                    dataObject = (DataObject)nodeArray[i].getCookie(DataObject.class);
                    if (!this.doSwitch(dataObject, false)) continue;
                    this.processed.add(dataObject);
                }
                if (this.processed == null) {
                    return;
                }
                String string = TextSwitcher.this.h.getStandardPropertyEvaluator().getProperty("src.dir");
                if (string == null) {
                    return;
                }
                dataObject = TextSwitcher.this.h.resolveFileObject(string);
                if (dataObject == null || !dataObject.isFolder()) {
                    return;
                }
                Enumeration enumeration = DataFolder.findFolder((FileObject)dataObject).children(true);
                while (enumeration.hasMoreElements()) {
                    DataObject dataObject2 = (DataObject)enumeration.nextElement();
                    if (this.processed.contains(dataObject2)) continue;
                    this.doSwitch(dataObject2, false);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private synchronized boolean doSwitch(DataObject dataObject, boolean bl) {
            if (dataObject == null) {
                return false;
            }
            FileObject fileObject = dataObject.getPrimaryFile();
            if (!fileObject.getExt().equals("java") || !TextSwitcher.this.p.equals(FileOwnerQuery.getOwner((FileObject)fileObject))) {
                return false;
            }
            EditorCookie editorCookie = (EditorCookie)dataObject.getCookie(EditorCookie.class);
            if (editorCookie == null) {
                return false;
            }
            try {
                StyledDocument styledDocument = bl ? editorCookie.openDocument() : editorCookie.getDocument();
                J2MEProjectUtilitiesProvider j2MEProjectUtilitiesProvider = (J2MEProjectUtilitiesProvider)Lookup.getDefault().lookup(J2MEProjectUtilitiesProvider.class);
                if (j2MEProjectUtilitiesProvider == null) {
                    return false;
                }
                if (!j2MEProjectUtilitiesProvider.isBaseDocument(styledDocument)) {
                    return false;
                }
                CommentingPreProcessor.Source source = j2MEProjectUtilitiesProvider.createPPDocumentSource(styledDocument);
                CommentingPreProcessor.Destination destination = j2MEProjectUtilitiesProvider.createPPDocumentDestination(styledDocument);
                HashMap<String, String> hashMap = new HashMap<String, String>(TextSwitcher.this.pch.getActiveAbilities());
                hashMap.put(TextSwitcher.this.pch.getActiveConfiguration().getDisplayName(), null);
                CommentingPreProcessor commentingPreProcessor = new CommentingPreProcessor(source, destination, hashMap);
                try {
                    styledDocument.putProperty(TextSwitcher.SKIP_DUCUMENT_CHANGES, TextSwitcher.SKIP_DUCUMENT_CHANGES);
                    NbDocument.runAtomic((StyledDocument)styledDocument, (Runnable)commentingPreProcessor);
                }
                finally {
                    styledDocument.putProperty(TextSwitcher.SKIP_DUCUMENT_CHANGES, null);
                }
                return true;
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                ErrorManager.getDefault().notify(1, (Throwable)fileStateInvalidException);
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify(1, (Throwable)iOException);
            }
            return false;
        }
    }
}

