/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.hints;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Position;
import javax.swing.text.StyledDocument;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.editor.hints.AnnotationHolder;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.editor.hints.LazyFixList;
import org.openide.ErrorManager;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.EditorSupport;
import org.openide.text.NbDocument;
import org.openide.text.PositionBounds;
import org.openide.text.PositionRef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class HintsControllerImpl {
    private static List<ChangeListener> listeners = new ArrayList<ChangeListener>();

    private HintsControllerImpl() {
    }

    public static void setErrors(Document document, String string, Collection<? extends ErrorDescription> collection) {
        DataObject dataObject = (DataObject)document.getProperty("stream");
        if (dataObject == null) {
            return;
        }
        try {
            HintsControllerImpl.setErrorsImpl(dataObject.getPrimaryFile(), string, collection);
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify((Throwable)iOException);
        }
    }

    public static void setErrors(FileObject fileObject, String string, Collection<? extends ErrorDescription> collection) {
        try {
            HintsControllerImpl.setErrorsImpl(fileObject, string, collection);
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify((Throwable)iOException);
        }
    }

    private static void setErrorsImpl(FileObject fileObject, String string, Collection<? extends ErrorDescription> collection) throws IOException {
        AnnotationHolder annotationHolder = AnnotationHolder.getInstance(fileObject);
        if (annotationHolder != null) {
            annotationHolder.setErrorDescriptions(string, collection);
        }
    }

    private static void computeLineSpan(Document document, int[] nArray) throws BadLocationException {
        int n;
        String string = document.getText(nArray[0], nArray[1] - nArray[0]);
        int n2 = string.length();
        for (n = 0; n < string.length() && Character.isWhitespace(string.charAt(n)); ++n) {
        }
        while (n2 > 0 && Character.isWhitespace(string.charAt(n2 - 1))) {
            --n2;
        }
        nArray[1] = nArray[0] + n2;
        nArray[0] = nArray[0] + n;
        if (nArray[1] < nArray[0]) {
            nArray[0] = nArray[1];
        }
    }

    static int[] computeLineSpan(Document document, int n) throws BadLocationException {
        Object object;
        int n2;
        int n3 = NbDocument.findLineOffset((StyledDocument)((StyledDocument)document), (int)(n - 1));
        if (document instanceof BaseDocument) {
            n2 = Utilities.getRowEnd((BaseDocument)((BaseDocument)document), (int)n3);
        } else {
            object = document.getText(n3, document.getLength() - n3);
            object = ((String)object).indexOf(10) != -1 ? ((String)object).substring(0, ((String)object).indexOf(10)) : object;
            n2 = n3 + ((String)object).length();
        }
        object = new int[]{n3, n2};
        HintsControllerImpl.computeLineSpan(document, (int[])object);
        return object;
    }

    public static PositionBounds fullLine(Document document, int n) {
        DataObject dataObject = (DataObject)document.getProperty("stream");
        if (dataObject == null) {
            return null;
        }
        try {
            int[] nArray = HintsControllerImpl.computeLineSpan(document, n);
            return HintsControllerImpl.linePart(dataObject.getPrimaryFile(), nArray[0], nArray[1]);
        }
        catch (BadLocationException badLocationException) {
            ErrorManager.getDefault().notify((Throwable)badLocationException);
            return null;
        }
    }

    public static PositionBounds linePart(Document document, final Position position, final Position position2) {
        DataObject dataObject = (DataObject)document.getProperty("stream");
        if (dataObject == null) {
            return null;
        }
        EditorCookie editorCookie = (EditorCookie)dataObject.getCookie(EditorCookie.class);
        if (editorCookie instanceof CloneableEditorSupport) {
            final CloneableEditorSupport cloneableEditorSupport = (CloneableEditorSupport)editorCookie;
            final PositionRef[] positionRefArray = new PositionRef[2];
            document.render(new Runnable(){

                public void run() {
                    HintsControllerImpl.checkOffsetsAndLog(position.getOffset(), position2.getOffset());
                    positionRefArray[0] = cloneableEditorSupport.createPositionRef(position.getOffset(), Position.Bias.Forward);
                    positionRefArray[1] = cloneableEditorSupport.createPositionRef(position2.getOffset(), Position.Bias.Backward);
                }
            });
            return new PositionBounds(positionRefArray[0], positionRefArray[1]);
        }
        if (editorCookie instanceof EditorSupport) {
            final EditorSupport editorSupport = (EditorSupport)editorCookie;
            final PositionRef[] positionRefArray = new PositionRef[2];
            document.render(new Runnable(){

                public void run() {
                    HintsControllerImpl.checkOffsetsAndLog(position.getOffset(), position2.getOffset());
                    positionRefArray[0] = editorSupport.createPositionRef(position.getOffset(), Position.Bias.Forward);
                    positionRefArray[1] = editorSupport.createPositionRef(position2.getOffset(), Position.Bias.Backward);
                }
            });
            return new PositionBounds(positionRefArray[0], positionRefArray[1]);
        }
        return null;
    }

    public static PositionBounds linePart(FileObject fileObject, int n, int n2) {
        try {
            DataObject dataObject = DataObject.find((FileObject)fileObject);
            if (dataObject == null) {
                return null;
            }
            EditorCookie editorCookie = (EditorCookie)dataObject.getCookie(EditorCookie.class);
            if (!(editorCookie instanceof CloneableEditorSupport)) {
                return null;
            }
            CloneableEditorSupport cloneableEditorSupport = (CloneableEditorSupport)editorCookie;
            HintsControllerImpl.checkOffsetsAndLog(n, n2);
            return new PositionBounds(cloneableEditorSupport.createPositionRef(n, Position.Bias.Forward), cloneableEditorSupport.createPositionRef(n2, Position.Bias.Backward));
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify(1, (Throwable)iOException);
            return null;
        }
    }

    private static void checkOffsetsAndLog(int n, int n2) {
        if (n <= n2) {
            return;
        }
        Logger.getLogger(HintsControllerImpl.class.getName()).log(Level.INFO, "Incorrect span, please attach your messages.log to issue #112566. start=" + n + ", end=" + n2, new Exception());
    }

    public static synchronized void addChangeListener(ChangeListener changeListener) {
        listeners.add(changeListener);
    }

    public static synchronized void removeChangeListener(ChangeListener changeListener) {
        listeners.remove(changeListener);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CompoundLazyFixList
    implements LazyFixList,
    PropertyChangeListener {
        final List<LazyFixList> delegates;
        private List<Fix> fixesCache;
        private Boolean computedCache;
        private Boolean probablyContainsFixesCache;
        private PropertyChangeSupport pcs;

        public CompoundLazyFixList(List<LazyFixList> list) {
            this.delegates = list;
            this.pcs = new PropertyChangeSupport(this);
            for (LazyFixList lazyFixList : list) {
                lazyFixList.addPropertyChangeListener(this);
            }
        }

        @Override
        public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.pcs.addPropertyChangeListener(propertyChangeListener);
        }

        @Override
        public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.pcs.removePropertyChangeListener(propertyChangeListener);
        }

        @Override
        public synchronized boolean probablyContainsFixes() {
            if (this.probablyContainsFixesCache == null) {
                boolean bl = false;
                for (LazyFixList lazyFixList : this.delegates) {
                    bl |= lazyFixList.probablyContainsFixes();
                }
                this.probablyContainsFixesCache = bl;
            }
            return this.probablyContainsFixesCache;
        }

        @Override
        public synchronized List<Fix> getFixes() {
            if (this.fixesCache == null) {
                this.fixesCache = new ArrayList<Fix>();
                for (LazyFixList lazyFixList : this.delegates) {
                    this.fixesCache.addAll(lazyFixList.getFixes());
                }
            }
            return this.fixesCache;
        }

        @Override
        public synchronized boolean isComputed() {
            if (this.computedCache == null) {
                boolean bl = true;
                for (LazyFixList lazyFixList : this.delegates) {
                    bl &= lazyFixList.isComputed();
                }
                this.computedCache = bl;
            }
            return this.computedCache;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("fixes".equals(propertyChangeEvent.getPropertyName())) {
                CompoundLazyFixList compoundLazyFixList = this;
                synchronized (compoundLazyFixList) {
                    this.fixesCache = null;
                }
                this.pcs.firePropertyChange("fixes", null, null);
                return;
            }
            if ("computed".equals(propertyChangeEvent.getPropertyName())) {
                CompoundLazyFixList compoundLazyFixList = this;
                synchronized (compoundLazyFixList) {
                    this.computedCache = null;
                }
                this.pcs.firePropertyChange("computed", null, null);
            }
        }
    }
}

