/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.kenai.collab.chat;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Date;
import java.util.prefs.Preferences;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Packet;
import org.netbeans.modules.kenai.api.Kenai;
import org.netbeans.modules.kenai.api.KenaiException;
import org.netbeans.modules.kenai.api.KenaiProject;
import org.netbeans.modules.kenai.collab.chat.ChatPanel;
import org.netbeans.modules.kenai.ui.spi.MessagingHandle;
import org.openide.awt.Notification;
import org.openide.util.Exceptions;
import org.openide.util.NbPreferences;

public class MessagingHandleImpl
extends MessagingHandle {
    private static final String LASTMESSAGEAT = ".last.message.at";
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private Notification notification;
    private int onlineCount;
    private int messageCount = 0;
    private Date lastMessage;
    private Date lastMessageRead;
    private String id;
    private static Preferences prefs = NbPreferences.forModule(MessagingHandleImpl.class);

    MessagingHandleImpl(String string) {
        this.id = string;
        Kenai kenai = Kenai.getDefault();
        try {
            KenaiProject kenaiProject = kenai.getProject(string);
            this.onlineCount = kenaiProject.isMyProject() && kenai.getStatus() == Kenai.Status.ONLINE ? -2 : -1;
        }
        catch (KenaiException kenaiException) {
            Exceptions.printStackTrace((Throwable)kenaiException);
        }
        this.lastMessage = this.lastMessageRead = new Date(Long.parseLong(prefs.get(string + LASTMESSAGEAT, "0")));
    }

    public int getMessageCount() {
        return this.messageCount;
    }

    public void setMessageCount(int n) {
        int n2 = this.messageCount;
        this.messageCount = n;
        this.propertyChangeSupport.firePropertyChange("messageCount", n2, n);
    }

    public int getOnlineCount() {
        return this.onlineCount;
    }

    public void setOnlineCount(int n) {
        int n2 = this.onlineCount;
        this.onlineCount = n;
        this.propertyChangeSupport.firePropertyChange("onlineCount", n2, n);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    public void notifyMessageReceived(Message message) {
        this.lastMessage = ChatPanel.getTimestamp((Packet)message);
        if (this.lastMessage.after(this.lastMessageRead)) {
            this.setMessageCount(this.messageCount + 1);
        }
    }

    public void notifyMessagesRead() {
        this.lastMessageRead = this.lastMessage;
        prefs.put(this.id + LASTMESSAGEAT, Long.toString(this.lastMessageRead.getTime()));
        this.setMessageCount(0);
    }

    public void updateNotification(Notification notification) {
        this.disposeNotification();
        this.notification = notification;
    }

    void disposeNotification() {
        if (this.notification != null) {
            this.notification.clear();
        }
    }
}

