/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.dd.impl.client;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.j2ee.dd.api.client.AppClient;
import org.netbeans.modules.j2ee.dd.api.common.CommonDDBean;
import org.netbeans.modules.j2ee.dd.api.common.EjbRef;
import org.netbeans.modules.j2ee.dd.api.common.EnvEntry;
import org.netbeans.modules.j2ee.dd.api.common.Icon;
import org.netbeans.modules.j2ee.dd.api.common.MessageDestination;
import org.netbeans.modules.j2ee.dd.api.common.MessageDestinationRef;
import org.netbeans.modules.j2ee.dd.api.common.NameAlreadyUsedException;
import org.netbeans.modules.j2ee.dd.api.common.ResourceEnvRef;
import org.netbeans.modules.j2ee.dd.api.common.ResourceRef;
import org.netbeans.modules.j2ee.dd.api.common.RootInterface;
import org.netbeans.modules.j2ee.dd.api.common.ServiceRef;
import org.netbeans.modules.j2ee.dd.api.common.VersionNotSupportedException;
import org.openide.filesystems.FileAlreadyLockedException;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.xml.sax.SAXParseException;

public class AppClientProxy
implements AppClient {
    private AppClient app;
    private String version;
    private List listeners;
    public boolean writing = false;
    private OutputProvider outputProvider;
    private SAXParseException error;
    private int ddStatus;
    private static final Logger LOGGER = Logger.getLogger(AppClientProxy.class.getName());

    public AppClientProxy(AppClient appClient, String string) {
        this.app = appClient;
        this.version = string;
        this.listeners = new ArrayList();
    }

    public void setOriginal(AppClient appClient) {
        if (this.app != appClient) {
            for (PropertyChangeListener propertyChangeListener : this.listeners) {
                if (this.app != null) {
                    this.app.removePropertyChangeListener(propertyChangeListener);
                }
                if (appClient == null) continue;
                appClient.addPropertyChangeListener(propertyChangeListener);
            }
            this.app = appClient;
            if (appClient != null) {
                String string = appClient.getVersion() != null ? appClient.getVersion().toString() : "";
                this.setProxyVersion(string);
            }
        }
    }

    public AppClient getOriginal() {
        return this.app;
    }

    public void setProxyVersion(String string) {
        if (this.version == null && string != null || this.version != null && !this.version.equals(string)) {
            PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this, "dd_version", this.version, string);
            this.version = string;
            Iterator iterator = this.listeners.iterator();
            while (iterator.hasNext()) {
                ((PropertyChangeListener)iterator.next()).propertyChange(propertyChangeEvent);
            }
        }
    }

    public CommonDDBean addBean(String string) throws ClassNotFoundException {
        return this.app == null ? null : this.app.addBean(string);
    }

    public CommonDDBean addBean(String string, String[] stringArray, Object[] objectArray, String string2) throws ClassNotFoundException, NameAlreadyUsedException {
        return this.app == null ? null : this.app.addBean(string, stringArray, objectArray, string2);
    }

    public int addIcon(Icon icon) throws VersionNotSupportedException {
        return this.app == null ? -1 : this.app.addIcon(icon);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.app != null) {
            this.app.addPropertyChangeListener(propertyChangeListener);
        }
        this.listeners.add(propertyChangeListener);
    }

    public CommonDDBean createBean(String string) throws ClassNotFoundException {
        return this.app == null ? null : this.app.createBean(string);
    }

    public CommonDDBean findBeanByName(String string, String string2, String string3) {
        return this.app == null ? null : this.app.findBeanByName(string, string2, string3);
    }

    public Map getAllDescriptions() {
        return this.app == null ? new HashMap() : this.app.getAllDescriptions();
    }

    public Map getAllDisplayNames() {
        return this.app == null ? new HashMap() : this.app.getAllDisplayNames();
    }

    public Map getAllIcons() {
        return this.app == null ? new HashMap() : this.app.getAllIcons();
    }

    public String getDefaultDescription() {
        return this.app == null ? null : this.app.getDefaultDescription();
    }

    public String getDefaultDisplayName() {
        return this.app == null ? null : this.app.getDefaultDisplayName();
    }

    public Icon getDefaultIcon() {
        return this.app == null ? null : this.app.getDefaultIcon();
    }

    public String getDescription(String string) throws VersionNotSupportedException {
        return this.app == null ? null : this.app.getDescription(string);
    }

    public String getDisplayName(String string) throws VersionNotSupportedException {
        return this.app == null ? null : this.app.getDisplayName(string);
    }

    public SAXParseException getError() {
        return this.error;
    }

    public void setError(SAXParseException sAXParseException) {
        this.error = sAXParseException;
    }

    public Icon getIcon(int n) throws VersionNotSupportedException {
        return this.app == null ? null : this.app.getIcon(n);
    }

    public String getId() {
        return this.app == null ? null : this.app.getId();
    }

    public String getLargeIcon() {
        return this.app == null ? null : this.app.getLargeIcon();
    }

    public String getLargeIcon(String string) throws VersionNotSupportedException {
        return this.app == null ? null : this.app.getLargeIcon(string);
    }

    public String getSmallIcon() {
        return this.app == null ? null : this.app.getSmallIcon();
    }

    public String getSmallIcon(String string) throws VersionNotSupportedException {
        return this.app == null ? null : this.app.getSmallIcon(string);
    }

    public int getStatus() {
        return this.ddStatus;
    }

    public void setStatus(int n) {
        if (this.ddStatus != n) {
            PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this, "dd_status", new Integer(this.ddStatus), new Integer(n));
            this.ddStatus = n;
            Iterator iterator = this.listeners.iterator();
            while (iterator.hasNext()) {
                ((PropertyChangeListener)iterator.next()).propertyChange(propertyChangeEvent);
            }
        }
    }

    public Object getValue(String string) {
        return this.app == null ? null : this.app.getValue(string);
    }

    public BigDecimal getVersion() {
        if (this.version == null) {
            return null;
        }
        try {
            return new BigDecimal(this.version);
        }
        catch (NumberFormatException numberFormatException) {
            LOGGER.log(Level.INFO, "Not a valid version: " + this.version, numberFormatException);
            return null;
        }
    }

    public void merge(RootInterface rootInterface, int n) {
        if (this.app != null) {
            if (rootInterface instanceof AppClientProxy) {
                this.app.merge(((AppClientProxy)rootInterface).getOriginal(), n);
            } else {
                this.app.merge(rootInterface, n);
            }
        }
    }

    public Icon newIcon() {
        try {
            return this.app == null ? null : this.app.newIcon();
        }
        catch (VersionNotSupportedException versionNotSupportedException) {
            return null;
        }
    }

    public void removeAllDescriptions() {
        if (this.app != null) {
            this.app.removeAllDescriptions();
        }
    }

    public void removeAllDisplayNames() {
        if (this.app != null) {
            this.app.removeAllDisplayNames();
        }
    }

    public void removeAllIcons() {
        if (this.app != null) {
            this.app.removeAllIcons();
        }
    }

    public void removeDescription() {
        if (this.app != null) {
            this.app.removeDescription();
        }
    }

    public void removeDescriptionForLocale(String string) throws VersionNotSupportedException {
        if (this.app != null) {
            this.app.removeDescriptionForLocale(string);
        }
    }

    public void removeDisplayName() {
        if (this.app != null) {
            this.app.removeDisplayName();
        }
    }

    public void removeDisplayNameForLocale(String string) throws VersionNotSupportedException {
        if (this.app != null) {
            this.app.removeDisplayNameForLocale(string);
        }
    }

    public void removeIcon() {
        if (this.app != null) {
            this.app.removeIcon();
        }
    }

    public int removeIcon(Icon icon) throws VersionNotSupportedException {
        return this.app == null ? -1 : this.app.removeIcon(icon);
    }

    public void removeIcon(String string) throws VersionNotSupportedException {
        if (this.app != null) {
            this.app.removeIcon(string);
        }
    }

    public void removeLargeIcon() {
        if (this.app != null) {
            this.app.removeLargeIcon();
        }
    }

    public void removeLargeIcon(String string) throws VersionNotSupportedException {
        if (this.app != null) {
            this.app.removeLargeIcon(string);
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.app != null) {
            this.app.removePropertyChangeListener(propertyChangeListener);
        }
        this.listeners.remove(propertyChangeListener);
    }

    public void removeSmallIcon() {
        if (this.app != null) {
            this.app.removeSmallIcon();
        }
    }

    public void removeSmallIcon(String string) throws VersionNotSupportedException {
        if (this.app != null) {
            this.app.removeSmallIcon(string);
        }
    }

    public void setAllDescriptions(Map map) throws VersionNotSupportedException {
        if (this.app != null) {
            this.app.setAllDescriptions(map);
        }
    }

    public void setAllDisplayNames(Map map) throws VersionNotSupportedException {
        if (this.app != null) {
            this.app.setAllDisplayNames(map);
        }
    }

    public void setAllIcons(String[] stringArray, String[] stringArray2, String[] stringArray3) throws VersionNotSupportedException {
        if (this.app != null) {
            this.app.setAllIcons(stringArray, stringArray2, stringArray3);
        }
    }

    public void setDescription(String string) {
        if (this.app != null) {
            this.app.setDescription(string);
        }
    }

    public void setDescription(String string, String string2) throws VersionNotSupportedException {
        if (this.app != null) {
            this.app.setDescription(string, string2);
        }
    }

    public void setDisplayName(String string) {
        if (this.app != null) {
            this.app.setDisplayName(string);
        }
    }

    public void setDisplayName(String string, String string2) throws VersionNotSupportedException {
        if (this.app != null) {
            this.app.setDisplayName(string, string2);
        }
    }

    public void setIcon(Icon[] iconArray) throws VersionNotSupportedException {
        if (this.app != null) {
            this.app.setIcon(iconArray);
        }
    }

    public void setIcon(Icon icon) {
        if (this.app != null) {
            this.app.setIcon(icon);
        }
    }

    public void setIcon(int n, Icon icon) throws VersionNotSupportedException {
        if (this.app != null) {
            this.app.setIcon(n, icon);
        }
    }

    public void setId(String string) {
        if (this.app != null) {
            this.app.setId(string);
        }
    }

    public void setLargeIcon(String string) {
        if (this.app != null) {
            this.app.setLargeIcon(string);
        }
    }

    public void setLargeIcon(String string, String string2) throws VersionNotSupportedException {
        if (this.app != null) {
            this.app.setLargeIcon(string, string2);
        }
    }

    public void setSmallIcon(String string) {
        if (this.app != null) {
            this.app.setSmallIcon(string);
        }
    }

    public void setSmallIcon(String string, String string2) throws VersionNotSupportedException {
        if (this.app != null) {
            this.app.setSmallIcon(string, string2);
        }
    }

    public int sizeIcon() throws VersionNotSupportedException {
        return this.app == null ? 0 : this.app.sizeIcon();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(FileObject fileObject) throws IOException {
        if (this.app != null) {
            try {
                FileLock fileLock = fileObject.lock();
                try {
                    OutputStream outputStream = fileObject.getOutputStream(fileLock);
                    try {
                        this.writing = true;
                        this.write(outputStream);
                    }
                    finally {
                        outputStream.close();
                    }
                }
                finally {
                    fileLock.releaseLock();
                }
            }
            catch (FileAlreadyLockedException fileAlreadyLockedException) {
                DataObject dataObject = DataObject.find((FileObject)fileObject);
                if (dataObject != null && dataObject instanceof OutputProvider) {
                    ((OutputProvider)dataObject).write(this);
                }
                throw fileAlreadyLockedException;
            }
        }
    }

    public void write(OutputStream outputStream) throws IOException {
        if (this.app != null) {
            this.writing = true;
            this.app.write(outputStream);
        }
    }

    public Object clone() {
        AppClientProxy appClientProxy = null;
        if (this.app == null) {
            appClientProxy = new AppClientProxy(null, this.version);
        } else {
            AppClientProxy appClientProxy2 = (AppClientProxy)this.app.clone();
            appClientProxy = new AppClientProxy(appClientProxy2, this.version);
        }
        appClientProxy.setError(this.error);
        appClientProxy.setStatus(this.ddStatus);
        return appClientProxy;
    }

    public boolean isWriting() {
        return this.writing;
    }

    public void setWriting(boolean bl) {
        this.writing = bl;
    }

    public void setOutputProvider(OutputProvider outputProvider) {
        this.outputProvider = outputProvider;
    }

    public int addEjbRef(EjbRef ejbRef) {
        return this.app == null ? -1 : this.app.addEjbRef(ejbRef);
    }

    public int addEnvEntry(EnvEntry envEntry) {
        return this.app == null ? -1 : this.app.addEnvEntry(envEntry);
    }

    public int addMessageDestination(MessageDestination messageDestination) throws VersionNotSupportedException {
        return this.app == null ? -1 : this.app.addMessageDestination(messageDestination);
    }

    public int addMessageDestinationRef(MessageDestinationRef messageDestinationRef) throws VersionNotSupportedException {
        return this.app == null ? -1 : this.app.addMessageDestinationRef(messageDestinationRef);
    }

    public int addResourceEnvRef(ResourceEnvRef resourceEnvRef) {
        return this.app == null ? -1 : this.app.addResourceEnvRef(resourceEnvRef);
    }

    public int addResourceRef(ResourceRef resourceRef) {
        return this.app == null ? -1 : this.app.addResourceRef(resourceRef);
    }

    public int addServiceRef(ServiceRef serviceRef) throws VersionNotSupportedException {
        return this.app == null ? -1 : this.app.addServiceRef(serviceRef);
    }

    public String getCallbackHandler() {
        return this.app != null ? this.app.getCallbackHandler() : null;
    }

    public EjbRef[] getEjbRef() {
        return this.app != null ? this.app.getEjbRef() : null;
    }

    public EjbRef getEjbRef(int n) {
        return this.app != null ? this.app.getEjbRef(n) : null;
    }

    public EnvEntry[] getEnvEntry() {
        return this.app == null ? new EnvEntry[]{} : this.app.getEnvEntry();
    }

    public EnvEntry getEnvEntry(int n) {
        return this.app == null ? null : this.app.getEnvEntry(n);
    }

    public MessageDestination[] getMessageDestination() throws VersionNotSupportedException {
        return this.app == null ? new MessageDestination[]{} : this.app.getMessageDestination();
    }

    public MessageDestination getMessageDestination(int n) throws VersionNotSupportedException {
        return this.app == null ? null : this.app.getMessageDestination(n);
    }

    public MessageDestinationRef[] getMessageDestinationRef() throws VersionNotSupportedException {
        return this.app == null ? new MessageDestinationRef[]{} : this.app.getMessageDestinationRef();
    }

    public MessageDestinationRef getMessageDestinationRef(int n) throws VersionNotSupportedException {
        return this.app == null ? null : this.app.getMessageDestinationRef(n);
    }

    public ResourceEnvRef[] getResourceEnvRef() {
        return this.app == null ? null : (this.app == null ? new ResourceEnvRef[]{} : this.app.getResourceEnvRef());
    }

    public ResourceEnvRef getResourceEnvRef(int n) {
        return this.app == null ? null : this.app.getResourceEnvRef(n);
    }

    public ResourceRef[] getResourceRef() {
        return this.app == null ? new ResourceRef[]{} : this.app.getResourceRef();
    }

    public ResourceRef getResourceRef(int n) {
        return this.app == null ? null : this.app.getResourceRef(n);
    }

    public ServiceRef[] getServiceRef() throws VersionNotSupportedException {
        return this.app == null ? new ServiceRef[]{} : this.app.getServiceRef();
    }

    public ServiceRef getServiceRef(int n) throws VersionNotSupportedException {
        return this.app == null ? null : this.app.getServiceRef(n);
    }

    public EjbRef newEjbRef() {
        return this.app != null ? this.app.newEjbRef() : null;
    }

    public EnvEntry newEnvEntry() {
        return this.app != null ? this.app.newEnvEntry() : null;
    }

    public MessageDestination newMessageDestination() throws VersionNotSupportedException {
        return this.app != null ? this.app.newMessageDestination() : null;
    }

    public MessageDestinationRef newMessageDestinationRef() throws VersionNotSupportedException {
        return this.app != null ? this.app.newMessageDestinationRef() : null;
    }

    public ResourceEnvRef newResourceEnvRef() {
        return this.app != null ? this.app.newResourceEnvRef() : null;
    }

    public ResourceRef newResourceRef() {
        return this.app != null ? this.app.newResourceRef() : null;
    }

    public ServiceRef newServiceRef() throws VersionNotSupportedException {
        return this.app != null ? this.app.newServiceRef() : null;
    }

    public int removeEjbRef(EjbRef ejbRef) {
        return this.app == null ? -1 : this.app.removeEjbRef(ejbRef);
    }

    public int removeEnvEntry(EnvEntry envEntry) {
        return this.app == null ? -1 : this.app.removeEnvEntry(envEntry);
    }

    public int removeMessageDestination(MessageDestination messageDestination) throws VersionNotSupportedException {
        return this.app == null ? -1 : this.app.removeMessageDestination(messageDestination);
    }

    public int removeMessageDestinationRef(MessageDestinationRef messageDestinationRef) throws VersionNotSupportedException {
        return this.app == null ? -1 : this.app.removeMessageDestinationRef(messageDestinationRef);
    }

    public int removeResourceEnvRef(ResourceEnvRef resourceEnvRef) {
        return this.app == null ? -1 : this.app.removeResourceEnvRef(resourceEnvRef);
    }

    public int removeResourceRef(ResourceRef resourceRef) {
        return this.app == null ? -1 : this.app.removeResourceRef(resourceRef);
    }

    public int removeServiceRef(ServiceRef serviceRef) throws VersionNotSupportedException {
        return this.app == null ? -1 : this.app.removeServiceRef(serviceRef);
    }

    public void setVersion(BigDecimal bigDecimal) {
        if (this.app != null) {
            this.app.setVersion(bigDecimal);
        }
    }

    public void setEjbRef(EjbRef[] ejbRefArray) {
        if (this.app != null) {
            this.app.setEjbRef(ejbRefArray);
        }
    }

    public void setResourceRef(int n, ResourceRef resourceRef) {
        if (this.app != null) {
            this.app.setResourceRef(n, resourceRef);
        }
    }

    public void setResourceEnvRef(ResourceEnvRef[] resourceEnvRefArray) {
        if (this.app != null) {
            this.app.setResourceEnvRef(resourceEnvRefArray);
        }
    }

    public void setServiceRef(int n, ServiceRef serviceRef) throws VersionNotSupportedException {
        if (this.app != null) {
            this.app.setServiceRef(n, serviceRef);
        }
    }

    public void setMessageDestination(MessageDestination[] messageDestinationArray) throws VersionNotSupportedException {
        if (this.app != null) {
            this.app.setMessageDestination(messageDestinationArray);
        }
    }

    public void setResourceEnvRef(int n, ResourceEnvRef resourceEnvRef) {
        if (this.app != null) {
            this.app.setResourceEnvRef(n, resourceEnvRef);
        }
    }

    public void setEnvEntry(EnvEntry[] envEntryArray) {
        if (this.app != null) {
            this.app.setEnvEntry(envEntryArray);
        }
    }

    public void setMessageDestination(int n, MessageDestination messageDestination) throws VersionNotSupportedException {
        if (this.app != null) {
            this.app.setMessageDestination(n, messageDestination);
        }
    }

    public void setMessageDestinationRef(MessageDestinationRef[] messageDestinationRefArray) throws VersionNotSupportedException {
        if (this.app != null) {
            this.app.setMessageDestinationRef(messageDestinationRefArray);
        }
    }

    public void setMessageDestinationRef(int n, MessageDestinationRef messageDestinationRef) throws VersionNotSupportedException {
        if (this.app != null) {
            this.app.setMessageDestinationRef(n, messageDestinationRef);
        }
    }

    public void setEnvEntry(int n, EnvEntry envEntry) {
        if (this.app != null) {
            this.app.setEnvEntry(n, envEntry);
        }
    }

    public void setEjbRef(int n, EjbRef ejbRef) {
        if (this.app != null) {
            this.app.setEjbRef(n, ejbRef);
        }
    }

    public void setCallbackHandler(String string) {
        if (this.app != null) {
            this.app.setCallbackHandler(string);
        }
    }

    public void setServiceRef(ServiceRef[] serviceRefArray) throws VersionNotSupportedException {
        if (this.app != null) {
            this.app.setServiceRef(serviceRefArray);
        }
    }

    public void setResourceRef(ResourceRef[] resourceRefArray) {
        if (this.app != null) {
            this.app.setResourceRef(resourceRefArray);
        }
    }

    public int sizeEjbRef() {
        return this.app != null ? this.app.sizeEjbRef() : 0;
    }

    public int sizeEnvEntry() {
        return this.app == null ? 0 : this.app.sizeEnvEntry();
    }

    public int sizeMessageDestination() throws VersionNotSupportedException {
        return this.app == null ? 0 : this.app.sizeMessageDestination();
    }

    public int sizeMessageDestinationRef() throws VersionNotSupportedException {
        return this.app == null ? 0 : this.app.sizeMessageDestinationRef();
    }

    public int sizeResourceEnvRef() {
        return this.app == null ? 0 : this.app.sizeResourceEnvRef();
    }

    public int sizeResourceRef() {
        return this.app == null ? 0 : this.app.sizeResourceRef();
    }

    public int sizeServiceRef() throws VersionNotSupportedException {
        return this.app == null ? 0 : this.app.sizeServiceRef();
    }

    public static interface OutputProvider {
        public void write(AppClient var1) throws IOException;

        public FileObject getTarget();
    }
}

