/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.dd.api.ejb;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.netbeans.modules.j2ee.dd.api.common.CommonDDBean;
import org.netbeans.modules.j2ee.dd.api.ejb.EjbJar;
import org.netbeans.modules.j2ee.dd.impl.common.DDProviderDataObject;
import org.netbeans.modules.j2ee.dd.impl.common.DDUtils;
import org.netbeans.modules.j2ee.dd.impl.ejb.EjbJarProxy;
import org.netbeans.modules.schema2beans.BaseBean;
import org.netbeans.modules.xml.api.EncodingUtil;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Exceptions;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public final class DDProvider {
    private static final String EJB_21_DOCTYPE = "http://java.sun.com/xml/ns/j2ee/ejb-jar_2_1.xsd";
    private static final DDProvider ddProvider = new DDProvider();
    private final Map ddMap = new HashMap(5);

    private DDProvider() {
    }

    public static DDProvider getDefault() {
        return ddProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized EjbJar getDDRoot(FileObject fileObject) throws IOException {
        Object object;
        if (fileObject == null) {
            return null;
        }
        try {
            object = DataObject.find((FileObject)fileObject);
            if (object instanceof DDProviderDataObject) {
                return this.getDDRoot0((DDProviderDataObject)object);
            }
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            return null;
        }
        object = null;
        Map map = this.ddMap;
        synchronized (map) {
            object = this.getFromCache(fileObject);
            if (object != null) {
                return object;
            }
        }
        fileObject.addFileChangeListener((FileChangeListener)new DDFileChangeListener());
        object = DDUtils.createEjbJarProxy(fileObject.getInputStream());
        map = this.ddMap;
        synchronized (map) {
            EjbJarProxy ejbJarProxy = this.getFromCache(fileObject);
            if (ejbJarProxy != null) {
                return ejbJarProxy;
            }
            this.putToCache(fileObject, (EjbJarProxy)object);
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized EjbJar getDDRoot0(DDProviderDataObject dDProviderDataObject) throws IOException {
        EjbJarProxy ejbJarProxy = null;
        Map map = this.ddMap;
        synchronized (map) {
            ejbJarProxy = this.getFromCache(dDProviderDataObject);
            if (ejbJarProxy == null) {
                ejbJarProxy = DDUtils.createEjbJarProxy(dDProviderDataObject.createReader());
                this.putToCache(dDProviderDataObject, ejbJarProxy);
            }
        }
        return ejbJarProxy;
    }

    public EjbJar getDDRootCopy(FileObject fileObject) throws IOException {
        return (EjbJar)this.getDDRoot(fileObject).clone();
    }

    private EjbJarProxy getFromCache(Object object) {
        return (EjbJarProxy)this.ddMap.get(object);
    }

    private void putToCache(Object object, EjbJarProxy ejbJarProxy) {
        this.ddMap.put(object, ejbJarProxy);
    }

    public EjbJar getDDRoot(InputSource inputSource) throws IOException, SAXException {
        ErrorHandler errorHandler = new ErrorHandler();
        DocumentBuilder documentBuilder = DDProvider.createParser(errorHandler);
        documentBuilder.setEntityResolver(DDResolver.getInstance());
        Document document = documentBuilder.parse(inputSource);
        SAXParseException sAXParseException = errorHandler.getError();
        String string = DDProvider.extractVersion(document);
        EjbJar ejbJar = DDProvider.createEjbJar(string, document);
        EjbJarProxy ejbJarProxy = new EjbJarProxy(ejbJar, string);
        ejbJarProxy.setError(sAXParseException);
        if (sAXParseException != null) {
            ejbJarProxy.setStatus(1);
        } else {
            ejbJarProxy.setStatus(0);
        }
        return ejbJarProxy;
    }

    public BaseBean getBaseBean(CommonDDBean commonDDBean) {
        if (commonDDBean instanceof BaseBean) {
            return (BaseBean)commonDDBean;
        }
        if (commonDDBean instanceof EjbJarProxy) {
            return (BaseBean)((EjbJarProxy)commonDDBean).getOriginal();
        }
        return null;
    }

    private static EjbJar createEjbJar(String string, Document document) {
        if ("3.0".equals(string)) {
            return new org.netbeans.modules.j2ee.dd.impl.ejb.model_3_0.EjbJar(document, 1);
        }
        if ("2.1".equals(string)) {
            return new org.netbeans.modules.j2ee.dd.impl.ejb.model_2_1.EjbJar(document, 1);
        }
        return null;
    }

    private static String extractVersion(Document document) {
        String string = null;
        DocumentType documentType = document.getDoctype();
        if (documentType != null) {
            string = documentType.getPublicId();
        } else {
            String string2 = document.getDocumentElement().getAttribute("xsi:schemaLocation");
            if (string2 != null) {
                string = string2.substring(string2.lastIndexOf(" ") + 1);
            }
        }
        if (string != null && EJB_21_DOCTYPE.equals(string)) {
            return "2.1";
        }
        return "3.0";
    }

    private static DocumentBuilder createParser(ErrorHandler errorHandler) throws SAXException {
        DocumentBuilder documentBuilder = null;
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilder = documentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new SAXException(parserConfigurationException.getMessage());
        }
        documentBuilder.setErrorHandler(errorHandler);
        return documentBuilder;
    }

    private class DDFileChangeListener
    extends FileChangeAdapter {
        private DDFileChangeListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void fileChanged(FileEvent fileEvent) {
            FileObject fileObject = fileEvent.getFile();
            try {
                Map map = DDProvider.this.ddMap;
                synchronized (map) {
                    EjbJarProxy ejbJarProxy = DDProvider.this.getFromCache(fileObject);
                    if (ejbJarProxy != null) {
                        InputStream inputStream = fileObject.getInputStream();
                        try {
                            String string = EncodingUtil.detectEncoding((InputStream)new BufferedInputStream(inputStream));
                            if (string == null) {
                                string = "UTF8";
                            }
                            DDUtils.merge(ejbJarProxy, new InputStreamReader(inputStream, string));
                        }
                        finally {
                            inputStream.close();
                        }
                    }
                }
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
    }

    private static class ErrorHandler
    implements org.xml.sax.ErrorHandler {
        private int errorType = -1;
        SAXParseException error;

        private ErrorHandler() {
        }

        public void warning(SAXParseException sAXParseException) throws SAXException {
            if (this.errorType < 0) {
                this.errorType = 0;
                this.error = sAXParseException;
            }
        }

        public void error(SAXParseException sAXParseException) throws SAXException {
            if (this.errorType < 1) {
                this.errorType = 1;
                this.error = sAXParseException;
            }
        }

        public void fatalError(SAXParseException sAXParseException) throws SAXException {
            this.errorType = 2;
            throw sAXParseException;
        }

        public int getErrorType() {
            return this.errorType;
        }

        public SAXParseException getError() {
            return this.error;
        }
    }

    private static class DDResolver
    implements EntityResolver {
        static DDResolver resolver;

        private DDResolver() {
        }

        static synchronized DDResolver getInstance() {
            if (resolver == null) {
                resolver = new DDResolver();
            }
            return resolver;
        }

        public InputSource resolveEntity(String string, String string2) {
            String string3;
            if (DDProvider.EJB_21_DOCTYPE.equals(string2)) {
                string3 = "/org/netbeans/modules/j2ee/dd/impl/resources/ejb-jar_2_1.xsd";
            } else if ("http://java.sun.com/xml/ns/javaee/ejb-jar_3_0.xsd".equals(string2)) {
                string3 = "/org/netbeans/modules/j2ee/dd/impl/resources/ejb-jar_3_0.xsd";
            } else {
                return null;
            }
            URL uRL = this.getClass().getResource(string3);
            return new InputSource(uRL.toString());
        }
    }
}

