/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.gdb.proxy;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.cnd.api.utils.Path;
import org.netbeans.modules.cnd.debugger.gdb.GdbDebugger;
import org.netbeans.modules.cnd.debugger.gdb.proxy.CommandBuffer;
import org.netbeans.modules.cnd.debugger.gdb.proxy.ExternalTerminal;
import org.netbeans.modules.cnd.debugger.gdb.proxy.GdbLogger;
import org.netbeans.modules.cnd.debugger.gdb.proxy.GdbProxy;
import org.netbeans.modules.cnd.debugger.gdb.proxy.MICommand;
import org.netbeans.modules.cnd.debugger.gdb.utils.GdbUtils;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.NativeProcess;
import org.netbeans.modules.nativeexecution.api.NativeProcessBuilder;
import org.netbeans.modules.nativeexecution.api.util.CommonTasksSupport;
import org.netbeans.modules.nativeexecution.api.util.MacroMap;
import org.netbeans.modules.nativeexecution.api.util.Signal;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GdbProxyEngine {
    private static final int MIN_TOKEN = 100;
    private PrintStream toGdb;
    private final GdbDebugger debugger;
    private final GdbProxy gdbProxy;
    private int debuggerPid = -1;
    private final MICommand[] commandList = new MICommand[20];
    private int nextCommandPos = 0;
    private int nextToken = 100;
    private int currentToken = 100;
    private boolean active;
    private RequestProcessor.Task gdbReader = null;
    private final RequestProcessor sendQueue = new RequestProcessor("sendQueue");
    private final boolean timerOn = Boolean.getBoolean("gdb.proxy.timer");
    private static final Logger log = Logger.getLogger("gdb.gdbproxy.logger");
    private static final String TIME_PREFIX = ",time=";

    public GdbProxyEngine(GdbDebugger gdbDebugger, GdbProxy gdbProxy, List<String> list, String[] stringArray, String string, String string2, String string3) throws IOException {
        if (gdbDebugger.getPlatform() != 3 && string2 != null) {
            String string4 = ExternalTerminal.create(gdbDebugger, string2, stringArray);
            if (string4 != null) {
                list.add("-tty");
                list.add(string4);
            } else {
                throw new IllegalStateException(NbBundle.getMessage(GdbProxyEngine.class, (String)"ERR_ExternalTerminalFailedMessage"));
            }
        }
        this.debugger = gdbDebugger;
        this.gdbProxy = gdbProxy;
        this.active = true;
        this.getLogger().logMessage("Debugger Command: " + list);
        this.getLogger().logMessage("Env[" + stringArray.length + "]: " + Arrays.asList(stringArray));
        this.getLogger().logMessage("workingDirectory: " + string);
        this.getLogger().logMessage("NB version: " + System.getProperty("netbeans.buildnumber"));
        this.getLogger().logMessage("================================================");
        this.startDebugger(list, string, stringArray, string3);
    }

    private void startDebugger(List<String> list, String string, String[] stringArray, String string2) throws IOException {
        String string3;
        ExecutionEnvironment executionEnvironment = this.debugger.getHostExecutionEnvironment();
        String[] stringArray2 = list.subList(1, list.size()).toArray(new String[list.size() - 1]);
        NativeProcessBuilder nativeProcessBuilder = NativeProcessBuilder.newProcessBuilder((ExecutionEnvironment)executionEnvironment);
        nativeProcessBuilder.setExecutable(list.get(0)).setArguments(stringArray2);
        nativeProcessBuilder.setWorkingDirectory(string);
        MacroMap macroMap = nativeProcessBuilder.getEnvironment();
        if (stringArray != null) {
            macroMap.putAll(stringArray);
        }
        if (executionEnvironment.isLocal()) {
            string3 = Path.getPathName();
            macroMap.appendPathVariable(string3, string2);
        }
        string3 = nativeProcessBuilder.call();
        this.debuggerPid = string3.getPID();
        this.toGdb = this.toGdbWriter(string3.getInputStream(), string3.getOutputStream());
        new RequestProcessor("GdbReaperThread").post(new Runnable((NativeProcess)string3){
            final /* synthetic */ NativeProcess val$proc;
            {
                this.val$proc = nativeProcess;
            }

            public void run() {
                try {
                    int n = this.val$proc.waitFor();
                    if (n == 0) {
                        GdbProxyEngine.this.debugger.finish(false);
                    } else {
                        GdbProxyEngine.this.unexpectedGdbExit(n);
                    }
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
            }
        });
    }

    public void interrupt() {
        CommonTasksSupport.sendSignal((ExecutionEnvironment)this.debugger.getHostExecutionEnvironment(), (int)this.debuggerPid, (Signal)Signal.SIGINT, null);
    }

    private void unexpectedGdbExit(int n) {
        String string = n < 0 ? NbBundle.getMessage(GdbDebugger.class, (String)"ERR_UnexpectedGdbExit") : NbBundle.getMessage(GdbDebugger.class, (String)"ERR_UnexpectedGdbExitRC", (Object)n);
        NotifyDescriptor notifyDescriptor = new NotifyDescriptor((Object)string, NbBundle.getMessage(GdbDebugger.class, (String)"TITLE_UnexpectedGdbFailure"), -1, 0, new Object[]{NotifyDescriptor.OK_OPTION}, NotifyDescriptor.OK_OPTION);
        DialogDisplayer.getDefault().notify(notifyDescriptor);
        this.debugger.finish(false);
    }

    private static BufferedReader getReader(InputStream inputStream, String string) {
        try {
            return new BufferedReader(new InputStreamReader(inputStream, string));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return new BufferedReader(new InputStreamReader(inputStream));
        }
    }

    private static PrintStream getPrintStream(OutputStream outputStream, String string) {
        try {
            return new PrintStream(outputStream, true, string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return new PrintStream(outputStream, true);
        }
    }

    private PrintStream toGdbWriter(InputStream inputStream, OutputStream outputStream) {
        PrintStream printStream = GdbProxyEngine.getPrintStream(outputStream, this.debugger.getCharSetEncoding());
        final BufferedReader bufferedReader = GdbProxyEngine.getReader(inputStream, this.debugger.getCharSetEncoding());
        this.gdbReader = new RequestProcessor("GdbReaderRP").post(new Runnable(){

            public void run() {
                try {
                    String string;
                    while ((string = bufferedReader.readLine()) != null) {
                        if ((string = string.trim()).length() <= 0) continue;
                        try {
                            GdbProxyEngine.this.processMessage(string);
                        }
                        catch (Exception exception) {
                            log.log(Level.SEVERE, "Exception in processMessage", exception);
                        }
                    }
                }
                catch (IOException iOException) {
                    log.log(Level.WARNING, "IOException in gdbReader", iOException);
                }
            }
        });
        return printStream;
    }

    public void finish() {
        if (this.gdbReader != null) {
            this.gdbReader.cancel();
        }
    }

    private synchronized int nextToken() {
        return this.nextToken++;
    }

    int sendCommand(String string) {
        MICommand mICommand = this.createMICommand(string);
        this.sendCommand(mICommand);
        return mICommand.getToken();
    }

    private void sendCommand(int n, String string) {
        this.sendCommand(new MICommandImpl(n, string));
    }

    private void sendCommand(final MICommand mICommand) {
        if (this.active) {
            this.sendQueue.post(new Runnable(){

                public void run() {
                    if (mICommand.getText().charAt(0) != '-') {
                        GdbProxyEngine.this.addCommand(mICommand);
                    }
                    String string = Integer.toString(mICommand.getToken()) + mICommand.getText();
                    GdbProxyEngine.this.gdbProxy.getLogger().logMessage(CommandBuffer.addTimePrefix(GdbProxyEngine.this.timerOn, string));
                    GdbProxyEngine.this.toGdb.println(string);
                }
            });
        }
    }

    CommandBuffer sendCommandEx(String string) {
        return this.sendCommandEx(string, true);
    }

    CommandBuffer sendCommandEx(String string, boolean bl) {
        int n = this.nextToken();
        CommandBuffer commandBuffer = new CommandBuffer(this.gdbProxy, n);
        this.gdbProxy.putCB(n, commandBuffer);
        this.sendCommand(n, string);
        if (bl) {
            commandBuffer.waitForCompletion();
        }
        return commandBuffer;
    }

    void sendConsoleCommand(String string) {
        int n = this.nextToken() + 10000;
        this.sendCommand(n, string);
    }

    void stopSending() {
        this.active = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addCommand(MICommand mICommand) {
        MICommand[] mICommandArray = this.commandList;
        synchronized (this.commandList) {
            this.commandList[this.nextCommandPos] = mICommand;
            if (++this.nextCommandPos >= this.commandList.length) {
                this.nextCommandPos = 0;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    private void processMessage(String string) {
        if (string.equals("(gdb)")) {
            return;
        }
        int n = GdbProxyEngine.getToken(string);
        if (n < 0) {
            n = this.getCurrentToken(string);
            if (n != -1) {
                this.gdbProxy.getLogger().logMessage(CommandBuffer.addTimePrefix(this.timerOn, n) + string);
            } else {
                this.gdbProxy.getLogger().logMessage(CommandBuffer.addTimePrefix(this.timerOn, string));
            }
        } else {
            this.gdbProxy.getLogger().logMessage(CommandBuffer.addTimePrefix(this.timerOn, string));
        }
        string = GdbProxyEngine.stripToken(string);
        string = this.stripTiming(string);
        if (string.length() == 0) {
            log.warning("Empty message received from gdb");
            return;
        }
        switch (string.charAt(0)) {
            case '^': {
                if (n == this.currentToken && string.equals("^done")) {
                    this.currentToken = -1;
                }
                this.debugger.resultRecord(n, string);
                break;
            }
            case '*': {
                this.debugger.execAsyncOutput(n, string);
                break;
            }
            case '+': {
                this.debugger.statusAsyncOutput(n, string);
                break;
            }
            case '=': {
                this.debugger.notifyAsyncOutput(n, string);
                break;
            }
            case '~': {
                this.debugger.consoleStreamOutput(n, string.substring(2, string.length() - 1));
                break;
            }
            case '@': {
                this.debugger.targetStreamOutput(string);
                break;
            }
            case '&': {
                this.debugger.logStreamOutput(string);
                break;
            }
            default: {
                this.debugger.output(string);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int getCurrentToken(String string) {
        if (string.charAt(0) != '&') return this.currentToken;
        string = string.substring(2, string.length() - 1).replace("\\n", "");
        MICommand[] mICommandArray = this.commandList;
        synchronized (this.commandList) {
            int n = this.nextCommandPos - 1;
            while (true) {
                if (n < 0) {
                    n = this.commandList.length - 1;
                }
                if (n == this.nextCommandPos) return this.currentToken;
                MICommand mICommand = this.commandList[n];
                if (mICommand != null && mICommand.getText().equals(string)) {
                    this.commandList[n] = null;
                    this.currentToken = mICommand.getToken();
                    break;
                }
                --n;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return this.currentToken;
        }
    }

    private static int getFirstNonDigit(String string) {
        for (int i = 0; i < string.length(); ++i) {
            if (Character.isDigit(string.charAt(i))) continue;
            return i;
        }
        return 0;
    }

    private static int getToken(String string) {
        int n = GdbProxyEngine.getFirstNonDigit(string);
        if (n > 0) {
            return Integer.parseInt(string.substring(0, n));
        }
        return -1;
    }

    private static String stripToken(String string) {
        char c;
        int n = GdbProxyEngine.getFirstNonDigit(string);
        char c2 = c = n < string.length() ? string.charAt(n) : (char)'\u0000';
        if ((c == '^' || c == '*' || c == '+' || c == '=') && c != '\u0000') {
            return string.substring(n);
        }
        return string;
    }

    private String stripTiming(String string) {
        int n = string.indexOf(TIME_PREFIX);
        if (n != -1) {
            int n2 = GdbUtils.findMatchingCurly(string, n + TIME_PREFIX.length());
            if (n2 != -1) {
                return string.substring(0, n) + string.substring(n2 + 1);
            }
            log.warning("Matching curly not found in timing info: " + string);
        }
        return string;
    }

    private GdbLogger getLogger() {
        return this.gdbProxy.getLogger();
    }

    public MICommand createMICommand(String string) {
        return new MICommandImpl(this.nextToken(), string);
    }

    private class MICommandImpl
    implements MICommand {
        private final int token;
        private final String cmd;
        private boolean sent = false;

        public MICommandImpl(int n, String string) {
            this.token = n;
            this.cmd = string;
        }

        public String getText() {
            return this.cmd;
        }

        public int getToken() {
            return this.token;
        }

        public synchronized void send() {
            assert (!this.sent) : "sending command " + this + " twice";
            GdbProxyEngine.this.sendCommand(this);
            this.sent = true;
        }

        public boolean equals(Object object) {
            if (object instanceof MICommand) {
                return this.getToken() == ((MICommand)object).getToken();
            }
            return false;
        }

        public int hashCode() {
            return this.getToken();
        }

        public String toString() {
            return this.token + this.cmd;
        }
    }
}

