/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.gdb.profiles;

import org.netbeans.modules.cnd.api.xml.VersionException;
import org.netbeans.modules.cnd.api.xml.XMLDecoder;
import org.netbeans.modules.cnd.api.xml.XMLEncoder;
import org.netbeans.modules.cnd.api.xml.XMLEncoderStream;
import org.netbeans.modules.cnd.debugger.gdb.profiles.GdbProfile;
import org.xml.sax.Attributes;

class GdbProfileXMLCodec
extends XMLDecoder
implements XMLEncoder {
    private static final int thisversion = 2;
    private static final String GDB_COMMAND_ELEMENT = "gdb_command";
    private static final String ARRAY_REPEAT_THRESHOLD_ELEMENT = "array_repeat_threshold";
    private GdbProfile profile;

    public GdbProfileXMLCodec(GdbProfile gdbProfile) {
        this.profile = gdbProfile;
    }

    public static int getVersion() {
        return 2;
    }

    public String tag() {
        return "gdbdebugger";
    }

    public void start(Attributes attributes) throws VersionException {
        String string = this.tag();
        int n = GdbProfileXMLCodec.getVersion();
        this.checkVersion(attributes, string, n);
    }

    public void end() {
    }

    public void startElement(String string, Attributes attributes) {
    }

    public void endElement(String string, String string2) {
        if (string.equals(GDB_COMMAND_ELEMENT)) {
            this.profile.setGdbCommand(string2);
        } else if (string.equals(ARRAY_REPEAT_THRESHOLD_ELEMENT)) {
            try {
                this.profile.setArrayRepeatThreshold(Integer.parseInt(string2));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    public void encode(XMLEncoderStream xMLEncoderStream) {
        GdbProfileXMLCodec.encode(xMLEncoderStream, this.profile);
    }

    private static void encode(XMLEncoderStream xMLEncoderStream, GdbProfile gdbProfile) {
        xMLEncoderStream.elementOpen("gdbdebugger", GdbProfileXMLCodec.getVersion());
        xMLEncoderStream.element(GDB_COMMAND_ELEMENT, gdbProfile.getGdbCommand());
        xMLEncoderStream.element(ARRAY_REPEAT_THRESHOLD_ELEMENT, Integer.toString(gdbProfile.getArrayRepeatThreshold()));
        xMLEncoderStream.elementClose("gdbdebugger");
    }
}

