/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.gdb.models;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.netbeans.modules.cnd.debugger.gdb.GdbCallStackFrame;
import org.netbeans.modules.cnd.debugger.gdb.GdbDebugger;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.viewmodel.ModelEvent;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.TreeModel;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.util.RequestProcessor;

public class CallStackTreeModel
implements TreeModel {
    private final GdbDebugger debugger;
    private final Collection<ModelListener> listeners = new HashSet<ModelListener>();
    private Listener listener;

    public CallStackTreeModel(ContextProvider contextProvider) {
        this.debugger = (GdbDebugger)contextProvider.lookupFirst(null, GdbDebugger.class);
    }

    public Object[] getChildren(Object object, int n, int n2) throws UnknownTypeException {
        if (object.equals("Root")) {
            List<GdbCallStackFrame> list = this.debugger.getCallStack();
            return list.toArray(new GdbCallStackFrame[list.size()]);
        }
        throw new UnknownTypeException(object);
    }

    public int getChildrenCount(Object object) throws UnknownTypeException {
        if (object.equals("Root")) {
            return Integer.MAX_VALUE;
        }
        throw new UnknownTypeException(object);
    }

    public Object getRoot() {
        return "Root";
    }

    public boolean isLeaf(Object object) throws UnknownTypeException {
        if (object.equals("Root")) {
            return false;
        }
        if (object instanceof GdbCallStackFrame) {
            return true;
        }
        throw new UnknownTypeException(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addModelListener(ModelListener modelListener) {
        Collection<ModelListener> collection = this.listeners;
        synchronized (collection) {
            this.listeners.add(modelListener);
            if (this.listener == null) {
                this.listener = new Listener(this, this.debugger);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeModelListener(ModelListener modelListener) {
        Collection<ModelListener> collection = this.listeners;
        synchronized (collection) {
            this.listeners.remove(modelListener);
            if (this.listeners.isEmpty()) {
                this.listener.destroy();
                this.listener = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireTreeChanged() {
        Object[] objectArray;
        ModelEvent.TreeChanged treeChanged = this.listeners;
        synchronized (treeChanged) {
            objectArray = this.listeners.toArray();
        }
        treeChanged = new ModelEvent.TreeChanged((Object)this);
        for (int i = 0; i < objectArray.length; ++i) {
            ((ModelListener)objectArray[i]).modelChanged((ModelEvent)treeChanged);
        }
    }

    private static class Listener
    implements PropertyChangeListener {
        private final GdbDebugger debugger;
        private final WeakReference<CallStackTreeModel> model;
        private RequestProcessor.Task task;

        public Listener(CallStackTreeModel callStackTreeModel, GdbDebugger gdbDebugger) {
            this.debugger = gdbDebugger;
            this.model = new WeakReference<CallStackTreeModel>(callStackTreeModel);
            gdbDebugger.addPropertyChangeListener(this);
        }

        private CallStackTreeModel getModel() {
            CallStackTreeModel callStackTreeModel = (CallStackTreeModel)this.model.get();
            if (callStackTreeModel == null) {
                this.destroy();
            }
            return callStackTreeModel;
        }

        void destroy() {
            this.debugger.removePropertyChangeListener(this);
            if (this.task != null) {
                this.task.cancel();
                this.task = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName().equals("state") && this.debugger.isStopped()) {
                Listener listener = this;
                synchronized (listener) {
                    if (this.task == null) {
                        this.task = RequestProcessor.getDefault().create((Runnable)new Refresher());
                    }
                    this.task.schedule(200);
                }
            }
        }

        private class Refresher
        implements Runnable {
            private Refresher() {
            }

            public void run() {
                CallStackTreeModel callStackTreeModel;
                if (Listener.this.debugger.isStopped() && (callStackTreeModel = Listener.this.getModel()) != null) {
                    callStackTreeModel.fireTreeChanged();
                }
            }
        }
    }
}

