/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.gdb.disassembly;

import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.modules.cnd.debugger.common.EditorContextBridge;
import org.netbeans.modules.cnd.debugger.common.breakpoints.AddressBreakpoint;
import org.netbeans.modules.cnd.debugger.common.disassembly.DisassemblyService;
import org.netbeans.modules.cnd.debugger.gdb.GdbDebugger;
import org.netbeans.modules.cnd.debugger.gdb.breakpoints.BreakpointImpl;
import org.netbeans.modules.cnd.debugger.gdb.disassembly.Disassembly;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.Annotation;

public class GdbDisassemblyService
implements DisassemblyService {
    public int getAddressLine(String string) {
        Disassembly disassembly = Disassembly.getCurrent();
        if (disassembly == null) {
            return -1;
        }
        return disassembly.getAddressLine(string);
    }

    public int getBreakpointLine(AddressBreakpoint addressBreakpoint) {
        BreakpointImpl<?> breakpointImpl;
        int n = this.getAddressLine(addressBreakpoint.getAddress());
        if (n < 1 && (breakpointImpl = GdbDebugger.getBreakpointImpl((Breakpoint)addressBreakpoint)) != null) {
            return Disassembly.getCurrent().getAddressLine(breakpointImpl.getAddress());
        }
        return n;
    }

    public String getLineAddress(int n) {
        Disassembly disassembly = Disassembly.getCurrent();
        if (disassembly == null) {
            return null;
        }
        return disassembly.getLineAddress(n);
    }

    public boolean isDis(String string) {
        return Disassembly.isDisasm(string);
    }

    public boolean showBreakpoint(AddressBreakpoint addressBreakpoint) {
        return this.showLine(this.getBreakpointLine(addressBreakpoint));
    }

    private boolean showLine(int n) {
        if (n != -1) {
            FileObject fileObject = Disassembly.getFileObject();
            if (fileObject != null) {
                try {
                    return EditorContextBridge.getContext().showSource(DataObject.find((FileObject)fileObject), n, null);
                }
                catch (DataObjectNotFoundException dataObjectNotFoundException) {}
            }
        } else {
            Disassembly.open();
        }
        return false;
    }

    public boolean showAddress(String string) {
        return this.showLine(this.getAddressLine(string));
    }

    public Annotation annotateAddress(String string, String string2) {
        FileObject fileObject;
        Disassembly disassembly = Disassembly.getCurrent();
        if (disassembly == null) {
            return null;
        }
        int n = disassembly.getAddressLine(string);
        if (n != -1 && (fileObject = Disassembly.getFileObject()) != null) {
            try {
                return EditorContextBridge.getContext().annotate(DataObject.find((FileObject)fileObject), n, string2, null);
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                // empty catch block
            }
        }
        return null;
    }
}

