/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.gdb.breakpoints;

import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.modules.cnd.debugger.common.EditorContextBridge;
import org.netbeans.modules.cnd.debugger.common.breakpoints.BreakpointAnnotationProvider;
import org.netbeans.modules.cnd.debugger.common.breakpoints.CndBreakpoint;
import org.netbeans.modules.cnd.debugger.common.breakpoints.SessionBreakpointAnnotationProvider;
import org.netbeans.modules.cnd.debugger.common.disassembly.DisassemblyService;
import org.netbeans.modules.cnd.debugger.gdb.GdbDebugger;
import org.netbeans.modules.cnd.debugger.gdb.breakpoints.AddressBreakpointImpl;
import org.netbeans.modules.cnd.debugger.gdb.breakpoints.BreakpointImpl;
import org.netbeans.modules.cnd.debugger.gdb.breakpoints.FunctionBreakpointImpl;
import org.openide.filesystems.FileObject;

public class GdbBreakpointAnnotationImpl
implements SessionBreakpointAnnotationProvider {
    public int[] getBreakpointAnnotationLines(CndBreakpoint cndBreakpoint, FileObject fileObject) {
        int n;
        DisassemblyService disassemblyService;
        BreakpointImpl<?> breakpointImpl = GdbDebugger.getBreakpointImpl((Breakpoint)cndBreakpoint);
        if (breakpointImpl instanceof FunctionBreakpointImpl) {
            int n2;
            if (fileObject.getPath().equals(breakpointImpl.getFullname()) && (n2 = breakpointImpl.getLine()) >= 0) {
                return new int[]{n2};
            }
        } else if (breakpointImpl instanceof AddressBreakpointImpl && (disassemblyService = EditorContextBridge.getCurrentDisassemblyService()) != null && (n = disassemblyService.getAddressLine(breakpointImpl.getAddress())) >= 0) {
            return new int[]{n};
        }
        return null;
    }

    public String getAnnotationType(CndBreakpoint cndBreakpoint) {
        String string = BreakpointAnnotationProvider.getAnnotationType((CndBreakpoint)cndBreakpoint);
        BreakpointImpl<?> breakpointImpl = GdbDebugger.getBreakpointImpl((Breakpoint)cndBreakpoint);
        if (breakpointImpl == null && cndBreakpoint.isEnabled()) {
            return string + "_broken";
        }
        return string;
    }
}

