/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.ruby;

import java.util.ListIterator;
import java.util.Set;
import javax.swing.text.Document;
import org.jrubyparser.ast.ArgumentNode;
import org.jrubyparser.ast.ClassNode;
import org.jrubyparser.ast.ClassVarAsgnNode;
import org.jrubyparser.ast.ClassVarDeclNode;
import org.jrubyparser.ast.ClassVarNode;
import org.jrubyparser.ast.ConstNode;
import org.jrubyparser.ast.GlobalAsgnNode;
import org.jrubyparser.ast.GlobalVarNode;
import org.jrubyparser.ast.IScopingNode;
import org.jrubyparser.ast.InstAsgnNode;
import org.jrubyparser.ast.InstVarNode;
import org.jrubyparser.ast.MethodDefNode;
import org.jrubyparser.ast.ModuleNode;
import org.jrubyparser.ast.Node;
import org.jrubyparser.ast.SClassNode;
import org.jrubyparser.ast.SymbolNode;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.csl.api.ElementKind;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.parsing.spi.indexing.support.QuerySupport;
import org.netbeans.modules.refactoring.ruby.RetoucheUtils;
import org.netbeans.modules.ruby.Arity;
import org.netbeans.modules.ruby.AstPath;
import org.netbeans.modules.ruby.AstUtilities;
import org.netbeans.modules.ruby.ContextKnowledge;
import org.netbeans.modules.ruby.RubyIndex;
import org.netbeans.modules.ruby.RubyType;
import org.netbeans.modules.ruby.RubyTypeInferencer;
import org.netbeans.modules.ruby.RubyUtils;
import org.netbeans.modules.ruby.elements.AstElement;
import org.netbeans.modules.ruby.elements.Element;
import org.netbeans.modules.ruby.elements.IndexedElement;
import org.netbeans.modules.ruby.elements.IndexedMethod;
import org.netbeans.modules.ruby.lexer.Call;
import org.netbeans.modules.ruby.lexer.LexUtilities;
import org.openide.filesystems.FileObject;

public class RubyElementCtx {
    private Node node;
    private Node root;
    private ParserResult info;
    private FileObject fileObject;
    private AstPath path;
    private int caret;
    private BaseDocument document;
    private Element element;
    private ElementKind kind;
    private String name;
    private String simpleName;
    private Arity arity;
    private String defClass;

    public RubyElementCtx(Node node, Node node2, Element element, FileObject fileObject, ParserResult parserResult) {
        this.initialize(node, node2, element, fileObject, parserResult);
    }

    public RubyElementCtx(ParserResult parserResult, int n) {
        Node node = AstUtilities.getRoot((Parser.Result)parserResult);
        int n2 = AstUtilities.getAstOffset((Parser.Result)parserResult, (int)n);
        this.path = new AstPath(node, n2);
        Node node2 = this.path.leaf();
        if (node2 == null) {
            return;
        }
        ListIterator listIterator = this.path.leafToRoot();
        block3: while (listIterator.hasNext()) {
            node2 = (Node)listIterator.next();
            switch (node2.getNodeType()) {
                case ARGUMENTNODE: 
                case LOCALVARNODE: 
                case LOCALASGNNODE: 
                case DVARNODE: 
                case DASGNNODE: 
                case SYMBOLNODE: 
                case FCALLNODE: 
                case VCALLNODE: 
                case CALLNODE: 
                case GLOBALVARNODE: 
                case GLOBALASGNNODE: 
                case INSTVARNODE: 
                case INSTASGNNODE: 
                case CLASSVARNODE: 
                case CLASSVARASGNNODE: 
                case CLASSVARDECLNODE: 
                case COLON2NODE: 
                case CONSTNODE: 
                case CONSTDECLNODE: {
                    break block3;
                }
                default: {
                    if (listIterator.hasNext()) continue block3;
                    node2 = this.path.leaf();
                    break block3;
                }
            }
        }
        AstElement astElement = AstElement.create((ParserResult)parserResult, (Node)node2);
        this.initialize(node, node2, (Element)astElement, RubyUtils.getFileObject((Parser.Result)parserResult), parserResult);
    }

    public RubyElementCtx(RubyElementCtx rubyElementCtx, Node node) {
        AstElement astElement = AstElement.create((ParserResult)this.info, (Node)node);
        this.initialize(rubyElementCtx.getRoot(), node, (Element)astElement, rubyElementCtx.getFileObject(), rubyElementCtx.getInfo());
    }

    public RubyElementCtx(IndexedElement indexedElement) {
        ParserResult[] parserResultArray = new ParserResult[1];
        Node node = AstUtilities.getForeignNode((IndexedElement)indexedElement, (Parser.Result[])parserResultArray);
        ParserResult parserResult = parserResultArray[0];
        AstElement astElement = AstElement.create((ParserResult)parserResult, (Node)node);
        FileObject fileObject = indexedElement.getFileObject();
        this.document = RetoucheUtils.getDocument(null, fileObject);
        this.initialize(this.root, node, (Element)astElement, fileObject, parserResult);
    }

    private void initialize(Node node, Node node2, Element element, FileObject fileObject, ParserResult parserResult) {
        this.root = node;
        this.node = node2;
        this.element = element;
        this.fileObject = fileObject;
        this.info = parserResult;
    }

    public Node getRoot() {
        return this.root;
    }

    public Element getElement() {
        return this.element;
    }

    public void setElement(Element element) {
        this.element = element;
    }

    public FileObject getFileObject() {
        return this.fileObject;
    }

    public void setFileObject(FileObject fileObject) {
        this.fileObject = fileObject;
    }

    public ElementKind getKind() {
        if (this.kind == null) {
            switch (this.node.getNodeType()) {
                case DEFNNODE: 
                case DEFSNODE: {
                    this.kind = AstUtilities.isConstructorMethod((MethodDefNode)((MethodDefNode)this.node)) ? ElementKind.CONSTRUCTOR : ElementKind.METHOD;
                    break;
                }
                case FCALLNODE: 
                case VCALLNODE: 
                case CALLNODE: {
                    this.kind = ElementKind.METHOD;
                    break;
                }
                case CLASSNODE: 
                case SCLASSNODE: {
                    this.kind = ElementKind.CLASS;
                    break;
                }
                case MODULENODE: {
                    this.kind = ElementKind.MODULE;
                    break;
                }
                case LOCALVARNODE: 
                case LOCALASGNNODE: 
                case DVARNODE: 
                case DASGNNODE: {
                    this.kind = ElementKind.VARIABLE;
                    break;
                }
                case ARGUMENTNODE: {
                    AstPath astPath = this.getPath();
                    if (astPath.leafParent() instanceof MethodDefNode) {
                        this.kind = AstUtilities.isConstructorMethod((MethodDefNode)((MethodDefNode)astPath.leafParent())) ? ElementKind.CONSTRUCTOR : ElementKind.METHOD;
                        break;
                    }
                    this.kind = ElementKind.PARAMETER;
                    break;
                }
                case SYMBOLNODE: {
                    if (Character.isUpperCase(((SymbolNode)this.node).getName().charAt(0))) {
                        this.kind = ElementKind.CLASS;
                        break;
                    }
                    this.kind = ElementKind.METHOD;
                    break;
                }
                case ALIASNODE: {
                    this.kind = ElementKind.METHOD;
                    break;
                }
                case COLON2NODE: 
                case CONSTNODE: {
                    Node node = this.getPath().leafParent();
                    if (node instanceof ClassNode || node instanceof SClassNode) {
                        this.kind = ElementKind.CLASS;
                        break;
                    }
                    if (node instanceof ModuleNode) {
                        this.kind = ElementKind.MODULE;
                        break;
                    }
                    if (this.node instanceof ConstNode) {
                        this.kind = ElementKind.CLASS;
                        break;
                    }
                    this.kind = ElementKind.CONSTANT;
                    break;
                }
                case CONSTDECLNODE: {
                    this.kind = ElementKind.CONSTANT;
                    break;
                }
                case GLOBALVARNODE: 
                case GLOBALASGNNODE: {
                    this.kind = ElementKind.GLOBAL;
                    break;
                }
                case INSTVARNODE: 
                case INSTASGNNODE: 
                case CLASSVARNODE: 
                case CLASSVARASGNNODE: 
                case CLASSVARDECLNODE: {
                    this.kind = ElementKind.FIELD;
                }
            }
        }
        return this.kind;
    }

    public void setKind(ElementKind elementKind) {
        this.kind = elementKind;
    }

    public Node getNode() {
        return this.node;
    }

    public void setNode(Node node) {
        this.node = node;
    }

    public ParserResult getInfo() {
        return this.info;
    }

    public AstPath getPath() {
        if (this.path == null) {
            this.path = new AstPath(this.root, this.node);
        }
        return this.path;
    }

    public int getCaret() {
        return this.caret;
    }

    public String getName() {
        if (this.name == null) {
            String[] stringArray = RetoucheUtils.getNodeNames(this.node);
            this.name = stringArray[0];
            this.simpleName = stringArray[1];
        }
        return this.name;
    }

    public String getSimpleName() {
        if (this.name == null) {
            this.getName();
        }
        return this.simpleName;
    }

    public void setNames(String string, String string2) {
        this.name = string;
        this.simpleName = string2;
    }

    public Arity getArity() {
        if (this.arity == null) {
            AstPath astPath;
            if (this.node instanceof MethodDefNode) {
                this.arity = Arity.getDefArity((Node)this.node);
            } else if (AstUtilities.isCall((Node)this.node)) {
                this.arity = Arity.getCallArity((Node)this.node);
            } else if (this.node instanceof ArgumentNode && (astPath = this.getPath()).leafParent() instanceof MethodDefNode) {
                this.arity = Arity.getDefArity((Node)astPath.leafParent());
            }
        }
        return this.arity;
    }

    public BaseDocument getDocument() {
        if (this.document == null) {
            this.document = RetoucheUtils.getDocument(this.info, RubyUtils.getFileObject((Parser.Result)this.info));
        }
        return this.document;
    }

    private String getViewControllerRequire(FileObject fileObject) {
        return null;
    }

    public String getDefClass() {
        if (this.defClass == null) {
            if (RubyUtils.isRhtmlFile((FileObject)this.fileObject)) {
                this.defClass = "ActionView::Base";
            } else if (AstUtilities.isCall((Node)this.node)) {
                BaseDocument baseDocument = this.getDocument();
                TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)baseDocument);
                int n = AstUtilities.getCallRange((Node)this.node).getStart();
                Call call = Call.getCallType((BaseDocument)baseDocument, (TokenHierarchy)tokenHierarchy, (int)n);
                int n2 = LexUtilities.getLexerOffset((Parser.Result)this.info, (int)n);
                RubyType rubyType = RubyType.createUnknown();
                RubyType rubyType2 = call.getType();
                if (rubyType2.isKnown() && !call.isLHSConstant()) {
                    rubyType = rubyType2;
                }
                String string = call.getLhs();
                if (!rubyType.isKnown() && string != null && this.node != null && call.isSimpleIdentifier()) {
                    Node node = AstUtilities.findLocalScope((Node)this.node, (AstPath)this.getPath());
                    if (node != null) {
                        ContextKnowledge contextKnowledge = new ContextKnowledge(null, node, this.node, n, n2, this.info);
                        RubyTypeInferencer rubyTypeInferencer = RubyTypeInferencer.create((ContextKnowledge)contextKnowledge, (boolean)false);
                        rubyType = rubyTypeInferencer.inferType(string);
                    }
                } else if (call == Call.LOCAL) {
                    Set set;
                    IndexedMethod indexedMethod;
                    RubyIndex rubyIndex = RubyIndex.get((Parser.Result)this.info);
                    String string2 = AstUtilities.getFqnName((AstPath)this.getPath());
                    if (string2 == null || string2.length() == 0) {
                        string2 = "Object";
                    }
                    IndexedMethod indexedMethod2 = indexedMethod = !(set = rubyIndex.getMethods(this.getName(), string2, QuerySupport.Kind.EXACT)).isEmpty() ? (IndexedMethod)set.iterator().next() : rubyIndex.getSuperMethod(string2, this.getName(), false);
                    if (indexedMethod != null) {
                        this.defClass = indexedMethod.getIn();
                    }
                }
                if (this.defClass == null) {
                    this.defClass = !rubyType.isKnown() && (string == null || "self".equals(string)) ? AstUtilities.getFqnName((AstPath)this.getPath()) : (rubyType.isKnown() ? (rubyType.isSingleton() ? rubyType.first() : null) : "<Unknown>");
                }
            } else {
                IScopingNode iScopingNode;
                if (this.getPath() != null && (iScopingNode = AstUtilities.findClassOrModule((AstPath)this.getPath())) != null) {
                    this.defClass = AstUtilities.getClassOrModuleName((IScopingNode)iScopingNode);
                }
                if (this.defClass == null && this.element != null) {
                    this.defClass = this.element.getIn();
                }
                if (this.defClass == null) {
                    this.defClass = "Object";
                }
            }
        }
        return this.defClass;
    }

    public String toString() {
        return "node= " + this.node + ";kind=" + this.getKind() + ";" + super.toString();
    }

    public String getStripPrefix() {
        if (this.node instanceof GlobalVarNode || this.node instanceof GlobalAsgnNode) {
            return "$";
        }
        if (this.node instanceof InstVarNode || this.node instanceof InstAsgnNode) {
            return "@";
        }
        if (this.node instanceof ClassVarNode || this.node instanceof ClassVarDeclNode || this.node instanceof ClassVarAsgnNode) {
            return "@@";
        }
        return null;
    }
}

