/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.highlight.semantic.options;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Set;
import java.util.prefs.Preferences;
import org.openide.util.NbPreferences;
import org.openide.util.WeakSet;

public final class SemanticHighlightingOptions {
    private final Preferences preferences = NbPreferences.forModule(SemanticHighlightingOptions.class);
    private static final String ENABLE_MARK_OCCURRENCES = "EnableMarkOccurrences";
    private static final String KEEP_MARKS = "KeepMarks";
    public static final boolean SEMANTIC_ADVANCED = Boolean.getBoolean("cnd.semantic.advanced");
    private final Set<PropertyChangeListener> listeners = new WeakSet();
    private final Object lock = new Object();

    private SemanticHighlightingOptions() {
    }

    public static SemanticHighlightingOptions instance() {
        return Instantiator.instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        Object object = this.lock;
        synchronized (object) {
            this.listeners.add(propertyChangeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        Object object = this.lock;
        synchronized (object) {
            this.listeners.remove(propertyChangeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        Object object = this.lock;
        synchronized (object) {
            for (PropertyChangeListener propertyChangeListener : this.listeners) {
                propertyChangeListener.propertyChange(propertyChangeEvent);
            }
        }
    }

    private boolean getOption(String string, boolean bl) {
        return this.preferences.getBoolean(string, bl);
    }

    private void setOption(String string, boolean bl) {
        this.preferences.putBoolean(string, bl);
    }

    public boolean getEnableMarkOccurrences() {
        return this.getOption(ENABLE_MARK_OCCURRENCES, true);
    }

    public void setEnableMarkOccurrences(boolean bl) {
        this.setOption(ENABLE_MARK_OCCURRENCES, bl);
    }

    public boolean getKeepMarks() {
        return this.getOption(KEEP_MARKS, true);
    }

    public void setKeepMarks(boolean bl) {
        this.setOption(KEEP_MARKS, bl);
    }

    private static class Instantiator {
        public static SemanticHighlightingOptions instance = new SemanticHighlightingOptions();

        private Instantiator() {
        }
    }
}

