/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.classview;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.netbeans.modules.cnd.api.model.CsmChangeEvent;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmNamespace;
import org.netbeans.modules.cnd.api.model.CsmOffsetableDeclaration;
import org.netbeans.modules.cnd.api.model.CsmProject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SmartChangeEvent {
    protected Map<CsmProject, Storage> changedProjects = new HashMap<CsmProject, Storage>();
    private int count = 1;

    public SmartChangeEvent(CsmChangeEvent csmChangeEvent) {
        this.doAdd(csmChangeEvent);
    }

    public boolean addChangeEvent(CsmChangeEvent csmChangeEvent) {
        if (csmChangeEvent.getRemovedDeclarations().size() == 0) {
            this.doAdd(csmChangeEvent);
            ++this.count;
            return true;
        }
        return false;
    }

    public boolean addChangeEvent(SmartChangeEvent smartChangeEvent) {
        for (Storage storage : this.getChangedProjects().values()) {
            if (storage.getRemovedDeclarations().size() <= 0 && storage.getRemovedNamespaces().size() <= 0) continue;
            return false;
        }
        this.doAdd(smartChangeEvent);
        ++this.count;
        return true;
    }

    int getCount() {
        return this.count;
    }

    private void doAdd(SmartChangeEvent smartChangeEvent) {
        for (Map.Entry<CsmProject, Storage> entry : smartChangeEvent.getChangedProjects().entrySet()) {
            CsmProject csmProject = entry.getKey();
            Storage storage = this.changedProjects.get(csmProject);
            if (storage == null) {
                this.changedProjects.put(csmProject, entry.getValue());
                continue;
            }
            storage.getNewNamespaces().addAll(entry.getValue().getNewNamespaces());
            storage.getRemovedNamespaces().addAll(entry.getValue().getRemovedNamespaces());
            storage.getNewDeclarations().addAll(entry.getValue().getNewDeclarations());
            storage.getRemovedDeclarations().addAll(entry.getValue().getRemovedDeclarations());
            storage.getChangedDeclarations().putAll(entry.getValue().getChangedDeclarations());
        }
    }

    private void doAdd(CsmChangeEvent csmChangeEvent) {
        Storage storage;
        for (CsmNamespace object : csmChangeEvent.getNewNamespaces()) {
            storage = this.getStorage(object);
            if (storage == null) continue;
            storage.addNewNamespaces(object);
        }
        for (CsmNamespace csmNamespace : csmChangeEvent.getRemovedNamespaces()) {
            storage = this.getStorage(csmNamespace);
            if (storage == null) continue;
            storage.addRemovedNamespaces(csmNamespace);
        }
        for (CsmOffsetableDeclaration csmOffsetableDeclaration : csmChangeEvent.getNewDeclarations()) {
            storage = this.getStorage(csmOffsetableDeclaration);
            if (storage == null) continue;
            storage.addNewDeclaration(csmOffsetableDeclaration);
        }
        for (CsmOffsetableDeclaration csmOffsetableDeclaration : csmChangeEvent.getRemovedDeclarations()) {
            storage = this.getStorage(csmOffsetableDeclaration);
            if (storage == null) continue;
            storage.addRemovedDeclarations(csmOffsetableDeclaration);
        }
        for (Map.Entry entry : csmChangeEvent.getChangedDeclarations().entrySet()) {
            storage = this.getStorage((CsmOffsetableDeclaration)entry.getValue());
            if (storage == null) continue;
            storage.addChangedDeclarations((CsmOffsetableDeclaration)entry.getKey(), (CsmOffsetableDeclaration)entry.getValue());
        }
    }

    private Storage getStorage(CsmNamespace csmNamespace) {
        CsmProject csmProject = csmNamespace.getProject();
        if (csmProject != null && csmProject.isValid()) {
            Storage storage = this.changedProjects.get(csmProject);
            if (storage == null) {
                storage = new Storage(csmProject);
                this.changedProjects.put(csmProject, storage);
            }
            return storage;
        }
        return null;
    }

    private Storage getStorage(CsmOffsetableDeclaration csmOffsetableDeclaration) {
        CsmProject csmProject = SmartChangeEvent.findProject(csmOffsetableDeclaration);
        if (csmProject != null && csmProject.isValid()) {
            Storage storage = this.changedProjects.get(csmProject);
            if (storage == null) {
                storage = new Storage(csmProject);
                this.changedProjects.put(csmProject, storage);
            }
            return storage;
        }
        return null;
    }

    private static CsmProject findProject(CsmOffsetableDeclaration csmOffsetableDeclaration) {
        CsmFile csmFile = csmOffsetableDeclaration.getContainingFile();
        if (csmFile != null) {
            if (csmFile.isValid()) {
                return csmFile.getProject();
            }
            return null;
        }
        System.err.println("Cannot fing project for declaration " + csmOffsetableDeclaration.getUniqueName());
        return null;
    }

    public Map<CsmProject, Storage> getChangedProjects() {
        return this.changedProjects;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Storage {
        private CsmProject changedProject;
        private Set<CsmNamespace> newNamespaces = new HashSet<CsmNamespace>();
        private Set<CsmNamespace> removedNamespaces = new HashSet<CsmNamespace>();
        private Set<CsmOffsetableDeclaration> newDeclarations = new HashSet<CsmOffsetableDeclaration>();
        private Set<CsmOffsetableDeclaration> removedDeclarations = new HashSet<CsmOffsetableDeclaration>();
        private Map<CsmOffsetableDeclaration, CsmOffsetableDeclaration> changedDeclarations = new HashMap<CsmOffsetableDeclaration, CsmOffsetableDeclaration>();

        public Storage(CsmProject csmProject) {
            this.changedProject = csmProject;
        }

        public Collection<CsmOffsetableDeclaration> getNewDeclarations() {
            return this.newDeclarations;
        }

        private void addNewDeclaration(CsmOffsetableDeclaration csmOffsetableDeclaration) {
            this.newDeclarations.add(csmOffsetableDeclaration);
        }

        public Collection<CsmOffsetableDeclaration> getRemovedDeclarations() {
            return this.removedDeclarations;
        }

        private void addRemovedDeclarations(CsmOffsetableDeclaration csmOffsetableDeclaration) {
            this.removedDeclarations.add(csmOffsetableDeclaration);
        }

        public Map<CsmOffsetableDeclaration, CsmOffsetableDeclaration> getChangedDeclarations() {
            return this.changedDeclarations;
        }

        private void addChangedDeclarations(CsmOffsetableDeclaration csmOffsetableDeclaration, CsmOffsetableDeclaration csmOffsetableDeclaration2) {
            this.changedDeclarations.put(csmOffsetableDeclaration, csmOffsetableDeclaration2);
        }

        public CsmProject getProject() {
            return this.changedProject;
        }

        public Collection<CsmNamespace> getNewNamespaces() {
            return this.newNamespaces;
        }

        private void addNewNamespaces(CsmNamespace csmNamespace) {
            this.newNamespaces.add(csmNamespace);
        }

        public Collection<CsmNamespace> getRemovedNamespaces() {
            return this.removedNamespaces;
        }

        private void addRemovedNamespaces(CsmNamespace csmNamespace) {
            this.removedNamespaces.add(csmNamespace);
        }
    }
}

