/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.editor.semantic;

import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ImportTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.java.editor.imports.JavaFixAllImports;
import org.netbeans.spi.editor.hints.ChangeInfo;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.editor.hints.Severity;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoveUnusedImportFix
implements Fix {
    public static final String IS_ENABLED_KEY = "Enabled";
    private static final String SEVERITY_KEY = "Severity";
    private static Preferences preferences;
    private FileObject file;
    private List<TreePathHandle> importsToRemove;
    private String bundleKey;
    private static Map<Severity, Integer> severity2index;

    public static RemoveUnusedImportFix create(FileObject fileObject, TreePathHandle treePathHandle) {
        return new RemoveUnusedImportFix(fileObject, Collections.singletonList(treePathHandle), "FIX_Remove_Unused_Import");
    }

    public static RemoveUnusedImportFix create(FileObject fileObject, List<TreePathHandle> list) {
        return new RemoveUnusedImportFix(fileObject, list, "FIX_All_Remove_Unused_Import");
    }

    private RemoveUnusedImportFix(FileObject fileObject, List<TreePathHandle> list, String string) {
        this.file = fileObject;
        this.importsToRemove = list;
        this.bundleKey = string;
    }

    public String getText() {
        return NbBundle.getMessage(RemoveUnusedImportFix.class, (String)this.bundleKey);
    }

    public ChangeInfo implement() {
        JavaSource javaSource = JavaSource.forFileObject((FileObject)this.file);
        if (javaSource == null) {
            StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(JavaFixAllImports.class, (String)"MSG_CannotFixImports"));
        } else {
            try {
                javaSource.runModificationTask((Task)new Task<WorkingCopy>(){

                    public void run(WorkingCopy workingCopy) throws Exception {
                        workingCopy.toPhase(JavaSource.Phase.PARSED);
                        CompilationUnitTree compilationUnitTree = workingCopy.getCompilationUnit();
                        for (TreePathHandle treePathHandle : RemoveUnusedImportFix.this.importsToRemove) {
                            TreePath treePath = treePathHandle.resolve((CompilationInfo)workingCopy);
                            if (treePath == null) {
                                Logger.getLogger(RemoveUnusedImportFix.class.getName()).info("Cannot resolve import to remove.");
                                return;
                            }
                            compilationUnitTree = workingCopy.getTreeMaker().removeCompUnitImport(compilationUnitTree, (ImportTree)treePath.getLeaf());
                        }
                        workingCopy.rewrite((Tree)workingCopy.getCompilationUnit(), (Tree)compilationUnitTree);
                    }
                }).commit();
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
        return null;
    }

    private static synchronized Preferences getPreferences() {
        if (preferences == null) {
            preferences = NbPreferences.forModule(RemoveUnusedImportFix.class);
        }
        return preferences;
    }

    public static synchronized boolean isEnabled() {
        return RemoveUnusedImportFix.getPreferences().getBoolean(IS_ENABLED_KEY, true);
    }

    public static void setEnabled(boolean bl) {
        RemoveUnusedImportFix.getPreferences().putBoolean(IS_ENABLED_KEY, bl);
    }

    public static Severity getSeverity() {
        int n = RemoveUnusedImportFix.getPreferences().getInt(SEVERITY_KEY, 1);
        for (Map.Entry<Severity, Integer> entry : severity2index.entrySet()) {
            if (entry.getValue() != n) continue;
            return entry.getKey();
        }
        return Severity.VERIFIER;
    }

    public static void setSeverity(Severity severity) {
        RemoveUnusedImportFix.getPreferences().putInt(SEVERITY_KEY, severity2index.get(severity));
    }

    static {
        severity2index = new HashMap<Severity, Integer>();
        severity2index.put(Severity.ERROR, 0);
        severity2index.put(Severity.VERIFIER, 1);
        severity2index.put(Severity.HINT, 2);
    }
}

