/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.java;

import java.util.HashMap;
import java.util.Map;
import javax.swing.text.Document;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.TokenChange;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenHierarchyEvent;
import org.netbeans.api.lexer.TokenHierarchyListener;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.api.lexer.TokenSequence;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TokenBalance
implements TokenHierarchyListener {
    private final Document doc;
    private final Map<Language<?>, LanguageHandler<?>> lang2handler;
    private boolean scanDone;

    public static <T extends TokenId> TokenBalance get(Document document) {
        TokenBalance tokenBalance = (TokenBalance)document.getProperty(TokenBalance.class);
        if (tokenBalance == null) {
            tokenBalance = new TokenBalance(document);
            document.putProperty(TokenBalance.class, tokenBalance);
        }
        return tokenBalance;
    }

    private TokenBalance(Document document) {
        this.doc = document;
        this.lang2handler = new HashMap();
        TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)document);
        tokenHierarchy.addTokenHierarchyListener((TokenHierarchyListener)this);
    }

    public boolean isTracked(Language<?> language) {
        return this.handler(language, false) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends TokenId> void addTokenPair(Language<T> language, T t, T t2) {
        Map<Language<?>, LanguageHandler<?>> map = this.lang2handler;
        synchronized (map) {
            this.handler(language, true).addTokenPair(t, t2);
            this.scanDone = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tokenHierarchyChanged(TokenHierarchyEvent tokenHierarchyEvent) {
        Map<Language<?>, LanguageHandler<?>> map = this.lang2handler;
        synchronized (map) {
            if (this.scanDone) {
                for (LanguageHandler<?> languageHandler : this.lang2handler.values()) {
                    languageHandler.handleEvent(tokenHierarchyEvent);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends TokenId> int balance(Language<T> language, T t) {
        Map<Language<?>, LanguageHandler<?>> map = this.lang2handler;
        synchronized (map) {
            this.checkScanDone();
            LanguageHandler<T> languageHandler = this.handler(language, false);
            return languageHandler != null ? languageHandler.balance(t) : Integer.MAX_VALUE;
        }
    }

    private <T extends TokenId> LanguageHandler<T> handler(Language<T> language, boolean bl) {
        LanguageHandler<Object> languageHandler = this.lang2handler.get(language);
        if (languageHandler == null && bl) {
            languageHandler = new LanguageHandler<T>(language);
            this.lang2handler.put(language, languageHandler);
        }
        return languageHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkScanDone() {
        Map<Language<?>, LanguageHandler<?>> map = this.lang2handler;
        synchronized (map) {
            if (!this.scanDone) {
                TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)this.doc);
                for (LanguageHandler<?> languageHandler : this.lang2handler.values()) {
                    languageHandler.scan(tokenHierarchy);
                }
                this.scanDone = true;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class TokenIdPair<T extends TokenId> {
        T left;
        T right;
        int balance;

        public TokenIdPair(T t, T t2) {
            this.left = t;
            this.right = t2;
        }

        public void updateBalance(T t, int n) {
            if (t == this.left) {
                this.balance += n;
            } else {
                assert (t == this.right);
                this.balance -= n;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class LanguageHandler<T extends TokenId> {
        private final Language<T> language;
        private final Map<T, TokenIdPair<T>> id2Pair;

        LanguageHandler(Language<T> language) {
            this.language = language;
            this.id2Pair = new HashMap<T, TokenIdPair<T>>();
        }

        public final Language<T> language() {
            return this.language;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addTokenPair(T t, T t2) {
            TokenIdPair<T> tokenIdPair = new TokenIdPair<T>(t, t2);
            Map<T, TokenIdPair<T>> map = this.id2Pair;
            synchronized (map) {
                this.id2Pair.put(t, tokenIdPair);
                this.id2Pair.put(t2, tokenIdPair);
            }
        }

        public void scan(TokenHierarchy tokenHierarchy) {
            for (TokenIdPair<T> tokenIdPair : this.id2Pair.values()) {
                tokenIdPair.balance = 0;
            }
            TokenSequence tokenSequence = tokenHierarchy.tokenSequence(this.language);
            if (tokenSequence != null) {
                this.processTokenSequence(tokenSequence, tokenSequence.tokenCount(), 1);
            }
        }

        public void processTokenSequence(TokenSequence<T> tokenSequence, int n, int n2) {
            while (--n >= 0) {
                boolean bl = tokenSequence.moveNext();
                assert (bl);
                TokenId tokenId = tokenSequence.token().id();
                TokenIdPair<TokenId> tokenIdPair = this.id2Pair.get(tokenId);
                if (tokenIdPair == null) continue;
                tokenIdPair.updateBalance(tokenId, n2);
            }
        }

        public void handleEvent(TokenHierarchyEvent tokenHierarchyEvent) {
            TokenChange tokenChange = tokenHierarchyEvent.tokenChange(this.language);
            if (tokenChange != null) {
                if (tokenChange.removedTokenCount() > 0) {
                    this.processTokenSequence(tokenChange.removedTokenSequence(), tokenChange.removedTokenCount(), -1);
                }
                if (tokenChange.addedTokenCount() > 0) {
                    this.processTokenSequence(tokenChange.currentTokenSequence(), tokenChange.addedTokenCount(), 1);
                }
            }
        }

        public int balance(T t) {
            TokenIdPair<T> tokenIdPair = this.id2Pair.get(t);
            return tokenIdPair.left == t ? tokenIdPair.balance : Integer.MAX_VALUE;
        }
    }
}

