/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.server;

import java.util.HashMap;
import java.util.Map;
import org.netbeans.lib.profiler.server.ClassLoaderManager;
import org.netbeans.lib.profiler.server.ProfilerInterface;
import org.netbeans.lib.profiler.server.ProfilerRuntime;
import org.netbeans.lib.profiler.server.ProfilerRuntimeObjAlloc;
import org.netbeans.lib.profiler.server.ProfilerRuntimeObjLiveness;
import org.netbeans.lib.profiler.server.ProfilerServer;
import org.netbeans.lib.profiler.server.ThreadInfo;
import org.netbeans.lib.profiler.server.system.Classes;
import org.netbeans.lib.profiler.server.system.Stacks;

public class ProfilerRuntimeMemory
extends ProfilerRuntime {
    protected static final int MAX_STACK_FRAMES = 100;
    protected static final int NO_OF_PROFILER_FRAMES = 3;
    protected static int[] allocatedInstancesCount;
    protected static int allocatedInstArrayLength;
    protected static short[] allocatedInstThreshold;
    protected static char[] objectSize;
    protected static short samplingInterval;
    protected static int samplingDepth;
    private static int stackDepth;
    private static int[] stackFrameIds;
    private static Map classIdMap;
    private static long randSeed;
    private static int bits;
    private static short samplingIntervalBase;

    public static void setAllocatedInstancesCountArray(int[] nArray) {
        allocatedInstancesCount = nArray;
        if (nArray == null) {
            allocatedInstThreshold = null;
            objectSize = null;
            stackFrameIds = null;
            Stacks.clearNativeStackFrameBuffer();
            return;
        }
        if (allocatedInstArrayLength < nArray.length) {
            short[] sArray = (short[])(allocatedInstThreshold != null ? allocatedInstThreshold : null);
            allocatedInstThreshold = new short[nArray.length];
            if (sArray != null) {
                System.arraycopy(sArray, 0, allocatedInstThreshold, 0, allocatedInstArrayLength);
            }
            char[] cArray = (char[])(objectSize != null ? objectSize : null);
            objectSize = new char[nArray.length];
            if (cArray != null) {
                System.arraycopy(cArray, 0, objectSize, 0, allocatedInstArrayLength);
            }
            allocatedInstArrayLength = nArray.length;
        }
    }

    public static void setSamplingDepth(int n) {
        if (n < 0) {
            n = 100;
        } else if (n > 0) {
            if ((n += 3) > 100) {
                n = 100;
            }
        } else {
            stackDepth = 0;
        }
        samplingDepth = n;
    }

    public static void setSamplingInterval(short s) {
        samplingInterval = s;
        ProfilerRuntimeMemory.initRandomGenerator();
    }

    public static void resetProfilerCollectors(int n) {
        if (allocatedInstancesCount != null) {
            for (int i = 0; i < allocatedInstancesCount.length; ++i) {
                ProfilerRuntimeMemory.allocatedInstancesCount[i] = 0;
                ProfilerRuntimeMemory.allocatedInstThreshold[i] = 0;
            }
        }
        if (n == 5) {
            ProfilerRuntimeObjLiveness.resetProfilerCollectors();
        }
        classIdMap = new HashMap();
    }

    public static void traceVMObjectAlloc(Object object, Class clazz) {
        if (classIdMap == null || ThreadInfo.profilingSuspended() || ThreadInfo.isProfilerServerThread(Thread.currentThread())) {
            return;
        }
        ThreadInfo threadInfo = ThreadInfo.getThreadInfo();
        if (threadInfo.inProfilingRuntimeMethod > 0) {
            return;
        }
        if (!threadInfo.isInitialized()) {
            threadInfo.initialize(true);
        }
        ++threadInfo.inProfilingRuntimeMethod;
        String string = clazz.getName();
        int n = ClassLoaderManager.registerLoader(clazz);
        String string2 = string + '#' + n;
        Integer n2 = (Integer)classIdMap.get(string2);
        if (n2 == null) {
            int n3 = externalActionsHandler.handleFirstTimeVMObjectAlloc(string, n);
            if (n3 != -1) {
                n2 = new Integer(n3);
                classIdMap.put(string2, n2);
            } else {
                --threadInfo.inProfilingRuntimeMethod;
                return;
            }
        }
        boolean bl = ProfilerInterface.getCurrentInstrType() == 5;
        char c = (char)n2.intValue();
        --threadInfo.inProfilingRuntimeMethod;
        if (bl) {
            ProfilerRuntimeObjLiveness.traceObjAlloc(object, c);
        } else {
            ProfilerRuntimeObjAlloc.traceObjAlloc(object, c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static synchronized void getAndSendCurrentStackTrace(char c, long l) {
        if (eventBuffer == null) {
            return;
        }
        byte[] byArray = eventBuffer;
        synchronized (eventBuffer) {
            if (samplingDepth != 0) {
                stackDepth = Stacks.getCurrentStackFrameIds(Thread.currentThread(), samplingDepth, stackFrameIds);
            }
            ProfilerRuntimeMemory.writeObjAllocStackTraceEvent(c, l);
            // ** MonitorExit[var3_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static synchronized void getAndSendCurrentStackTrace(char c, char c2, int n, long l) {
        if (eventBuffer == null) {
            return;
        }
        byte[] byArray = eventBuffer;
        synchronized (eventBuffer) {
            if (samplingDepth != 0) {
                stackDepth = Stacks.getCurrentStackFrameIds(Thread.currentThread(), samplingDepth, stackFrameIds);
            }
            ProfilerRuntimeMemory.writeObjLivenessStackTraceEvent(c, c2, n, l);
            // ** MonitorExit[var5_4] (shouldn't be in output)
            return;
        }
    }

    protected static long getCachedObjectSize(char c, Object object) {
        long l = objectSize[c];
        if (l <= 1L) {
            if (object == null) {
                System.err.println("*** JFluid critical error: received null object for classId = " + c + " in getCachedObjectSize");
                Thread.dumpStack();
                System.err.println("*** End JFluid critical error message ---------------------------");
            }
            if (l == 0L) {
                l = Classes.getObjectSize((Object)object);
                ProfilerRuntimeMemory.objectSize[c] = object.getClass().isArray() || l > 65535L ? (char)'\u0001' : (char)l;
            } else {
                l = Classes.getObjectSize((Object)object);
            }
        }
        return l;
    }

    protected static void clearDataStructures() {
        ProfilerRuntime.clearDataStructures();
        allocatedInstancesCount = null;
        stackFrameIds = null;
        Stacks.clearNativeStackFrameBuffer();
    }

    protected static void createNewDataStructures() {
        ProfilerRuntime.createNewDataStructures();
        stackFrameIds = new int[100];
        Stacks.createNativeStackFrameBuffer(100);
        classIdMap = new HashMap();
    }

    protected static void enableProfiling(boolean bl) {
    }

    protected static void initRandomGenerator() {
        short s;
        randSeed = System.currentTimeMillis();
        if (samplingInterval == 1) {
            return;
        }
        if (samplingInterval == 2 || samplingInterval == 3) {
            bits = 1;
            samplingIntervalBase = (short)(samplingInterval - 1);
            return;
        }
        bits = 1;
        short s2 = 1;
        while ((s = s2 << 1) < samplingInterval) {
            ++bits;
            s2 = s;
        }
        samplingIntervalBase = (short)(samplingInterval - (s2 >> 1));
        --bits;
    }

    protected static short nextRandomizedInterval() {
        if (samplingInterval == 1) {
            return 1;
        }
        randSeed = randSeed * 25214903917L + 11L & 0xFFFFFFFFFFFFL;
        return (short)(samplingIntervalBase + (int)(randSeed >>> 48 - bits));
    }

    protected static void writeObjAllocStackTraceEvent(char c, long l) {
        int n;
        if (eventBuffer == null) {
            return;
        }
        if (stackDepth != 0) {
            stackDepth -= 3;
        }
        if (globalEvBufPos == 0) {
            ProfilerServer.notifyClientOnResultsAvailability();
        }
        if ((n = globalEvBufPos) + 16 + stackDepth * 4 > globalEvBufPosThreshold) {
            externalActionsHandler.handleEventBufferDump(eventBuffer, 0, n);
            n = 0;
        }
        ProfilerRuntimeMemory.eventBuffer[n++] = 12;
        ProfilerRuntimeMemory.eventBuffer[n++] = (byte)(c >> 8 & 0xFF);
        ProfilerRuntimeMemory.eventBuffer[n++] = (byte)(c & 0xFF);
        ProfilerRuntimeMemory.eventBuffer[n++] = (byte)(l >> 32 & 0xFFL);
        ProfilerRuntimeMemory.eventBuffer[n++] = (byte)(l >> 24 & 0xFFL);
        ProfilerRuntimeMemory.eventBuffer[n++] = (byte)(l >> 16 & 0xFFL);
        ProfilerRuntimeMemory.eventBuffer[n++] = (byte)(l >> 8 & 0xFFL);
        ProfilerRuntimeMemory.eventBuffer[n++] = (byte)(l & 0xFFL);
        globalEvBufPos = n = ProfilerRuntimeMemory.writeStack(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void writeObjGCEvent(long l) {
        if (eventBuffer == null) {
            return;
        }
        byte[] byArray = eventBuffer;
        synchronized (eventBuffer) {
            int n = globalEvBufPos;
            if (n > globalEvBufPosThreshold) {
                externalActionsHandler.handleEventBufferDump(eventBuffer, 0, n);
                n = 0;
            }
            ProfilerRuntimeMemory.eventBuffer[n++] = 15;
            ProfilerRuntimeMemory.eventBuffer[n++] = (byte)(l >> 56 & 0xFFL);
            ProfilerRuntimeMemory.eventBuffer[n++] = (byte)(l >> 48 & 0xFFL);
            ProfilerRuntimeMemory.eventBuffer[n++] = (byte)(l >> 40 & 0xFFL);
            ProfilerRuntimeMemory.eventBuffer[n++] = (byte)(l >> 32 & 0xFFL);
            ProfilerRuntimeMemory.eventBuffer[n++] = (byte)(l >> 24 & 0xFFL);
            ProfilerRuntimeMemory.eventBuffer[n++] = (byte)(l >> 16 & 0xFFL);
            ProfilerRuntimeMemory.eventBuffer[n++] = (byte)(l >> 8 & 0xFFL);
            ProfilerRuntimeMemory.eventBuffer[n++] = (byte)(l & 0xFFL);
            globalEvBufPos = n;
            // ** MonitorExit[var2_1] (shouldn't be in output)
            return;
        }
    }

    protected static void writeObjLivenessStackTraceEvent(char c, char c2, int n, long l) {
        int n2;
        if (eventBuffer == null) {
            return;
        }
        if (stackDepth != 0) {
            stackDepth -= 3;
        }
        if (globalEvBufPos == 0) {
            ProfilerServer.notifyClientOnResultsAvailability();
        }
        if ((n2 = globalEvBufPos) + 24 + stackDepth * 4 > globalEvBufPosThreshold) {
            externalActionsHandler.handleEventBufferDump(eventBuffer, 0, n2);
            n2 = 0;
        }
        ProfilerRuntimeMemory.eventBuffer[n2++] = 14;
        ProfilerRuntimeMemory.eventBuffer[n2++] = (byte)(c >> 8 & 0xFF);
        ProfilerRuntimeMemory.eventBuffer[n2++] = (byte)(c & 0xFF);
        ProfilerRuntimeMemory.eventBuffer[n2++] = (byte)(c2 >> 8 & 0xFF);
        ProfilerRuntimeMemory.eventBuffer[n2++] = (byte)(c2 & 0xFF);
        ProfilerRuntimeMemory.eventBuffer[n2++] = (byte)(n >> 24 & 0xFF);
        ProfilerRuntimeMemory.eventBuffer[n2++] = (byte)(n >> 16 & 0xFF);
        ProfilerRuntimeMemory.eventBuffer[n2++] = (byte)(n >> 8 & 0xFF);
        ProfilerRuntimeMemory.eventBuffer[n2++] = (byte)(n & 0xFF);
        ProfilerRuntimeMemory.eventBuffer[n2++] = (byte)(l >> 32 & 0xFFL);
        ProfilerRuntimeMemory.eventBuffer[n2++] = (byte)(l >> 24 & 0xFFL);
        ProfilerRuntimeMemory.eventBuffer[n2++] = (byte)(l >> 16 & 0xFFL);
        ProfilerRuntimeMemory.eventBuffer[n2++] = (byte)(l >> 8 & 0xFFL);
        ProfilerRuntimeMemory.eventBuffer[n2++] = (byte)(l & 0xFFL);
        globalEvBufPos = n2 = ProfilerRuntimeMemory.writeStack(n2);
    }

    private static int writeStack(int n) {
        ProfilerRuntimeMemory.eventBuffer[n++] = (byte)(stackDepth >> 16 & 0xFF);
        ProfilerRuntimeMemory.eventBuffer[n++] = (byte)(stackDepth >> 8 & 0xFF);
        ProfilerRuntimeMemory.eventBuffer[n++] = (byte)(stackDepth & 0xFF);
        int n2 = 3;
        for (int i = 0; i < stackDepth; ++i) {
            ProfilerRuntimeMemory.eventBuffer[n++] = (byte)(stackFrameIds[n2] >> 24 & 0xFF);
            ProfilerRuntimeMemory.eventBuffer[n++] = (byte)(stackFrameIds[n2] >> 16 & 0xFF);
            ProfilerRuntimeMemory.eventBuffer[n++] = (byte)(stackFrameIds[n2] >> 8 & 0xFF);
            ProfilerRuntimeMemory.eventBuffer[n++] = (byte)(stackFrameIds[n2] & 0xFF);
            ++n2;
        }
        return n;
    }
}

