/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.glassfish.eecommon.api;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.j2ee.dd.api.common.InitParam;
import org.netbeans.modules.j2ee.dd.api.common.VersionNotSupportedException;
import org.netbeans.modules.j2ee.dd.api.web.DDProvider;
import org.netbeans.modules.j2ee.dd.api.web.Filter;
import org.netbeans.modules.j2ee.dd.api.web.FilterMapping;
import org.netbeans.modules.j2ee.dd.api.web.WebApp;
import org.netbeans.modules.schema2beans.BaseBean;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.modules.InstalledFileLocator;
import org.openide.modules.ModuleInfo;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.xml.sax.SAXException;

public class HttpMonitorHelper {
    private static final String MONITOR_MODULE_NAME = "org.netbeans.modules.web.monitor";
    private static ModuleInfo httpMonitorInfo;
    private static ModuleSpy monitorSpy;
    private static Lookup.Result res;
    private static MonitorInfoListener monitorInfoListener;
    private static MonitorLookupListener monitorLookupListener;
    private static final String MONITOR_FILTER_NAME = "HTTPMonitorFilter";
    private static final String MONITOR_FILTER_CLASS = "org.netbeans.modules.web.monitor.server.MonitorFilter";
    private static final String MONITOR_FILTER_PATTERN = "/*";
    private static final String MONITOR_INTERNALPORT_PARAM_NAME = "netbeans.monitor.ide";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean synchronizeMonitor(String string, String string2, boolean bl, String ... stringArray) throws FileNotFoundException, IOException, SAXException {
        boolean bl2 = HttpMonitorHelper.isMonitorEnabled();
        boolean bl3 = bl2 && bl;
        File file = HttpMonitorHelper.getDefaultWebXML(string, string2);
        if (file == null) {
            return false;
        }
        WebApp webApp = DDProvider.getDefault().getDDRoot(file);
        if (webApp == null) {
            ErrorManager.getDefault().notify(1, (Throwable)new Exception(""));
            return false;
        }
        boolean bl4 = false;
        boolean bl5 = false;
        try {
            if (bl3) {
                bl5 = HttpMonitorHelper.addMonitorJars(string, string2, stringArray);
                boolean bl6 = HttpMonitorHelper.changeFilterMonitor(webApp, true);
                bl4 = bl4 || bl6;
                bl6 = HttpMonitorHelper.specifyFilterPortParameter(webApp);
                bl4 = bl4 || bl6;
            } else {
                boolean bl7 = HttpMonitorHelper.changeFilterMonitor(webApp, false);
                bl4 = bl4 || bl7;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            bl4 = false;
            ErrorManager.getDefault().notify(65536, (Throwable)classNotFoundException);
        }
        if (bl4) {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            try {
                webApp.write((OutputStream)fileOutputStream);
            }
            finally {
                ((OutputStream)fileOutputStream).close();
            }
        }
        return bl5;
    }

    static File getDefaultWebXML(String string, String string2) {
        String string3 = string + "/" + string2 + "/config/default-web.xml";
        File file = new File(string3);
        if (file.exists()) {
            String string4 = string + "/" + string2 + "/config/default-web.xml.orig";
            File file2 = new File(string4);
            if (!file2.exists()) {
                try {
                    HttpMonitorHelper.copy(file, file2);
                    HttpMonitorHelper.createCopyAndUpgrade(file2, file);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    Logger.getLogger("glassfish-eecommon").log(Level.WARNING, "This file existed a few milliseconds ago: " + file.getAbsolutePath(), fileNotFoundException);
                }
                catch (IOException iOException) {
                    if (file2.exists()) {
                        file2.delete();
                        Logger.getLogger("glassfish-eecommon").log(Level.WARNING, "failed to backup data from " + file.getAbsolutePath(), iOException);
                    }
                    Logger.getLogger("glassfish-eecommon").log(Level.WARNING, "failed to create backup file " + file2.getAbsolutePath(), iOException);
                }
            }
            return file.exists() ? file : null;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void createCopyAndUpgrade(File file, File file2) {
        BufferedReader bufferedReader = null;
        BufferedWriter bufferedWriter = null;
        boolean bl = true;
        try {
            String string;
            bufferedReader = new BufferedReader(new FileReader(file));
            bufferedWriter = new BufferedWriter(new FileWriter(file2));
            while ((string = bufferedReader.readLine()) != null) {
                if (string.startsWith("<!DOCTYPE")) {
                    while (!string.startsWith("<web-app")) {
                        string = bufferedReader.readLine();
                    }
                    bufferedWriter.write("<web-app version=\"2.4\" xmlns=\"http://java.sun.com/xml/ns/j2ee\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://java.sun.com/xml/ns/j2ee http://java.sun.com/xml/ns/j2ee/web-app_2_4.xsd\">");
                    bufferedWriter.newLine();
                    continue;
                }
                bufferedWriter.write(string);
                bufferedWriter.newLine();
            }
            bl = false;
            bufferedWriter.close();
            bufferedWriter = null;
            bufferedReader.close();
            bufferedReader = null;
        }
        catch (FileNotFoundException fileNotFoundException) {
            Logger.getLogger("glassfish-eecommon").log(Level.WARNING, "This file existed a few milliseconds ago: " + file.getAbsolutePath(), fileNotFoundException);
        }
        catch (Exception exception) {
            if (null != bufferedWriter && bl && !file2.delete()) {
                Logger.getLogger("glassfish-eecommon").log(Level.WARNING, "hack to eliminate GF bug 8609 failed and left bogus file: " + file2.getAbsolutePath());
            }
            Logger.getLogger("glassfish-eecommon").log(Level.WARNING, "hack to eliminate GF bug 8609 failed", exception);
        }
        finally {
            if (null != bufferedWriter) {
                try {
                    bufferedWriter.close();
                }
                catch (IOException iOException) {
                    Logger.getLogger("glassfish-eecommon").log(Level.INFO, "close of fw failed: " + file2.getAbsolutePath(), iOException);
                }
            }
            if (null != bufferedReader) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {
                    Logger.getLogger("glassfish-eecommon").log(Level.INFO, "close of fr failed: " + file.getAbsolutePath(), iOException);
                }
            }
        }
    }

    private static boolean addMonitorJars(String string, String string2, String ... stringArray) throws FileNotFoundException, IOException {
        String string3 = string + "/" + string2;
        File file = new File(string3);
        boolean bl = HttpMonitorHelper.copyFromIDEInstToDir("modules/ext/org-netbeans-modules-web-httpmonitor.jar", file, "lib/org-netbeans-modules-web-httpmonitor.jar");
        for (String string4 : stringArray) {
            int n = string4.lastIndexOf("/");
            if (n <= -1) continue;
            String string5 = string4.substring(n + 1);
            bl = bl && HttpMonitorHelper.copyFromIDEInstToDir(string4, file, "lib/" + string5);
        }
        return bl;
    }

    static boolean changeFilterMonitor(WebApp webApp, boolean bl) throws ClassNotFoundException {
        boolean bl2;
        block8: {
            block7: {
                int n;
                bl2 = false;
                if (!bl) break block7;
                boolean bl3 = false;
                Filter[] filterArray = webApp.getFilter();
                for (n = 0; n < filterArray.length; ++n) {
                    if (!filterArray[n].getFilterName().equals(MONITOR_FILTER_NAME)) continue;
                    bl3 = true;
                    break;
                }
                if (!bl3) {
                    Filter filter = (Filter)webApp.createBean("Filter");
                    filter.setFilterName(MONITOR_FILTER_NAME);
                    filter.setFilterClass(MONITOR_FILTER_CLASS);
                    webApp.addFilter(filter);
                    bl2 = true;
                }
                n = 0;
                FilterMapping[] filterMappingArray = webApp.getFilterMapping();
                for (int i = 0; i < filterMappingArray.length; ++i) {
                    if (!filterMappingArray[i].getFilterName().equals(MONITOR_FILTER_NAME)) continue;
                    n = 1;
                    break;
                }
                if (n != 0) break block8;
                FilterMapping filterMapping = (FilterMapping)webApp.createBean("FilterMapping");
                Object[] objectArray = new String[]{"REQUEST", "FORWARD", "INCLUDE", "ERROR"};
                try {
                    filterMapping.setDispatcher((String[])objectArray);
                }
                catch (VersionNotSupportedException versionNotSupportedException) {
                    Logger.getLogger("glassfish-eecommon").log(Level.FINER, "ignorable and ignoring", versionNotSupportedException);
                    ((BaseBean)filterMapping).createProperty("dispatcher", "Dispatcher", 65840, String.class);
                    ((BaseBean)filterMapping).setValue("Dispatcher", objectArray);
                }
                filterMapping.setFilterName(MONITOR_FILTER_NAME);
                filterMapping.setUrlPattern(MONITOR_FILTER_PATTERN);
                webApp.addFilterMapping(filterMapping);
                bl2 = true;
                break block8;
            }
            FilterMapping[] filterMappingArray = webApp.getFilterMapping();
            for (int i = 0; i < filterMappingArray.length; ++i) {
                if (!filterMappingArray[i].getFilterName().equals(MONITOR_FILTER_NAME)) continue;
                webApp.removeFilterMapping(filterMappingArray[i]);
                bl2 = true;
                break;
            }
            Filter[] filterArray = webApp.getFilter();
            for (int i = 0; i < filterArray.length; ++i) {
                if (!filterArray[i].getFilterName().equals(MONITOR_FILTER_NAME)) continue;
                webApp.removeFilter(filterArray[i]);
                bl2 = true;
                break;
            }
        }
        return bl2;
    }

    private static File findInstallationFile(String string) {
        return InstalledFileLocator.getDefault().locate(string, null, false);
    }

    private static boolean copyFromIDEInstToDir(String string, File file, String string2) throws FileNotFoundException, IOException {
        File file2 = HttpMonitorHelper.findFileUnderBase(file, string2);
        File file3 = HttpMonitorHelper.findInstallationFile(string);
        if (file3 != null && file3.exists()) {
            File file4 = file2.getParentFile();
            if (!file4.exists()) {
                file4.mkdirs();
            }
            if (!file2.exists() || file3.length() != file2.length()) {
                HttpMonitorHelper.copy(file3, file2);
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copy(File file, File file2) throws FileNotFoundException, IOException {
        BufferedInputStream bufferedInputStream = null;
        FilterOutputStream filterOutputStream = null;
        try {
            int n;
            bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
            filterOutputStream = new BufferedOutputStream(new FileOutputStream(file2));
            while ((n = bufferedInputStream.read()) != -1) {
                ((BufferedOutputStream)filterOutputStream).write(n);
            }
        }
        finally {
            if (null != bufferedInputStream) {
                try {
                    bufferedInputStream.close();
                }
                catch (IOException iOException) {
                    Logger.getLogger("glassfish-eecommon").log(Level.FINEST, "bis", iOException);
                }
            }
            if (null != filterOutputStream) {
                try {
                    filterOutputStream.close();
                }
                catch (IOException iOException) {
                    Logger.getLogger("glassfish-eecommon").log(Level.FINEST, "bos", iOException);
                }
            }
        }
    }

    private static File findFileUnderBase(File file, String string) {
        if (string.startsWith("/")) {
            string = string.substring(1);
        }
        string = string.replace('/', File.separatorChar);
        return new File(file, string);
    }

    static boolean specifyFilterPortParameter(WebApp webApp) throws ClassNotFoundException {
        Filter[] filterArray = webApp.getFilter();
        Filter filter = null;
        for (int i = 0; i < filterArray.length; ++i) {
            if (!MONITOR_FILTER_NAME.equals(filterArray[i].getFilterName())) continue;
            filter = filterArray[i];
            break;
        }
        if (filter == null) {
            return false;
        }
        InitParam[] initParamArray = filter.getInitParam();
        InitParam initParam = null;
        for (int i = 0; i < initParamArray.length; ++i) {
            if (!MONITOR_INTERNALPORT_PARAM_NAME.equals(initParamArray[i].getParamName())) continue;
            initParam = initParamArray[i];
            break;
        }
        String string = HttpMonitorHelper.getLocalHost() + ":" + HttpMonitorHelper.getInternalServerPort();
        if (initParam == null) {
            InitParam initParam2 = (InitParam)filter.createBean("InitParam");
            initParam2.setParamName(MONITOR_INTERNALPORT_PARAM_NAME);
            initParam2.setParamValue(string);
            filter.addInitParam(initParam2);
            return true;
        }
        if (string.equals(initParam.getParamValue())) {
            return false;
        }
        initParam.setParamValue(string);
        return true;
    }

    private static String getLocalHost() {
        return "127.0.0.1";
    }

    private static URL getSampleHTTPServerURL() {
        FileObject fileObject = FileUtil.getConfigFile((String)"HTTPServer_DUMMY");
        if (fileObject == null) {
            return null;
        }
        URL uRL = URLMapper.findURL((FileObject)fileObject, (int)2);
        return uRL;
    }

    private static String getInternalServerPort() {
        URL uRL = HttpMonitorHelper.getSampleHTTPServerURL();
        if (uRL != null) {
            return Integer.toString(uRL.getPort());
        }
        return "8082";
    }

    private static void startModuleSpy(ModuleSpy moduleSpy) {
        res = Lookup.getDefault().lookup(new Lookup.Template(ModuleInfo.class));
        Iterator iterator = res.allInstances().iterator();
        String string = moduleSpy.getModuleId();
        while (iterator.hasNext()) {
            ModuleInfo moduleInfo = (ModuleInfo)iterator.next();
            if (!moduleInfo.getCodeName().startsWith(string)) continue;
            httpMonitorInfo = moduleInfo;
            moduleSpy.setEnabled(moduleInfo.isEnabled());
            monitorInfoListener = new MonitorInfoListener(moduleSpy);
            httpMonitorInfo.addPropertyChangeListener((PropertyChangeListener)monitorInfoListener);
            break;
        }
        monitorLookupListener = new MonitorLookupListener(moduleSpy, httpMonitorInfo);
        res.addLookupListener((LookupListener)monitorLookupListener);
    }

    static synchronized boolean isMonitorEnabled() {
        if (monitorSpy == null) {
            monitorSpy = new ModuleSpy(MONITOR_MODULE_NAME);
            HttpMonitorHelper.startModuleSpy(monitorSpy);
        }
        return monitorSpy.isEnabled();
    }

    void removeListeners() {
        if (httpMonitorInfo != null) {
            httpMonitorInfo.removePropertyChangeListener((PropertyChangeListener)monitorInfoListener);
        }
        if (res != null) {
            res.removeLookupListener((LookupListener)monitorLookupListener);
        }
    }

    private static class MonitorLookupListener
    implements LookupListener {
        ModuleSpy spy;
        ModuleInfo httpMonitorInfo;

        MonitorLookupListener(ModuleSpy moduleSpy, ModuleInfo moduleInfo) {
            this.spy = moduleSpy;
            this.httpMonitorInfo = moduleInfo;
        }

        public void resultChanged(LookupEvent lookupEvent) {
            Iterator iterator = res.allInstances().iterator();
            boolean bl = false;
            while (iterator.hasNext()) {
                ModuleInfo moduleInfo = (ModuleInfo)iterator.next();
                if (!moduleInfo.getCodeName().startsWith(this.spy.getModuleId())) continue;
                this.spy.setEnabled(moduleInfo.isEnabled());
                if (this.httpMonitorInfo == null) {
                    this.httpMonitorInfo = moduleInfo;
                    HttpMonitorHelper.monitorInfoListener = new MonitorInfoListener(this.spy);
                    this.httpMonitorInfo.addPropertyChangeListener((PropertyChangeListener)monitorInfoListener);
                }
                bl = true;
                break;
            }
            if (!bl && this.httpMonitorInfo != null) {
                this.httpMonitorInfo.removePropertyChangeListener((PropertyChangeListener)monitorInfoListener);
                this.httpMonitorInfo = null;
                this.spy.setEnabled(false);
            }
        }
    }

    private static class MonitorInfoListener
    implements PropertyChangeListener {
        ModuleSpy spy;

        MonitorInfoListener(ModuleSpy moduleSpy) {
            this.spy = moduleSpy;
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName().equals("enabled")) {
                this.spy.setEnabled((Boolean)propertyChangeEvent.getNewValue());
            }
        }
    }

    private static class ModuleSpy {
        private boolean enabled;
        private String moduleId;

        public ModuleSpy(String string) {
            this.moduleId = string;
        }

        public void setModuleId(String string) {
            this.moduleId = string;
        }

        public void setEnabled(boolean bl) {
            this.enabled = bl;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public String getModuleId() {
            return this.moduleId;
        }
    }
}

