/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.javascript.plugins;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Position;
import org.mozilla.nb.javascript.Node;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.api.lexer.TokenUtilities;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.csl.api.ElementKind;
import org.netbeans.modules.csl.api.Error;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.Severity;
import org.netbeans.modules.csl.spi.GsfUtilities;
import org.netbeans.modules.csl.spi.support.ModificationResult;
import org.netbeans.modules.javascript.editing.AstElement;
import org.netbeans.modules.javascript.editing.AstPath;
import org.netbeans.modules.javascript.editing.AstUtilities;
import org.netbeans.modules.javascript.editing.Element;
import org.netbeans.modules.javascript.editing.JsAnalyzer;
import org.netbeans.modules.javascript.editing.JsParseResult;
import org.netbeans.modules.javascript.editing.JsUtils;
import org.netbeans.modules.javascript.editing.ParseTreeVisitor;
import org.netbeans.modules.javascript.editing.ParseTreeWalker;
import org.netbeans.modules.javascript.editing.VariableVisitor;
import org.netbeans.modules.javascript.editing.lexer.LexUtilities;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.RenameRefactoring;
import org.netbeans.modules.refactoring.javascript.DiffElement;
import org.netbeans.modules.refactoring.javascript.JsElementCtx;
import org.netbeans.modules.refactoring.javascript.RetoucheUtils;
import org.netbeans.modules.refactoring.javascript.plugins.JsRefactoringPlugin;
import org.netbeans.modules.refactoring.javascript.plugins.RetoucheCommit;
import org.netbeans.modules.refactoring.javascript.plugins.SearchVisitor;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.netbeans.modules.refactoring.spi.Transaction;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.PositionRef;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RenameRefactoringPlugin
extends JsRefactoringPlugin {
    private JsElementCtx treePathHandle = null;
    private Collection overriddenByMethods = null;
    private Collection overridesMethods = null;
    private boolean doCheckName = true;
    private RenameRefactoring refactoring;
    private Set<JsElementCtx> allMethods;

    public RenameRefactoringPlugin(RenameRefactoring renameRefactoring) {
        this.refactoring = renameRefactoring;
        JsElementCtx jsElementCtx = (JsElementCtx)renameRefactoring.getRefactoringSource().lookup(JsElementCtx.class);
        if (jsElementCtx != null) {
            this.treePathHandle = jsElementCtx;
        } else {
            Source source = Source.create((FileObject)((FileObject)renameRefactoring.getRefactoringSource().lookup(FileObject.class)));
            try {
                ParserManager.parse(Collections.singleton(source), (UserTask)new UserTask(){

                    public void run(ResultIterator resultIterator) throws Exception {
                        JsAnalyzer.AnalysisResult analysisResult;
                        List list;
                        JsParseResult jsParseResult;
                        Node node;
                        if (resultIterator.getSnapshot().getMimeType().equals("text/javascript") && (node = (jsParseResult = AstUtilities.getParseResult((Parser.Result)resultIterator.getParserResult())).getRootNode()) != null && (list = (analysisResult = jsParseResult.getStructure()).getElements()).size() > 0) {
                            AstElement astElement = (AstElement)list.get(0);
                            Node node2 = astElement.getNode();
                            RenameRefactoringPlugin.this.treePathHandle = new JsElementCtx(node, node2, (Element)astElement, jsParseResult.getSnapshot().getSource().getFileObject(), jsParseResult);
                            RenameRefactoringPlugin.this.refactoring.getContext().add((Object)resultIterator);
                        }
                    }
                });
            }
            catch (ParseException parseException) {
                Logger.getLogger(RenameRefactoringPlugin.class.getName()).log(Level.WARNING, null, parseException);
            }
        }
    }

    public Problem fastCheckParameters() {
        boolean bl;
        Problem problem = null;
        if (this.treePathHandle == null) {
            return null;
        }
        ElementKind elementKind = this.treePathHandle.getKind();
        String string = this.refactoring.getNewName();
        String string2 = this.treePathHandle.getSimpleName();
        if (string2 == null) {
            return new Problem(true, "Cannot determine target name. Please file a bug with detailed information on how to reproduce (preferably including the current source file and the cursor position)");
        }
        if (string2.equals(string) && (bl = true)) {
            problem = RenameRefactoringPlugin.createProblem(problem, true, RenameRefactoringPlugin.getString("ERR_NameNotChanged"));
            return problem;
        }
        if (elementKind == ElementKind.METHOD && !JsUtils.isValidJsMethodName((String)string)) {
            String string3 = RenameRefactoringPlugin.getString("ERR_InvalidMethodName");
            String string4 = new MessageFormat(string3).format(new Object[]{string});
            problem = RenameRefactoringPlugin.createProblem(problem, true, string4);
            return problem;
        }
        if (!JsUtils.isValidJsIdentifier((String)string)) {
            String string5 = RenameRefactoringPlugin.getString("ERR_InvalidIdentifier");
            String string6 = new MessageFormat(string5).format(new Object[]{string});
            problem = RenameRefactoringPlugin.createProblem(problem, true, string6);
            return problem;
        }
        String string7 = JsUtils.getIdentifierWarning((String)string, (int)0);
        if (string7 != null) {
            problem = RenameRefactoringPlugin.createProblem(problem, false, string7);
        }
        return problem;
    }

    public Problem checkParameters() {
        Problem problem = null;
        int n = 0;
        if (this.overriddenByMethods != null) {
            n += this.overriddenByMethods.size();
        }
        if (this.overridesMethods != null) {
            n += this.overridesMethods.size();
        }
        this.fireProgressListenerStart(2, 8 + 3 * n);
        this.fireProgressListenerStep();
        this.fireProgressListenerStep();
        this.fireProgressListenerStop();
        return problem;
    }

    public Problem preCheck() {
        if (this.treePathHandle == null) {
            return null;
        }
        if (!this.treePathHandle.getFileObject().isValid()) {
            return new Problem(true, NbBundle.getMessage(RenameRefactoringPlugin.class, (String)"DSC_ElNotAvail"));
        }
        return null;
    }

    private Set<FileObject> getRelevantFiles() {
        if (this.treePathHandle.getKind() == ElementKind.VARIABLE || this.treePathHandle.getKind() == ElementKind.PARAMETER) {
            return Collections.singleton(this.treePathHandle.getFileObject());
        }
        return RetoucheUtils.getJsFilesInProject(this.treePathHandle.getFileObject(), true);
    }

    public Problem prepare(RefactoringElementsBag refactoringElementsBag) {
        if (this.treePathHandle == null) {
            return null;
        }
        Set<FileObject> set = this.getRelevantFiles();
        this.fireProgressListenerStart(1, set.size());
        if (!set.isEmpty()) {
            JsRefactoringPlugin.TransformTask transformTask = new JsRefactoringPlugin.TransformTask(){

                @Override
                protected Collection<ModificationResult> process(JsParseResult jsParseResult) {
                    RenameTransformer renameTransformer = new RenameTransformer(RenameRefactoringPlugin.this.refactoring.getNewName(), RenameRefactoringPlugin.this.allMethods);
                    renameTransformer.setWorkingCopy(jsParseResult);
                    renameTransformer.scan();
                    if (renameTransformer.diffs.isEmpty()) {
                        return Collections.emptyList();
                    }
                    ModificationResult modificationResult = new ModificationResult();
                    modificationResult.addDifferences(jsParseResult.getSnapshot().getSource().getFileObject(), renameTransformer.diffs);
                    return Collections.singleton(modificationResult);
                }
            };
            Collection<ModificationResult> collection = this.processFiles(set, transformTask);
            refactoringElementsBag.registerTransaction((Transaction)new RetoucheCommit(collection));
            for (ModificationResult modificationResult : collection) {
                for (FileObject fileObject : modificationResult.getModifiedFileObjects()) {
                    for (ModificationResult.Difference difference : modificationResult.getDifferences(fileObject)) {
                        String string = difference.getOldText();
                        if (string == null) continue;
                        refactoringElementsBag.add((AbstractRefactoring)this.refactoring, (RefactoringElementImplementation)DiffElement.create(difference, fileObject, modificationResult));
                    }
                }
            }
        }
        this.fireProgressListenerStop();
        return null;
    }

    private static final String getString(String string) {
        return NbBundle.getMessage(RenameRefactoringPlugin.class, (String)string);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class RenameTransformer
    extends SearchVisitor {
        private final Set<JsElementCtx> allMethods;
        private final String newName;
        private final String oldName;
        private CloneableEditorSupport ces;
        private List<ModificationResult.Difference> diffs;

        @Override
        public void setWorkingCopy(JsParseResult jsParseResult) {
            this.ces = null;
            this.diffs = null;
            super.setWorkingCopy(jsParseResult);
        }

        public RenameTransformer(String string, Set<JsElementCtx> set) {
            this.newName = string;
            this.oldName = RenameRefactoringPlugin.this.treePathHandle.getSimpleName();
            this.allMethods = set;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void scan() {
            Node node;
            AstElement astElement;
            Object object;
            this.diffs = new ArrayList<ModificationResult.Difference>();
            JsElementCtx jsElementCtx = RenameRefactoringPlugin.this.treePathHandle;
            Error error = null;
            Node node2 = this.workingCopy.getRootNode();
            FileObject fileObject = this.workingCopy.getSnapshot().getSource().getFileObject();
            if (node2 != null) {
                object = GsfUtilities.getDocument((FileObject)fileObject, (boolean)true);
                try {
                    Node node3;
                    if (object != null) {
                        object.readLock();
                    }
                    astElement = AstElement.getElement((JsParseResult)this.workingCopy, (Node)node2);
                    node = jsElementCtx.getNode();
                    JsElementCtx jsElementCtx2 = new JsElementCtx(node2, node, (Element)astElement, fileObject, this.workingCopy);
                    Node node4 = null;
                    if (fileObject == jsElementCtx.getFileObject() && (node.getType() == 39 || node.getType() == 49 || node.getType() == 163)) {
                        node3 = node;
                        while (node3.getParentNode() != null) {
                            node3 = node3.getParentNode();
                        }
                        VariableVisitor variableVisitor = new VariableVisitor();
                        new ParseTreeWalker((ParseTreeVisitor)variableVisitor).walk(node3);
                        node4 = variableVisitor.getDefiningScope(node);
                    }
                    if (node4 != null) {
                        this.findLocal(jsElementCtx, jsElementCtx2, node4, this.oldName);
                    }
                    node3 = new AstPath();
                    node3.descend(node2);
                    this.find((AstPath)node3, jsElementCtx, jsElementCtx2, node2, this.oldName);
                    node3.ascend();
                }
                finally {
                    if (object != null) {
                        object.readUnlock();
                    }
                }
            } else {
                object = ((Object)this.workingCopy.getSnapshot().getText()).toString();
                if (((String)object).indexOf(this.oldName) != -1) {
                    Error error2;
                    Object object2;
                    if (this.ces == null) {
                        this.ces = RetoucheUtils.findCloneableEditorSupport(this.workingCopy);
                    }
                    int n = 0;
                    int n2 = 0;
                    String string = NbBundle.getMessage(RenameRefactoringPlugin.class, (String)"ParseErrorFile", (Object)this.oldName);
                    List list = this.workingCopy.getDiagnostics();
                    if (list.size() > 0) {
                        object2 = list.iterator();
                        while (object2.hasNext()) {
                            error2 = (Error)object2.next();
                            if (error2.getSeverity() != Severity.ERROR) continue;
                            error = error2;
                            break;
                        }
                        if (error == null) {
                            error = (Error)list.get(0);
                        }
                        if (((String)(object2 = error.getDisplayName())).length() > 80) {
                            object2 = ((String)object2).substring(0, 77) + "...";
                        }
                        string = string + "; " + (String)object2;
                        n = error.getStartPosition();
                        if ((n = LexUtilities.getLexerOffset((JsParseResult)this.workingCopy, (int)n)) == -1) {
                            n = 0;
                        }
                        n2 = n;
                    }
                    object2 = this.ces.createPositionRef(n, Position.Bias.Forward);
                    error2 = this.ces.createPositionRef(n2, Position.Bias.Forward);
                    ModificationResult.Difference difference = new ModificationResult.Difference(ModificationResult.Difference.Kind.CHANGE, (PositionRef)object2, (PositionRef)error2, "", "", string);
                    this.diffs.add(difference);
                }
            }
            if (error == null && RenameRefactoringPlugin.this.refactoring.isSearchInComments() && (object = RetoucheUtils.getDocument((Parser.Result)this.workingCopy)) != null) {
                astElement = TokenHierarchy.get((Document)object);
                node = astElement.tokenSequence();
                node.move(0);
                this.searchTokenSequence((TokenSequence<?>)node);
            }
            this.ces = null;
        }

        private void searchTokenSequence(TokenSequence<?> tokenSequence) {
            if (tokenSequence.moveNext()) {
                do {
                    CharSequence charSequence;
                    Token token;
                    TokenId tokenId;
                    String string;
                    if ("comment".equals(string = (tokenId = (token = tokenSequence.token()).id()).primaryCategory()) || "block-comment".equals(string)) {
                        int n;
                        charSequence = token.text();
                        if (charSequence == null || this.oldName == null || (n = TokenUtilities.indexOf((CharSequence)charSequence, (CharSequence)this.oldName)) == -1) continue;
                        String string2 = ((Object)charSequence).toString();
                        if (n != 0 && Character.isLetterOrDigit(string2.charAt(n - 1)) || n + this.oldName.length() < string2.length() && Character.isLetterOrDigit(string2.charAt(n + this.oldName.length()))) continue;
                        int n2 = tokenSequence.offset() + n;
                        int n3 = n2 + this.oldName.length();
                        if (this.ces == null) {
                            this.ces = RetoucheUtils.findCloneableEditorSupport(this.workingCopy);
                        }
                        PositionRef positionRef = this.ces.createPositionRef(n2, Position.Bias.Forward);
                        PositionRef positionRef2 = this.ces.createPositionRef(n3, Position.Bias.Forward);
                        String string3 = RenameRefactoringPlugin.getString("ChangeComment");
                        ModificationResult.Difference difference = new ModificationResult.Difference(ModificationResult.Difference.Kind.CHANGE, positionRef, positionRef2, this.oldName, this.newName, string3);
                        this.diffs.add(difference);
                        continue;
                    }
                    charSequence = tokenSequence.embedded();
                    if (charSequence == null) continue;
                    this.searchTokenSequence((TokenSequence<?>)charSequence);
                } while (tokenSequence.moveNext());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void rename(Node node, String string, String string2, String string3) {
            Object object;
            OffsetRange offsetRange = AstUtilities.getNameRange((Node)node);
            assert (offsetRange != OffsetRange.NONE);
            int n = offsetRange.getStart();
            if (string3 == null) {
                switch (node.getType()) {
                    case 165: {
                        if (!AstUtilities.isLabelledFunction((Node)node)) {
                            string3 = NbBundle.getMessage(RenameRefactoringPlugin.class, (String)"UpdateRef", (Object)string);
                            break;
                        }
                    }
                    case 108: 
                    case 164: {
                        string3 = RenameRefactoringPlugin.getString("UpdateMethodDef");
                        break;
                    }
                    case 30: 
                    case 38: {
                        string3 = RenameRefactoringPlugin.getString("UpdateCall");
                        break;
                    }
                    case 39: {
                        if (node.getParentNode() != null && (node.getParentNode().getType() == 38 || node.getParentNode().getType() == 30)) {
                            string3 = RenameRefactoringPlugin.getString("UpdateCall");
                            break;
                        }
                    }
                    case 49: {
                        if (string != null && string.length() > 0 && Character.isUpperCase(string.charAt(0))) {
                            string3 = RenameRefactoringPlugin.getString("UpdateClass");
                            break;
                        }
                        string3 = RenameRefactoringPlugin.getString("UpdateLocalvar");
                        break;
                    }
                    case 163: {
                        string3 = RenameRefactoringPlugin.getString("UpdateParameter");
                        break;
                    }
                    default: {
                        string3 = NbBundle.getMessage(RenameRefactoringPlugin.class, (String)"UpdateRef", (Object)string);
                    }
                }
            }
            if (this.ces == null) {
                this.ces = RetoucheUtils.findCloneableEditorSupport(this.workingCopy);
            }
            if ((n = LexUtilities.getLexerOffset((JsParseResult)this.workingCopy, (int)n)) == -1) {
                return;
            }
            int n2 = n;
            int n3 = n + string.length();
            BaseDocument baseDocument = null;
            try {
                baseDocument = (BaseDocument)this.ces.openDocument();
                baseDocument.readLock();
                if (n2 > baseDocument.getLength()) {
                    n2 = n3 = baseDocument.getLength();
                }
                if (n3 > baseDocument.getLength()) {
                    n3 = baseDocument.getLength();
                }
                if (!string.equals(baseDocument.getText(n2, n3 - n2))) {
                    int n4 = Utilities.getRowFirstNonWhite((BaseDocument)baseDocument, (int)n2);
                    int n5 = Utilities.getRowLastNonWhite((BaseDocument)baseDocument, (int)n2) + 1;
                    if (n4 == -1 || n5 == -1) {
                        FileObject fileObject = this.workingCopy.getSnapshot().getSource().getFileObject();
                        System.out.println("Empty line entry in " + FileUtil.getFileDisplayName((FileObject)fileObject) + "; no match for " + string + " in line " + n2 + " referenced by node " + node + " of type " + node.getClass().getName());
                        return;
                    }
                    if (n4 < 0 || n5 - n4 < 0) {
                        return;
                    }
                    object = baseDocument.getText(n4, n5 - n4);
                    if (((String)object).indexOf(string) == -1) {
                        FileObject fileObject = this.workingCopy.getSnapshot().getSource().getFileObject();
                        System.out.println("Skipping entry in " + FileUtil.getFileDisplayName((FileObject)fileObject) + "; no match for " + string + " in line " + (String)object + " referenced by node " + node + " of type " + node.getClass().getName());
                    } else {
                        int n6 = n2 - n4;
                        int n7 = -1;
                        for (int i = 1; i < ((String)object).length(); ++i) {
                            if (n6 + i + string.length() <= ((String)object).length() && string.equals(((String)object).substring(n6 + i, n6 + i + string.length()))) {
                                n7 = n6 + i;
                                break;
                            }
                            if (n6 - i < 0 || n6 - i + string.length() > ((String)object).length() || !string.equals(((String)object).substring(n6 - i, n6 - i + string.length()))) continue;
                            n7 = n6 - i;
                            break;
                        }
                        if (n7 != -1) {
                            n2 = n7 + n4;
                            n3 = n2 + string.length();
                        }
                    }
                }
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
            catch (BadLocationException badLocationException) {
                Exceptions.printStackTrace((Throwable)badLocationException);
            }
            finally {
                if (baseDocument != null) {
                    baseDocument.readUnlock();
                }
            }
            if (string2 == null) {
                string2 = RenameRefactoringPlugin.this.refactoring.getNewName();
            }
            PositionRef positionRef = this.ces.createPositionRef(n2, Position.Bias.Forward);
            PositionRef positionRef2 = this.ces.createPositionRef(n3, Position.Bias.Forward);
            object = new ModificationResult.Difference(ModificationResult.Difference.Kind.CHANGE, positionRef, positionRef2, string, string2, string3);
            this.diffs.add((ModificationResult.Difference)object);
        }

        private void findLocal(JsElementCtx jsElementCtx, JsElementCtx jsElementCtx2, Node node, String string) {
            switch (node.getType()) {
                case 163: {
                    if (!node.getString().equals(string)) break;
                    this.rename(node, string, null, RenameRefactoringPlugin.getString("RenameParam"));
                    break;
                }
                case 39: {
                    if ((node.getParentNode() != null && node.getParentNode().getType() == 38 || node.getParentNode() != null && node.getParentNode().getType() == 30) && node.getParentNode().getFirstChild() == node) break;
                }
                case 49: {
                    if (!node.getString().equals(string)) break;
                    this.rename(node, string, null, Character.isUpperCase(string.charAt(0)) ? RenameRefactoringPlugin.getString("UpdateClass") : RenameRefactoringPlugin.getString("UpdateLocalvar"));
                }
            }
            if (node.hasChildren()) {
                for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNext()) {
                    this.findLocal(jsElementCtx, jsElementCtx2, node2, string);
                }
            }
        }

        private void find(AstPath astPath, JsElementCtx jsElementCtx, JsElementCtx jsElementCtx2, Node node, String string) {
            switch (node.getType()) {
                case 165: {
                    if (node.getString().equals(string) && AstUtilities.isLabelledFunction((Node)node)) {
                        this.rename(node, string, null, RenameRefactoringPlugin.getString("UpdateMethodDef"));
                    }
                    return;
                }
                case 164: {
                    int n;
                    if (!node.getString().equals(string) || (n = 0) != 0) break;
                    this.rename(node, string, null, RenameRefactoringPlugin.getString("UpdateMethodDef"));
                    return;
                }
                case 30: 
                case 38: {
                    String string2 = AstUtilities.getCallName((Node)node, (boolean)false);
                    if (!string2.equals(string)) break;
                    this.rename(node, string, null, null);
                    return;
                }
                case 39: {
                    if (node.getParentNode().getType() == 38 || node.getParentNode().getType() == 30) break;
                }
                case 41: {
                    int n = node.getParentNode().getType();
                    if (n != 33 && n != 35) break;
                }
                case 49: {
                    if (!node.getString().equals(string)) break;
                    this.rename(node, string, null, null);
                    return;
                }
            }
            if (node.hasChildren()) {
                for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNext()) {
                    this.find(astPath, jsElementCtx, jsElementCtx2, node2, string);
                }
            }
        }
    }
}

