/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.refactoring.support;

import java.util.HashSet;
import java.util.Set;
import java.util.WeakHashMap;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.refactoring.support.CsmRefactoringUtils;
import org.netbeans.modules.cnd.refactoring.support.ElementGrip;
import org.openide.filesystems.FileObject;

public class ElementGripFactory {
    private static ElementGripFactory instance;
    private WeakHashMap<FileObject, Interval> map = new WeakHashMap();

    private ElementGripFactory() {
    }

    public static ElementGripFactory getDefault() {
        if (instance == null) {
            instance = new ElementGripFactory();
        }
        return instance;
    }

    public void cleanUp() {
        this.map.clear();
    }

    public ElementGrip get(FileObject fileObject, int n) {
        Interval interval = this.map.get(fileObject);
        if (interval == null) {
            return null;
        }
        try {
            return interval.get((long)((long)n)).item;
        }
        catch (RuntimeException runtimeException) {
            return interval.item;
        }
    }

    public ElementGrip getParent(ElementGrip elementGrip) {
        Interval interval = this.map.get(elementGrip.getFileObject());
        return interval == null ? null : interval.getParent(elementGrip);
    }

    public ElementGrip putInComposite(FileObject fileObject, CsmOffsetable csmOffsetable) {
        this.put(fileObject, csmOffsetable);
        ElementGrip elementGrip = this.get(fileObject, csmOffsetable.getStartOffset());
        if (elementGrip != null) {
            elementGrip.initParent();
            for (ElementGrip elementGrip2 = elementGrip.getParent(); elementGrip2 != null; elementGrip2 = elementGrip2.getParent()) {
                elementGrip2.initParent();
            }
        }
        return elementGrip;
    }

    public void put(FileObject fileObject, CsmOffsetable csmOffsetable) {
        Interval interval = this.map.get(fileObject);
        Interval interval2 = Interval.createInterval(csmOffsetable, interval, null, fileObject);
        if (interval2 != null) {
            this.map.put(fileObject, interval2);
        }
    }

    private static class Interval {
        long from = -1L;
        long to = -1L;
        Set<Interval> subintervals = new HashSet<Interval>();
        ElementGrip item = null;

        private Interval() {
        }

        Interval get(long l) {
            if (this.from <= l && this.to >= l) {
                for (Interval interval : this.subintervals) {
                    Interval interval2 = interval.get(l);
                    if (interval2 == null) continue;
                    return interval2;
                }
                return this;
            }
            return null;
        }

        ElementGrip getParent(ElementGrip elementGrip) {
            for (Interval interval : this.subintervals) {
                if (interval.item.equals(elementGrip)) {
                    return this.item;
                }
                ElementGrip elementGrip2 = interval.getParent(elementGrip);
                if (elementGrip2 == null) continue;
                return elementGrip2;
            }
            return null;
        }

        public static Interval createInterval(CsmOffsetable csmOffsetable, Interval interval, Interval interval2, FileObject fileObject) {
            Object object;
            long l = csmOffsetable.getStartOffset();
            long l2 = csmOffsetable.getEndOffset();
            CsmObject csmObject = CsmRefactoringUtils.getEnclosingElement((CsmObject)csmOffsetable);
            if (!CsmRefactoringUtils.isLangContainerFeature((CsmObject)csmOffsetable)) {
                if (!CsmKindUtilities.isOffsetable((Object)csmObject)) {
                    return null;
                }
                return Interval.createInterval((CsmOffsetable)csmObject, interval, interval2, fileObject);
            }
            Interval interval3 = null;
            if (interval != null && (object = interval.get(l)) != null && csmOffsetable != null && csmOffsetable.equals(((Interval)object).item.getResolved())) {
                if (interval2 != null) {
                    ((Interval)object).subintervals.add(interval2);
                }
                return null;
            }
            if (interval3 == null) {
                interval3 = new Interval();
            }
            if (interval3.from != l) {
                interval3.from = l;
                interval3.to = l2;
                interval3.item = object = new ElementGrip(csmOffsetable);
            }
            if (interval2 != null) {
                interval3.subintervals.add(interval2);
            }
            if (!CsmKindUtilities.isOffsetable((Object)csmObject)) {
                return interval3;
            }
            return Interval.createInterval((CsmOffsetable)csmObject, interval, interval3, fileObject);
        }

        public String toString() {
            return "" + this.from + "-" + this.to + " :" + this.item;
        }
    }
}

