/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.refactoring.rename;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.netbeans.modules.j2ee.core.api.support.java.JavaIdentifiers;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.MoveRefactoring;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.refactoring.RefactoringUtil;
import org.netbeans.modules.web.refactoring.rename.BaseTldRename;
import org.netbeans.modules.web.refactoring.rename.RenameItem;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TldFolderMove
extends BaseTldRename {
    private final MoveRefactoring move;
    private final FileObject folder;

    public TldFolderMove(WebModule webModule, FileObject fileObject, MoveRefactoring moveRefactoring) {
        super(webModule);
        this.folder = fileObject;
        this.move = moveRefactoring;
    }

    @Override
    protected List<RenameItem> getAffectedClasses() {
        ArrayList<RenameItem> arrayList = new ArrayList<RenameItem>();
        ArrayList<FileObject> arrayList2 = new ArrayList<FileObject>();
        RefactoringUtil.collectChildren(this.folder, arrayList2);
        for (FileObject fileObject : arrayList2) {
            if (RefactoringUtil.isPackageInfo(fileObject)) continue;
            String string = JavaIdentifiers.getQualifiedName((FileObject)fileObject);
            String string2 = this.getTargetPackageName(fileObject.getParent());
            String string3 = JavaIdentifiers.unqualify((String)string);
            String string4 = string2.length() == 0 ? string3 : string2 + "." + string3;
            arrayList.add(new RenameItem(string4, string));
        }
        return arrayList;
    }

    private String getTargetPackageName(FileObject fileObject) {
        String string = RefactoringUtil.getPackageName((URL)this.move.getTarget().lookup(URL.class));
        String string2 = FileUtil.getRelativePath((FileObject)this.folder.getParent(), (FileObject)fileObject).replace('/', '.');
        if (string.length() == 0) {
            return string2;
        }
        if (string2.length() == 0) {
            return string;
        }
        return string + "." + string2;
    }

    @Override
    protected AbstractRefactoring getRefactoring() {
        return this.move;
    }
}

