/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.editor.completion;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.editor.completion.Completion;
import org.netbeans.api.html.lexer.HTMLTokenId;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.html.editor.api.completion.HtmlCompletionItem;
import org.netbeans.spi.editor.completion.CompletionItem;
import org.netbeans.spi.editor.completion.CompletionProvider;
import org.netbeans.spi.editor.completion.CompletionResultSet;
import org.netbeans.spi.editor.completion.CompletionTask;
import org.netbeans.spi.editor.completion.support.AsyncCompletionQuery;
import org.netbeans.spi.editor.completion.support.AsyncCompletionTask;
import org.netbeans.spi.editor.completion.support.CompletionUtilities;
import org.netbeans.spi.palette.PaletteController;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.windows.TopComponent;

public class HtmlPaletteCompletionProvider
implements CompletionProvider {
    public CompletionTask createTask(int n, JTextComponent jTextComponent) {
        if ((n & 1 & 9) != 0) {
            return new AsyncCompletionTask((AsyncCompletionQuery)new CCQuery(jTextComponent.getCaret().getDot()), jTextComponent);
        }
        return null;
    }

    public int getAutoQueryTypes(JTextComponent jTextComponent, String string) {
        return 0;
    }

    private static boolean startsWithIgnoreCase(String string, String string2) {
        return string.toLowerCase(Locale.ENGLISH).startsWith(string2.toLowerCase(Locale.ENGLISH));
    }

    private static class PaletteCompletionItem
    implements CompletionItem {
        protected Action action;
        protected String category;
        protected String item;
        protected Image icon;
        protected int completionExpressionStartOffset;

        public PaletteCompletionItem(Action action, int n, String string, String string2, Image image) {
            this.action = action;
            this.category = string;
            this.item = string2;
            this.icon = image;
            this.completionExpressionStartOffset = n;
        }

        public String getItemName() {
            return this.item;
        }

        public String getLeftHtmlText() {
            return this.getItemName();
        }

        public String getRightHtmlText() {
            return "<font color='" + HtmlCompletionItem.hexColorCode(Color.GRAY) + "'>" + this.category + "</font>";
        }

        public ImageIcon getIcon() {
            return new ImageIcon(this.icon);
        }

        public void defaultAction(JTextComponent jTextComponent) {
            try {
                Document document = jTextComponent.getDocument();
                int n = jTextComponent.getCaretPosition();
                document.remove(this.completionExpressionStartOffset, n - this.completionExpressionStartOffset);
                Completion.get().hideAll();
                this.action.actionPerformed(null);
            }
            catch (BadLocationException badLocationException) {
                Exceptions.printStackTrace((Throwable)badLocationException);
            }
        }

        public int getPreferredWidth(Graphics graphics, Font font) {
            return CompletionUtilities.getPreferredWidth((String)this.getLeftHtmlText(), (String)this.getRightHtmlText(), (Graphics)graphics, (Font)font);
        }

        public void render(Graphics graphics, Font font, Color color, Color color2, int n, int n2, boolean bl) {
            CompletionUtilities.renderHtml((ImageIcon)this.getIcon(), (String)this.getLeftHtmlText(), (String)this.getRightHtmlText(), (Graphics)graphics, (Font)font, (Color)color, (int)n, (int)n2, (boolean)bl);
        }

        public void processKeyEvent(KeyEvent keyEvent) {
        }

        public CompletionTask createDocumentationTask() {
            return null;
        }

        public CompletionTask createToolTipTask() {
            return null;
        }

        public boolean instantSubstitution(JTextComponent jTextComponent) {
            return false;
        }

        public int getSortPriority() {
            return 1;
        }

        public CharSequence getSortText() {
            return this.category + this.item;
        }

        public CharSequence getInsertPrefix() {
            return this.getSortText();
        }
    }

    static final class CCQuery
    extends AsyncCompletionQuery {
        private int creationCaretOffset;
        private int completionExpressionStartOffset;
        private JTextComponent component;
        private final Collection<PaletteCompletionItem> items = new ArrayList<PaletteCompletionItem>();

        CCQuery(int n) {
            this.creationCaretOffset = n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void query(final CompletionResultSet completionResultSet, final Document document, final int n) {
            try {
                Collection<PaletteCompletionItem> collection = this.items;
                synchronized (collection) {
                    document.render(new Runnable(){

                        public void run() {
                            int n3;
                            Object object;
                            CCQuery.this.items.clear();
                            TokenSequence tokenSequence = CCQuery.this.getTokenSequence(document, n);
                            if (tokenSequence == null) {
                                return;
                            }
                            int n2 = tokenSequence.move(n);
                            if (!tokenSequence.moveNext()) {
                                return;
                            }
                            Token token = tokenSequence.token();
                            if (token.id() != HTMLTokenId.TEXT) {
                                return;
                            }
                            if (n2 == 0 && tokenSequence.movePrevious() && ((object = tokenSequence.token().id()) == HTMLTokenId.TAG_CLOSE_SYMBOL || object == HTMLTokenId.TAG_OPEN_SYMBOL || object == HTMLTokenId.CHARACTER)) {
                                return;
                            }
                            object = ((Object)token.text().subSequence(0, n2)).toString();
                            for (n3 = ((String)object).length() - 1; n3 >= 0; --n3) {
                                char c = ((String)object).charAt(n3);
                                if (!Character.isWhitespace(c)) continue;
                                ++n3;
                                break;
                            }
                            if (n3 > 0) {
                                object = ((String)object).substring(n3, ((String)object).length());
                            }
                            CCQuery.this.completionExpressionStartOffset = CCQuery.this.creationCaretOffset - ((String)object).length();
                            TopComponent topComponent = NbEditorUtilities.getTopComponent((JTextComponent)CCQuery.this.component);
                            if (topComponent == null) {
                                return;
                            }
                            PaletteController paletteController = (PaletteController)topComponent.getLookup().lookup(PaletteController.class);
                            if (paletteController != null) {
                                Node node = (Node)paletteController.getRoot().lookup(Node.class);
                                Children children = node.getChildren();
                                for (Node node2 : children.getNodes()) {
                                    for (Node node3 : node2.getChildren().getNodes()) {
                                        Action action = node3.getPreferredAction();
                                        String string = node3.getDisplayName();
                                        if (!HtmlPaletteCompletionProvider.startsWithIgnoreCase(string, (String)object)) continue;
                                        CCQuery.this.items.add(new PaletteCompletionItem(action, CCQuery.this.completionExpressionStartOffset, node2.getDisplayName(), string, node3.getIcon(1)));
                                    }
                                }
                            }
                            completionResultSet.addAllItems(CCQuery.this.items);
                        }
                    });
                }
            }
            finally {
                completionResultSet.finish();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected boolean canFilter(final JTextComponent jTextComponent) {
            Collection<PaletteCompletionItem> collection = this.items;
            synchronized (collection) {
                final Document document = jTextComponent.getDocument();
                final AtomicBoolean atomicBoolean = new AtomicBoolean();
                document.render(new Runnable(){

                    public void run() {
                        try {
                            int n = jTextComponent.getCaretPosition();
                            if (n < CCQuery.this.completionExpressionStartOffset) {
                                atomicBoolean.set(false);
                                return;
                            }
                            String string = document.getText(CCQuery.this.completionExpressionStartOffset, n - CCQuery.this.completionExpressionStartOffset);
                            for (PaletteCompletionItem paletteCompletionItem : CCQuery.this.items) {
                                if (!HtmlPaletteCompletionProvider.startsWithIgnoreCase(paletteCompletionItem.getItemName(), string)) continue;
                                atomicBoolean.set(true);
                                return;
                            }
                        }
                        catch (BadLocationException badLocationException) {
                            Exceptions.printStackTrace((Throwable)badLocationException);
                        }
                    }
                });
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void filter(final CompletionResultSet completionResultSet) {
            try {
                Collection<PaletteCompletionItem> collection = this.items;
                synchronized (collection) {
                    final Document document = this.component.getDocument();
                    document.render(new Runnable(){

                        public void run() {
                            try {
                                int n = CCQuery.this.component.getCaretPosition();
                                String string = document.getText(CCQuery.this.completionExpressionStartOffset, n - CCQuery.this.completionExpressionStartOffset);
                                for (PaletteCompletionItem paletteCompletionItem : CCQuery.this.items) {
                                    if (!HtmlPaletteCompletionProvider.startsWithIgnoreCase(paletteCompletionItem.getItemName(), string)) continue;
                                    completionResultSet.addItem((CompletionItem)paletteCompletionItem);
                                }
                            }
                            catch (BadLocationException badLocationException) {
                                Exceptions.printStackTrace((Throwable)badLocationException);
                            }
                        }
                    });
                }
            }
            finally {
                completionResultSet.finish();
            }
        }

        protected void prepareQuery(JTextComponent jTextComponent) {
            this.component = jTextComponent;
        }

        private TokenSequence getTokenSequence(Document document, int n) {
            TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)document);
            List list = tokenHierarchy.embeddedTokenSequences(n, true);
            TokenSequence tokenSequence = null;
            for (TokenSequence tokenSequence2 : list) {
                if (!tokenSequence2.language().mimeType().equals("text/html")) continue;
                tokenSequence = tokenSequence2;
                break;
            }
            return tokenSequence;
        }
    }
}

