/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.editor.completion;

import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import javax.swing.Action;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.editor.completion.Completion;
import org.netbeans.api.html.lexer.HTMLTokenId;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.lib.editor.util.CharSequenceUtilities;
import org.netbeans.modules.html.editor.api.Utils;
import org.netbeans.modules.html.editor.api.completion.HtmlCompletionItem;
import org.netbeans.modules.html.editor.completion.HtmlCompletionQuery;
import org.netbeans.modules.html.editor.javadoc.HelpManager;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.spi.editor.completion.CompletionDocumentation;
import org.netbeans.spi.editor.completion.CompletionItem;
import org.netbeans.spi.editor.completion.CompletionProvider;
import org.netbeans.spi.editor.completion.CompletionResultSet;
import org.netbeans.spi.editor.completion.CompletionTask;
import org.netbeans.spi.editor.completion.support.AsyncCompletionQuery;
import org.netbeans.spi.editor.completion.support.AsyncCompletionTask;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class HtmlCompletionProvider
implements CompletionProvider {
    public int getAutoQueryTypes(JTextComponent jTextComponent, String string) {
        int n;
        Document document = jTextComponent.getDocument();
        boolean bl = HtmlCompletionProvider.checkOpenCompletion(document, n = jTextComponent.getCaret().getDot(), string);
        return bl ? 3 : 0;
    }

    public CompletionTask createTask(int n, JTextComponent jTextComponent) {
        AsyncCompletionTask asyncCompletionTask = null;
        if ((n & 1 & 9) != 0) {
            asyncCompletionTask = new AsyncCompletionTask((AsyncCompletionQuery)new Query(), jTextComponent);
        } else if (n == 2) {
            asyncCompletionTask = new AsyncCompletionTask((AsyncCompletionQuery)new DocQuery(null), jTextComponent);
        }
        return asyncCompletionTask;
    }

    private static void checkHideCompletion(final BaseDocument baseDocument, final int n) {
        baseDocument.render(new Runnable(){

            public void run() {
                TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)baseDocument);
                TokenSequence tokenSequence = tokenHierarchy.tokenSequence();
                tokenSequence.move(n == 0 ? 0 : n - 1);
                if (!tokenSequence.moveNext()) {
                    return;
                }
                Token token = tokenSequence.token();
                if (token.id() == HTMLTokenId.TEXT && !((Object)token.text()).toString().startsWith("<") && !((Object)token.text()).toString().startsWith("&")) {
                    HtmlCompletionProvider.hideCompletion();
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean checkOpenCompletion(Document document, final int n, String string) {
        final BaseDocument baseDocument = (BaseDocument)document;
        switch (string.charAt(string.length() - 1)) {
            case '/': {
                if (n < 2) break;
                try {
                    String string2 = baseDocument.getText(n - 2, 2);
                    if (string2.equals("</")) {
                        return true;
                    }
                }
                catch (BadLocationException badLocationException) {}
                break;
            }
            case ' ': {
                baseDocument.readLock();
                try {
                    TokenSequence<HTMLTokenId> tokenSequence = Utils.getJoinedHtmlSequence((Document)baseDocument, n);
                    if (tokenSequence == null) {
                        boolean bl = false;
                        return bl;
                    }
                    tokenSequence.move(n - 1);
                    if ((tokenSequence.moveNext() || tokenSequence.movePrevious()) && tokenSequence.token().id() == HTMLTokenId.WS) {
                        boolean bl = true;
                        return bl;
                    }
                    break;
                }
                finally {
                    baseDocument.readUnlock();
                }
            }
            case '&': 
            case '<': {
                return true;
            }
            case '>': {
                final boolean[] blArray = new boolean[1];
                baseDocument.runAtomic(new Runnable(){

                    public void run() {
                        TokenSequence<HTMLTokenId> tokenSequence = Utils.getJoinedHtmlSequence((Document)baseDocument, n);
                        if (tokenSequence == null) {
                            blArray[0] = false;
                        } else {
                            tokenSequence.move(n - 1);
                            if ((tokenSequence.moveNext() || tokenSequence.movePrevious()) && tokenSequence.token().id() == HTMLTokenId.TAG_CLOSE_SYMBOL && !CharSequenceUtilities.equals((CharSequence)"/>", (Object)tokenSequence.token().text())) {
                                blArray[0] = true;
                            }
                        }
                    }
                });
                return blArray[0];
            }
        }
        return false;
    }

    private static void hideCompletion() {
        Completion.get().hideCompletion();
        Completion.get().hideDocumentation();
    }

    private static class DocItem
    implements CompletionDocumentation {
        HtmlCompletionItem item;

        public DocItem(HtmlCompletionItem htmlCompletionItem) {
            this.item = htmlCompletionItem;
        }

        public String getText() {
            return this.item.getHelp();
        }

        public URL getURL() {
            return this.item.getHelpURL();
        }

        public CompletionDocumentation resolveLink(String string) {
            URL uRL = HelpManager.getDefault().getHelpURL(this.item.getHelpId());
            return uRL != null ? new LinkDocItem(HelpManager.getDefault().getRelativeURL(uRL, string)) : new NoDocItem();
        }

        public Action getGotoSourceAction() {
            return null;
        }
    }

    private static class NoDocItem
    implements CompletionDocumentation {
        private NoDocItem() {
        }

        public String getText() {
            return NbBundle.getMessage(HtmlCompletionProvider.class, (String)"MSG_No_Doc_For_Target");
        }

        public URL getURL() {
            return null;
        }

        public CompletionDocumentation resolveLink(String string) {
            return null;
        }

        public Action getGotoSourceAction() {
            return null;
        }
    }

    private static class LinkDocItem
    implements CompletionDocumentation {
        private URL url;

        public LinkDocItem(URL uRL) {
            this.url = uRL;
        }

        public String getText() {
            return null;
        }

        public URL getURL() {
            return this.url;
        }

        public CompletionDocumentation resolveLink(String string) {
            return new LinkDocItem(HelpManager.getDefault().getRelativeURL(this.url, string));
        }

        public Action getGotoSourceAction() {
            return null;
        }
    }

    private static abstract class AbstractQuery
    extends AsyncCompletionQuery {
        private AbstractQuery() {
        }

        protected void preQueryUpdate(JTextComponent jTextComponent) {
            HtmlCompletionProvider.checkHideCompletion((BaseDocument)jTextComponent.getDocument(), jTextComponent.getCaretPosition());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void query(CompletionResultSet completionResultSet, Document document, int n) {
            try {
                this.doQuery(completionResultSet, document, n);
            }
            finally {
                completionResultSet.finish();
            }
        }

        abstract void doQuery(CompletionResultSet var1, Document var2, int var3);
    }

    public static class DocQuery
    extends AbstractQuery {
        private CompletionItem item;

        public DocQuery(HtmlCompletionItem htmlCompletionItem) {
            this.item = htmlCompletionItem;
        }

        protected void doQuery(CompletionResultSet completionResultSet, Document document, int n) {
            Object object;
            if (this.item == null) {
                try {
                    object = new HtmlCompletionQuery(document, n).query();
                    if (object != null && ((HtmlCompletionQuery.CompletionResult)object).getItems().size() > 0) {
                        this.item = ((HtmlCompletionQuery.CompletionResult)object).getItems().iterator().next();
                    }
                }
                catch (ParseException parseException) {
                    Exceptions.printStackTrace((Throwable)parseException);
                }
            }
            if ((object = (HtmlCompletionItem)this.item) != null && ((HtmlCompletionItem)object).getHelp() != null) {
                completionResultSet.setDocumentation((CompletionDocumentation)new DocItem((HtmlCompletionItem)object));
            }
        }
    }

    private static class Query
    extends AbstractQuery {
        private int anchor;
        private volatile Collection<? extends CompletionItem> items = Collections.emptyList();
        private JTextComponent component;

        private Query() {
        }

        protected void prepareQuery(JTextComponent jTextComponent) {
            this.component = jTextComponent;
        }

        protected void doQuery(CompletionResultSet completionResultSet, Document document, int n) {
            try {
                HtmlCompletionQuery.CompletionResult completionResult = new HtmlCompletionQuery(document, n).query();
                if (completionResult != null) {
                    this.items = completionResult.getItems();
                    this.anchor = completionResult.getAnchor();
                } else {
                    this.items = Collections.emptyList();
                    this.anchor = 0;
                }
                completionResultSet.addAllItems(this.items);
                completionResultSet.setAnchorOffset(this.anchor);
            }
            catch (ParseException parseException) {
                Exceptions.printStackTrace((Throwable)parseException);
            }
        }

        protected boolean canFilter(JTextComponent jTextComponent) {
            try {
                Document document = jTextComponent.getDocument();
                int n = jTextComponent.getCaretPosition();
                if (n < this.anchor) {
                    return false;
                }
                String string = document.getText(this.anchor, n - this.anchor);
                for (CompletionItem completionItem : this.items) {
                    if (!(completionItem instanceof HtmlCompletionItem) || !Query.startsWithIgnoreCase(((HtmlCompletionItem)completionItem).getItemText(), string)) continue;
                    return true;
                }
            }
            catch (BadLocationException badLocationException) {
                Exceptions.printStackTrace((Throwable)badLocationException);
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void filter(CompletionResultSet completionResultSet) {
            try {
                Document document = this.component.getDocument();
                int n = this.component.getCaretPosition();
                String string = document.getText(this.anchor, n - this.anchor);
                for (CompletionItem completionItem : this.items) {
                    if (!(completionItem instanceof HtmlCompletionItem) || !Query.startsWithIgnoreCase(((HtmlCompletionItem)completionItem).getItemText(), string)) continue;
                    completionResultSet.addItem(completionItem);
                }
            }
            catch (BadLocationException badLocationException) {
                Exceptions.printStackTrace((Throwable)badLocationException);
            }
            finally {
                completionResultSet.setAnchorOffset(this.anchor);
                completionResultSet.finish();
            }
        }

        private static boolean startsWithIgnoreCase(String string, String string2) {
            return string.toLowerCase(Locale.ENGLISH).startsWith(string2.toLowerCase(Locale.ENGLISH));
        }
    }
}

