/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.jaxb.model;

import java.util.ArrayList;
import java.util.List;
import org.netbeans.api.project.Project;
import org.netbeans.modules.xml.jaxb.api.model.JAXBWizModel;
import org.netbeans.modules.xml.jaxb.api.model.events.JAXBWizEvent;
import org.netbeans.modules.xml.jaxb.api.model.events.JAXBWizEventListener;
import org.netbeans.modules.xml.jaxb.cfg.schema.Schema;
import org.netbeans.modules.xml.jaxb.cfg.schema.Schemas;
import org.netbeans.modules.xml.jaxb.model.events.JAXBWizEventImpl;
import org.netbeans.modules.xml.jaxb.util.ProjectHelper;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

public class JAXBWizModelImpl
implements JAXBWizModel {
    private List<JAXBWizEventListener> listeners = null;
    private Project project;
    private boolean swallowCfgFileEditEvent = false;

    public JAXBWizModelImpl(Project project) {
        this.project = project;
    }

    public synchronized void addJAXBWizEventListener(JAXBWizEventListener jAXBWizEventListener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList<JAXBWizEventListener>();
        }
        this.listeners.add(jAXBWizEventListener);
    }

    public synchronized void removeJAXBWizEventListener(JAXBWizEventListener jAXBWizEventListener) {
        if (this.listeners != null) {
            this.listeners.remove(jAXBWizEventListener);
        }
    }

    public void fireSchemaAddedEvent(Schemas schemas, Schema schema) {
        JAXBWizEventImpl jAXBWizEventImpl = new JAXBWizEventImpl(schemas, null, schema, JAXBWizEvent.JAXBWizEventType.EVENT_BINDING_ADDED);
        this.dispatchEvent(jAXBWizEventImpl);
    }

    public void fireSchemaChangedEvent(Schemas schemas, Schema schema, Schema schema2) {
        JAXBWizEventImpl jAXBWizEventImpl = new JAXBWizEventImpl(schemas, schema, schema2, JAXBWizEvent.JAXBWizEventType.EVENT_BINDING_CHANGED);
        this.dispatchEvent(jAXBWizEventImpl);
    }

    public void fireSchemaDeletedEvent(Schemas schemas, Schema schema) {
        JAXBWizEventImpl jAXBWizEventImpl = new JAXBWizEventImpl(schemas, schema, null, JAXBWizEvent.JAXBWizEventType.EVENT_BINDING_DELETED);
        this.dispatchEvent(jAXBWizEventImpl);
    }

    public void fireCfgFileEditedEvent(Schemas schemas) {
        JAXBWizEventImpl jAXBWizEventImpl = new JAXBWizEventImpl(schemas, null, null, JAXBWizEvent.JAXBWizEventType.EVENT_CFG_FILE_EDITED);
        this.dispatchEvent(jAXBWizEventImpl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispatchEvent(JAXBWizEvent jAXBWizEvent) {
        ArrayList<JAXBWizEventListener> arrayList = new ArrayList<JAXBWizEventListener>();
        Object object = this;
        synchronized (object) {
            if (this.listeners != null) {
                arrayList.addAll(this.listeners);
            }
        }
        object = jAXBWizEvent.getEventType();
        for (JAXBWizEventListener jAXBWizEventListener : arrayList) {
            try {
                switch (1.$SwitchMap$org$netbeans$modules$xml$jaxb$api$model$events$JAXBWizEvent$JAXBWizEventType[((Enum)object).ordinal()]) {
                    case 1: {
                        jAXBWizEventListener.bindingAdded(jAXBWizEvent);
                        break;
                    }
                    case 2: {
                        jAXBWizEventListener.bindingChanged(jAXBWizEvent);
                        break;
                    }
                    case 3: {
                        jAXBWizEventListener.bindingDeleted(jAXBWizEvent);
                        break;
                    }
                    case 4: {
                        jAXBWizEventListener.configFileEdited(jAXBWizEvent);
                    }
                }
            }
            catch (Exception exception) {
                Exceptions.printStackTrace((Throwable)exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSchema(Schema schema) {
        JAXBWizModelImpl jAXBWizModelImpl;
        Schemas schemas = ProjectHelper.getXMLBindingSchemas(this.project);
        try {
            jAXBWizModelImpl = this;
            synchronized (jAXBWizModelImpl) {
                this.swallowCfgFileEditEvent = true;
            }
            ProjectHelper.addSchema(this.project, schemas, schema);
            this.fireSchemaAddedEvent(schemas, schema);
        }
        finally {
            jAXBWizModelImpl = this;
            synchronized (jAXBWizModelImpl) {
                this.swallowCfgFileEditEvent = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeSchema(Schema schema, Schema schema2) {
        JAXBWizModelImpl jAXBWizModelImpl;
        Schemas schemas = ProjectHelper.getXMLBindingSchemas(this.project);
        try {
            jAXBWizModelImpl = this;
            synchronized (jAXBWizModelImpl) {
                this.swallowCfgFileEditEvent = true;
            }
            ProjectHelper.removeSchema(this.project, schemas, schema);
            ProjectHelper.addSchema(this.project, schemas, schema2);
            this.fireSchemaChangedEvent(schemas, schema, schema2);
        }
        finally {
            jAXBWizModelImpl = this;
            synchronized (jAXBWizModelImpl) {
                this.swallowCfgFileEditEvent = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteSchema(Schema schema) {
        JAXBWizModelImpl jAXBWizModelImpl;
        Schemas schemas = ProjectHelper.getXMLBindingSchemas(this.project);
        try {
            jAXBWizModelImpl = this;
            synchronized (jAXBWizModelImpl) {
                this.swallowCfgFileEditEvent = true;
            }
            ProjectHelper.removeSchema(this.project, schemas, schema);
            this.fireSchemaDeletedEvent(schemas, schema);
        }
        finally {
            jAXBWizModelImpl = this;
            synchronized (jAXBWizModelImpl) {
                this.swallowCfgFileEditEvent = false;
            }
        }
    }

    static class 1 {
        static final /* synthetic */ int[] $SwitchMap$org$netbeans$modules$xml$jaxb$api$model$events$JAXBWizEvent$JAXBWizEventType;

        static {
            $SwitchMap$org$netbeans$modules$xml$jaxb$api$model$events$JAXBWizEvent$JAXBWizEventType = new int[JAXBWizEvent.JAXBWizEventType.values().length];
            try {
                1.$SwitchMap$org$netbeans$modules$xml$jaxb$api$model$events$JAXBWizEvent$JAXBWizEventType[JAXBWizEvent.JAXBWizEventType.EVENT_BINDING_ADDED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$org$netbeans$modules$xml$jaxb$api$model$events$JAXBWizEvent$JAXBWizEventType[JAXBWizEvent.JAXBWizEventType.EVENT_BINDING_CHANGED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$org$netbeans$modules$xml$jaxb$api$model$events$JAXBWizEvent$JAXBWizEventType[JAXBWizEvent.JAXBWizEventType.EVENT_BINDING_DELETED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$org$netbeans$modules$xml$jaxb$api$model$events$JAXBWizEvent$JAXBWizEventType[JAXBWizEvent.JAXBWizEventType.EVENT_CFG_FILE_EDITED.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
        }
    }

    private final class JaxbCfgChangeListener
    extends FileChangeAdapter {
        private JaxbCfgChangeListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void refreshNodes() {
            boolean bl = false;
            Object object = JAXBWizModelImpl.this;
            synchronized (object) {
                bl = JAXBWizModelImpl.this.swallowCfgFileEditEvent;
            }
            if (!bl) {
                object = ProjectHelper.getXMLBindingSchemas(JAXBWizModelImpl.this.project);
                JAXBWizModelImpl.this.fireCfgFileEditedEvent((Schemas)object);
            }
        }

        public void fileChanged(FileEvent fileEvent) {
            this.refreshNodes();
        }

        public void fileRenamed(FileEvent fileEvent) {
            this.refreshNodes();
        }

        public void fileDataCreated(FileEvent fileEvent) {
            FileObject fileObject = ProjectHelper.getFOForBindingConfigFile(JAXBWizModelImpl.this.project);
            if (fileObject != null && fileObject.isValid()) {
                this.refreshNodes();
            }
        }

        public void fileDeleted(FileEvent fileEvent) {
            this.refreshNodes();
        }
    }
}

