/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.api.utils;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.cnd.api.utils.IpeUtils;
import org.netbeans.modules.cnd.utils.MIMEExtensions;
import org.netbeans.spi.queries.VisibilityQueryImplementation2;
import org.openide.filesystems.FileObject;
import org.openide.util.ChangeSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CndFileVisibilityQuery
implements VisibilityQueryImplementation2,
ChangeListener {
    private final ChangeSupport cs = new ChangeSupport((Object)this);
    private static CndFileVisibilityQuery INSTANCE = new CndFileVisibilityQuery();
    private Pattern acceptedFilesPattern = null;
    private static final String DEFAULT_IGNORE_BYNARY_PATTERN = ".*\\.(o|so|a|dll|dylib|lib|lo|la|Po|Plo)$";
    private Pattern ignoredFilesPattern = Pattern.compile(".*\\.(o|so|a|dll|dylib|lib|lo|la|Po|Plo)$");

    private CndFileVisibilityQuery() {
        MIMEExtensions.get((String)"text/x-c").addChangeListener((ChangeListener)this);
        MIMEExtensions.get((String)"text/x-c++").addChangeListener((ChangeListener)this);
        MIMEExtensions.get((String)"text/x-h").addChangeListener((ChangeListener)this);
    }

    public static CndFileVisibilityQuery getDefault() {
        return INSTANCE;
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        this.acceptedFilesPattern = null;
        this.cs.fireChange();
    }

    public boolean isVisible(FileObject fileObject) {
        return this.isVisible(fileObject.getNameExt());
    }

    public boolean isVisible(File file) {
        return this.isVisible(file.getName());
    }

    boolean isVisible(String string) {
        Pattern pattern = this.getAcceptedFilesPattern();
        return pattern != null ? pattern.matcher(string).find() : true;
    }

    public boolean isIgnored(File file) {
        return this.isIgnored(file.getName());
    }

    public boolean isIgnored(String string) {
        return this.ignoredFilesPattern.matcher(string).find();
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.cs.addChangeListener(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.cs.removeChangeListener(changeListener);
    }

    private static Set<String> createExtensionSet() {
        if (IpeUtils.isSystemCaseInsensitive()) {
            return new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        }
        return new TreeSet<String>();
    }

    private List<Collection<String>> getAcceptedFilesExtensions() {
        ArrayList<Collection<String>> arrayList = new ArrayList<Collection<String>>();
        arrayList.add(MIMEExtensions.get((String)"text/x-c").getValues());
        arrayList.add(MIMEExtensions.get((String)"text/x-c++").getValues());
        arrayList.add(MIMEExtensions.get((String)"text/x-h").getValues());
        return arrayList;
    }

    private Pattern getAcceptedFilesPattern() {
        if (this.acceptedFilesPattern == null) {
            List<Collection<String>> list = this.getAcceptedFilesExtensions();
            StringBuilder stringBuilder = new StringBuilder();
            for (Collection<String> collection : list) {
                for (String string : collection) {
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append('|');
                    }
                    if (string.indexOf(43) >= 0) {
                        string = string.replace("+", "\\+");
                    }
                    stringBuilder.append(string);
                }
                String string = ".*\\.(" + stringBuilder.toString() + ")$";
                this.acceptedFilesPattern = Pattern.compile(string);
            }
        }
        return this.acceptedFilesPattern;
    }
}

