/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.api.execution;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.ResourceBundle;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cnd.api.execution.ExecutionListener;
import org.netbeans.modules.cnd.api.execution.LinkSupport;
import org.netbeans.modules.cnd.api.execution.NativeExecution;
import org.netbeans.modules.cnd.api.remote.HostInfoProvider;
import org.netbeans.modules.cnd.execution.OutputWindowWriter;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironmentFactory;
import org.netbeans.modules.nativeexecution.api.util.MacroMap;
import org.netbeans.modules.nativeexecution.api.util.UnbufferSupport;
import org.openide.ErrorManager;
import org.openide.awt.StatusDisplayer;
import org.openide.execution.ExecutionEngine;
import org.openide.execution.ExecutorTask;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.windows.IOProvider;
import org.openide.windows.InputOutput;
import org.openide.windows.OutputListener;
import org.openide.windows.OutputWriter;

@Deprecated
public class NativeExecutor
implements Runnable {
    private final ArrayList<ExecutionListener> listeners = new ArrayList();
    private final String runDir;
    private final String executable;
    private final String arguments;
    private final String[] envp;
    private final String tabName;
    private final String actionName;
    private final boolean parseOutputForErrors;
    private final boolean showInput;
    private final ExecutionEnvironment execEnv;
    private final boolean unbuffer;
    private boolean x11forwarding = false;
    private final File runDirFile;
    private String rcfile;
    private volatile NativeExecution nativeExecution;
    private static final boolean showHeader = Boolean.getBoolean("cnd.execution.showheader");
    private InputOutput io;
    private PrintWriter out;
    private PrintWriter err;
    private Writer outputListener;
    private Project project;
    private static ResourceBundle bundle = null;

    public NativeExecutor(Project project, ExecutionEnvironment executionEnvironment, String string, String string2, String string3, String[] stringArray, String string4, String string5, boolean bl, boolean bl2, boolean bl3) {
        this.project = project;
        this.execEnv = executionEnvironment;
        this.runDir = string;
        this.executable = string2 = LinkSupport.resolveWindowsLink(string2);
        this.arguments = string3;
        this.envp = stringArray;
        this.tabName = string4;
        this.actionName = string5;
        this.parseOutputForErrors = bl;
        this.showInput = bl2;
        this.unbuffer = bl3;
        this.runDirFile = new File(string);
    }

    public NativeExecutor(ExecutionEnvironment executionEnvironment, String string, String string2, String string3, String[] stringArray, String string4, String string5, boolean bl, boolean bl2, boolean bl3) {
        this(null, executionEnvironment, string, string2, string3, stringArray, string4, string5, bl, bl2, bl3);
    }

    public NativeExecutor(String string, String string2, String string3, String[] stringArray, String string4, String string5, boolean bl, boolean bl2) {
        this(ExecutionEnvironmentFactory.getLocal(), string, string2, string3, stringArray, string4, string5, bl, bl2, false);
    }

    public void setX11Forwarding(boolean bl) {
        this.x11forwarding = bl;
    }

    public ExecutorTask execute() throws IOException {
        return this.execute(this.getTab(this.tabName));
    }

    public ExecutorTask execute(InputOutput inputOutput) throws IOException {
        return this.execute(inputOutput, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExecutorTask execute(InputOutput inputOutput, String string) throws IOException {
        ExecutorTask executorTask;
        NativeExecutor nativeExecutor = this;
        synchronized (nativeExecutor) {
            this.io = inputOutput;
            inputOutput.select();
            executorTask = ExecutionEngine.getDefault().execute(this.tabName, (Runnable)this, InputOutput.NULL);
        }
        return executorTask;
    }

    private InputOutput getTab(String string) {
        return IOProvider.getDefault().getIO(string, true);
    }

    public InputOutput getTab() {
        return this.io;
    }

    public String getTabeName() {
        return this.tabName;
    }

    public void setOutputListener(Writer writer) {
        this.outputListener = writer;
    }

    public void setExitValueOverride(String string) {
        this.rcfile = string;
    }

    private final String[] prepareEnvironment() {
        Object object;
        MacroMap macroMap = MacroMap.forExecEnv((ExecutionEnvironment)this.execEnv);
        if (this.envp != null) {
            macroMap.putAll(this.envp);
        }
        macroMap.put("SPRO_EXPAND_ERRORS", "");
        if (this.unbuffer) {
            try {
                object = new File(this.runDir, this.executable);
                if (!((File)object).exists()) {
                    object = new File(this.executable);
                }
                UnbufferSupport.initUnbuffer((ExecutionEnvironment)this.execEnv, (MacroMap)macroMap);
            }
            catch (Exception exception) {
                Exceptions.printStackTrace((Throwable)exception);
            }
        }
        object = macroMap.entrySet();
        String[] stringArray = new String[object.size()];
        int n = 0;
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            stringArray[n++] = (String)entry.getKey() + '=' + (String)entry.getValue();
        }
        return stringArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void run() {
        this.nativeExecution = NativeExecution.getDefault(this.execEnv, this.runDirFile, this.executable, this.arguments, this.prepareEnvironment(), this.unbuffer, this.x11forwarding);
        this.io.setErrVisible(false);
        this.io.setErrSeparated(false);
        if (this.showInput) {
            this.io.setInputVisible(true);
        }
        OutputWriter outputWriter = this.io.getOut();
        if (this.outputListener != null) {
            outputWriter = new OutputWriterProxy(outputWriter, this.outputListener);
        }
        FileObject fileObject = null;
        File file = FileUtil.normalizeFile((File)this.runDirFile);
        if (file != null) {
            fileObject = FileUtil.toFileObject((File)file);
        }
        this.out = this.parseOutputForErrors ? new PrintWriter(new OutputWindowWriter(this.project, this.execEnv, outputWriter, fileObject, this.parseOutputForErrors)) : outputWriter;
        this.err = this.io.getErr();
        this.executionStarted();
        int n = 0;
        long l = System.currentTimeMillis();
        try {
            n = this.nativeExecution.execute(this.out, this.showInput ? this.io.getIn() : null);
        }
        catch (ThreadDeath threadDeath) {
            StatusDisplayer.getDefault().setStatusText(NativeExecutor.getString("MSG_FailedStatus"));
            this.executionFinished(-2, System.currentTimeMillis() - l);
            throw threadDeath;
        }
        catch (InterruptedIOException interruptedIOException) {
            StatusDisplayer.getDefault().setStatusText(NativeExecutor.getString("MSG_FailedStatus"));
            n = -3;
        }
        catch (IOException iOException) {
            StatusDisplayer.getDefault().setStatusText(NativeExecutor.getString("MSG_FailedStatus"));
            n = -4;
        }
        catch (InterruptedException interruptedException) {
            StatusDisplayer.getDefault().setStatusText(NativeExecutor.getString("MSG_FailedStatus"));
            n = -5;
        }
        catch (Throwable throwable) {
            StatusDisplayer.getDefault().setStatusText(NativeExecutor.getString("MSG_FailedStatus"));
            ErrorManager.getDefault().notify(throwable);
            n = -6;
        }
        finally {
            if (this.showInput) {
                this.io.setInputVisible(false);
                try {
                    this.io.getIn().close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
        long l2 = System.currentTimeMillis() - l;
        if (this.rcfile != null) {
            File file2 = null;
            InputStreamReader inputStreamReader = null;
            try {
                char[] cArray;
                int n2;
                file2 = new File(this.rcfile);
                if (file2.exists() && (inputStreamReader = new FileReader(file2)).ready() && (n2 = inputStreamReader.read(cArray = new char[256])) > 0) {
                    n = Integer.parseInt(String.valueOf(cArray, 0, n2 - 1));
                }
            }
            catch (Exception exception) {
            }
            finally {
                if (inputStreamReader != null) {
                    try {
                        inputStreamReader.close();
                    }
                    catch (IOException iOException) {}
                }
                if (file2 != null && file2.exists()) {
                    file2.delete();
                }
            }
        }
        this.executionFinished(n, l2);
    }

    public void stop() {
        NativeExecution nativeExecution = this.nativeExecution;
        if (nativeExecution != null) {
            this.nativeExecution.stop();
        }
    }

    private void executionStarted() {
        if (showHeader) {
            String string = this.execEnv.isLocal() ? this.runDir : HostInfoProvider.getMapper((ExecutionEnvironment)this.execEnv).getRemotePath(this.runDir, true);
            String string2 = MessageFormat.format(NativeExecutor.getString("PRETEXT"), this.exePlusArgsQuoted(this.executable, this.arguments), string);
            this.err.println(string2);
            this.err.println();
        }
        this.fireExecutionStarted();
    }

    private void executionFinished(int n, long l) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(MessageFormat.format(NativeExecutor.getString(n == 0 ? "SUCCESSFUL" : "FAILED"), this.actionName.toUpperCase()));
        stringBuilder.append(" (");
        if (n != 0) {
            stringBuilder.append(MessageFormat.format(NativeExecutor.getString("EXIT_VALUE"), n));
            stringBuilder.append(' ');
        }
        stringBuilder.append(MessageFormat.format(NativeExecutor.getString("TOTAL_TIME"), NativeExecutor.formatTime(l)));
        stringBuilder.append(')');
        PrintWriter printWriter = n == 0 ? this.out : this.err;
        printWriter.println(stringBuilder.toString());
        printWriter.println();
        StatusDisplayer.getDefault().setStatusText(MessageFormat.format(NativeExecutor.getString(n == 0 ? "MSG_SUCCESSFUL" : "MSG_FAILED"), this.actionName));
        this.out.close();
        this.err.close();
        this.fireExecutionFinished(n);
    }

    private static String formatTime(long l) {
        StringBuilder stringBuilder = new StringBuilder();
        long l2 = l / 1000L;
        long l3 = l2 / 60L;
        long l4 = l3 / 60L;
        if (l4 > 0L) {
            stringBuilder.append(" " + l4 + NativeExecutor.getString("HOUR"));
        }
        if (l3 > 0L) {
            stringBuilder.append(" " + (l3 - l4 * 60L) + NativeExecutor.getString("MINUTE"));
        }
        if (l2 > 0L) {
            stringBuilder.append(" " + (l2 - l3 * 60L) + NativeExecutor.getString("SECOND"));
        } else {
            stringBuilder.append(" " + (l - l2 * 1000L) + NativeExecutor.getString("MILLISECOND"));
        }
        return stringBuilder.toString();
    }

    public void addExecutionListener(ExecutionListener executionListener) {
        this.listeners.add(executionListener);
    }

    public void removeExecutionListener(ExecutionListener executionListener) {
        this.listeners.remove(executionListener);
    }

    private void fireExecutionStarted() {
        for (ExecutionListener executionListener : this.listeners) {
            executionListener.executionStarted(-1);
        }
    }

    private void fireExecutionFinished(int n) {
        for (ExecutionListener executionListener : this.listeners) {
            executionListener.executionFinished(n);
        }
    }

    private String exePlusArgsQuoted(String string, String string2) {
        String string3 = string;
        string3 = string2 == null || string2.length() == 0 ? "\"" + string3 + "\"" : "\"" + string3 + " " + string2 + "\"";
        return string3;
    }

    private static String getString(String string) {
        if (bundle == null) {
            bundle = NbBundle.getBundle(NativeExecutor.class);
        }
        return bundle.getString(string);
    }

    private static class OutputWriterProxy
    extends OutputWriter {
        private final OutputWriter original;
        private final Writer duplicate;

        private OutputWriterProxy(OutputWriter outputWriter, Writer writer) {
            super((Writer)outputWriter);
            this.original = outputWriter;
            this.duplicate = writer;
        }

        public void write(char[] cArray, int n, int n2) {
            this.original.write(cArray, n, n2);
            this.doWrite(cArray, n, n2);
        }

        public void println(String string) {
            this.original.println(string);
            this.doWrite(string.toCharArray(), 0, string.length());
            this.doWrite(new char[]{'\n'}, 0, 1);
        }

        public void write(String string, int n, int n2) {
            this.original.write(string, n, n2);
            this.doWrite(string.toCharArray(), n, n2);
        }

        public void write(int n) {
            this.original.write(n);
            this.doWrite(new char[]{(char)n}, 0, 1);
        }

        public void write(char[] cArray) {
            this.original.write(cArray);
            this.doWrite(cArray, 0, cArray.length);
        }

        public void flush() {
            this.original.flush();
            try {
                this.duplicate.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public void close() {
            this.original.close();
            try {
                this.duplicate.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public void reset() throws IOException {
            this.original.reset();
        }

        public void println(String string, OutputListener outputListener) throws IOException {
            this.original.println(string, outputListener);
            this.doWrite(string.toCharArray(), 0, string.length());
            this.doWrite(new char[]{'\n'}, 0, 1);
        }

        private void doWrite(char[] cArray, int n, int n2) {
            try {
                this.duplicate.write(cArray, n, n2);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

