/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.repository.sfs.index;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.netbeans.modules.cnd.repository.sfs.index.ChunkInfo;
import org.netbeans.modules.cnd.repository.sfs.index.FileIndex;
import org.netbeans.modules.cnd.repository.spi.Key;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SynchronizedFileIndex
implements FileIndex {
    private final FileIndex delegate;
    private final ReadWriteLock indexLock = new ReentrantReadWriteLock();

    public SynchronizedFileIndex(FileIndex fileIndex) {
        this.delegate = fileIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        this.indexLock.readLock().lock();
        try {
            int n = this.delegate.size();
            return n;
        }
        finally {
            this.indexLock.readLock().unlock();
        }
    }

    @Override
    public Iterator<Key> getKeySetIterator() {
        return new SyncRemoveIterator<Key>(this.delegate.getKeySetIterator());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<Key> keySet() {
        this.indexLock.readLock().lock();
        try {
            ArrayList<Key> arrayList = new ArrayList<Key>(this.delegate.keySet());
            return arrayList;
        }
        finally {
            this.indexLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int put(Key key, long l, int n) {
        this.indexLock.writeLock().lock();
        try {
            int n2 = this.delegate.put(key, l, n);
            return n2;
        }
        finally {
            this.indexLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int remove(Key key) {
        this.indexLock.writeLock().lock();
        try {
            int n = this.delegate.remove(key);
            return n;
        }
        finally {
            this.indexLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ChunkInfo get(Key key) {
        this.indexLock.readLock().lock();
        try {
            ChunkInfo chunkInfo = this.delegate.get(key);
            return chunkInfo;
        }
        finally {
            this.indexLock.readLock().unlock();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SyncRemoveIterator<K>
    implements Iterator<K> {
        Iterator<K> delegate;

        SyncRemoveIterator(Iterator<K> iterator) {
            this.delegate = iterator;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void remove() {
            SynchronizedFileIndex.this.indexLock.writeLock().lock();
            try {
                this.delegate.remove();
            }
            finally {
                SynchronizedFileIndex.this.indexLock.writeLock().unlock();
            }
        }

        @Override
        public K next() {
            return this.delegate.next();
        }

        @Override
        public boolean hasNext() {
            return this.delegate.hasNext();
        }
    }
}

