/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.repository.sfs;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.netbeans.modules.cnd.repository.sfs.FileStorage;
import org.netbeans.modules.cnd.repository.sfs.IndexedStorageFile;
import org.netbeans.modules.cnd.repository.sfs.WriteStatistics;
import org.netbeans.modules.cnd.repository.sfs.index.ChunkInfo;
import org.netbeans.modules.cnd.repository.spi.Key;
import org.netbeans.modules.cnd.repository.spi.Persistent;
import org.netbeans.modules.cnd.repository.testbench.Stats;

public class DoubleFileStorage
extends FileStorage {
    private Map<Key, Persistent> fickleMap = new HashMap<Key, Persistent>();
    private File basePath;
    private IndexedStorageFile cache_0_dataFile;
    private IndexedStorageFile cache_1_dataFile;
    private boolean defragmenting = false;
    private AtomicBoolean cache_1_dataFileIsActive = new AtomicBoolean(false);

    private boolean getFlag() {
        return this.cache_1_dataFileIsActive.get();
    }

    private IndexedStorageFile getFileByFlag(boolean bl) {
        return bl ? this.cache_1_dataFile : this.cache_0_dataFile;
    }

    private IndexedStorageFile getActive() {
        return this.cache_1_dataFileIsActive.get() ? this.cache_1_dataFile : this.cache_0_dataFile;
    }

    private IndexedStorageFile getPassive() {
        return this.cache_1_dataFileIsActive.get() ? this.cache_0_dataFile : this.cache_1_dataFile;
    }

    public DoubleFileStorage(File file) throws IOException {
        this(file, false);
    }

    DoubleFileStorage(File file, boolean bl) throws IOException {
        this.basePath = file;
        this.cache_0_dataFile = new IndexedStorageFile(file, "cache-0", bl);
        this.cache_1_dataFile = new IndexedStorageFile(file, "cache-1", bl);
        if (this.cache_0_dataFile.getDataFileUsedSize() == 0L && this.cache_1_dataFile.getDataFileUsedSize() == 0L) {
            this.cache_1_dataFileIsActive.set(false);
        } else if (this.cache_0_dataFile.getDataFileUsedSize() != 0L && this.cache_1_dataFile.getDataFileUsedSize() != 0L) {
            this.cache_1_dataFileIsActive.set(this.cache_0_dataFile.getFragmentationPercentage() >= this.cache_1_dataFile.getFragmentationPercentage());
        } else {
            this.cache_1_dataFileIsActive.set(this.cache_0_dataFile.getDataFileUsedSize() != 0L);
        }
    }

    public void close() throws IOException {
        this.cache_0_dataFile.close();
        this.cache_1_dataFile.close();
    }

    public Persistent read(Key key) throws IOException {
        if (Stats.hardFickle && key.getBehavior() == Key.Behavior.LargeAndMutable) {
            return this.fickleMap.get(key);
        }
        boolean bl = this.getFlag();
        Persistent persistent = this.getFileByFlag(bl).read(key);
        if (persistent == null) {
            persistent = this.getFileByFlag(!bl).read(key);
        }
        return persistent;
    }

    public void write(Key key, Persistent persistent) throws IOException {
        WriteStatistics.instance().update(1);
        if (Stats.hardFickle && key.getBehavior() == Key.Behavior.LargeAndMutable) {
            this.fickleMap.put(key, persistent);
            return;
        }
        boolean bl = this.getFlag();
        this.getFileByFlag(bl).write(key, persistent);
        this.getFileByFlag(!bl).remove(key);
    }

    public void remove(Key key) throws IOException {
        if (Stats.hardFickle && key.getBehavior() == Key.Behavior.LargeAndMutable) {
            this.fickleMap.remove(key);
            return;
        }
        boolean bl = this.getFlag();
        this.getFileByFlag(bl).remove(key);
        this.getFileByFlag(!bl).remove(key);
    }

    public boolean defragment(long l) throws IOException {
        boolean bl = false;
        WriteStatistics.instance().update(0);
        if (Stats.traceDefragmentation) {
            System.out.printf(">>> Defragmenting %s; timeout %d ms total fragmentation %d%%\n", this.basePath.getAbsolutePath(), l, this.getFragmentationPercentage());
            System.out.printf("\tActive:  %s\n", this.getActive().getTraceString());
            System.out.printf("\tPassive: %s\n", this.getPassive().getTraceString());
        }
        if (l > 0L && !this.defragmenting && this.getFragmentationPercentage() < Stats.defragmentationThreashold) {
            if (Stats.traceDefragmentation) {
                System.out.printf("\tFragmentation is too low\n", new Object[0]);
            }
            return bl;
        }
        if (!this.defragmenting) {
            this.defragmenting = true;
            this.cache_1_dataFileIsActive.set(!this.cache_1_dataFileIsActive.get());
        }
        bl = this._defragment(l);
        if (this.getPassive().getObjectsCount() == 0) {
            this.defragmenting = false;
        }
        if (Stats.traceDefragmentation) {
            System.out.printf("<<< Defragmenting %s; timeout %d ms total fragmentation %d%%\n", this.basePath.getAbsolutePath(), l, this.getFragmentationPercentage());
            System.out.printf("\tActive:  %s\n", this.getActive().getTraceString());
            System.out.printf("\tPassive: %s\n", this.getPassive().getTraceString());
        }
        return bl;
    }

    private boolean _defragment(long l) throws IOException {
        Object object;
        boolean bl = false;
        long l2 = l > 0L || Stats.traceDefragmentation ? System.currentTimeMillis() : 0L;
        int n = 0;
        boolean bl2 = this.getFlag();
        Iterator<Key> iterator = this.getFileByFlag(!bl2).getKeySetIterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            ChunkInfo chunkInfo = this.getFileByFlag(!bl2).getChunkInfo((Key)object);
            int n2 = chunkInfo.getSize();
            long l3 = this.getFileByFlag(bl2).getSize();
            this.getFileByFlag(bl2).moveDataFromOtherFile(this.getFileByFlag(!bl2).getDataFile(), chunkInfo.getOffset(), n2, l3, (Key)object);
            this.getFileByFlag(!bl2).remove((Key)object);
            if (l <= 0L || ++n % 10 != 0 || System.currentTimeMillis() - l2 < l) continue;
            bl = true;
            break;
        }
        if (Stats.traceDefragmentation) {
            object = iterator.hasNext() ? " finished by timeout" : " completed";
            System.out.printf("\t # defragmentinging %s %s; moved: %d remaining: %d \n", this.getFileByFlag(!bl2).getDataFileName(), object, n, this.getFileByFlag(!bl2).getObjectsCount());
        }
        return bl;
    }

    public void dump(PrintStream printStream) throws IOException {
        printStream.printf("\nDumping DoubleFileStorage; baseFile %s\n", this.basePath.getAbsolutePath());
        printStream.printf("\nActive file:\n", new Object[0]);
        boolean bl = this.getFlag();
        this.getFileByFlag(bl).dump(printStream);
        printStream.printf("\nPassive file:\n", new Object[0]);
        this.getFileByFlag(!bl).dump(printStream);
        printStream.printf("\n", new Object[0]);
    }

    public void dumpSummary(PrintStream printStream) throws IOException {
        printStream.printf("\nDumping DoubleFileStorage; baseFile %s\n", this.basePath.getAbsolutePath());
        printStream.printf("\nActive file:\n", new Object[0]);
        boolean bl = this.getFlag();
        this.getFileByFlag(bl).dumpSummary(printStream);
        printStream.printf("\nPassive file:\n", new Object[0]);
        this.getFileByFlag(!bl).dumpSummary(printStream);
        printStream.printf("\n", new Object[0]);
    }

    public int getFragmentationPercentage() throws IOException {
        boolean bl = this.getFlag();
        long l = this.getFileByFlag(bl).getSize() + this.getFileByFlag(!bl).getSize();
        float f = l - (this.getFileByFlag(bl).getDataFileUsedSize() + this.getFileByFlag(!bl).getDataFileUsedSize());
        float f2 = f * 100.0f / (float)l;
        return Math.round(f2);
    }

    public long getSize() throws IOException {
        boolean bl = this.getFlag();
        return this.getFileByFlag(bl).getSize() + this.getFileByFlag(!bl).getSize();
    }

    public int getObjectsCount() {
        boolean bl = this.getFlag();
        return this.getFileByFlag(bl).getObjectsCount() + this.getFileByFlag(!bl).getObjectsCount();
    }
}

